/*
 * This file has been developed at the University of Munich, Chair for Programming & Software Engineering.
 * 
 * This file is licensed under the Eclipse Public License (EPL) 1.0
 * 
 */
package eu.mdd4soa.smm.statik;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;

/**
 * <!-- begin-user-doc --> The <b>Package</b> for the model. It contains
 * accessors for the meta objects to represent
 * <ul>
 * <li>each class,</li>
 * <li>each feature of each class,</li>
 * <li>each enum,</li>
 * <li>and each data type</li>
 * </ul>
 * <!-- end-user-doc -->
 * 
 * @see eu.mdd4soa.smm.statik.ISMStatikFactory
 * @model kind="package"
 * @generated
 */
public interface ISMStatikPackage extends EPackage {
	/**
	 * The package name. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	String eNAME= "statik";

	/**
	 * The package namespace URI. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	String eNS_URI= "http://www.mdd4soa.eu/ism/statik";

	/**
	 * The package namespace name. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	String eNS_PREFIX= "ismStatik";

	/**
	 * The singleton instance of the package. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @generated
	 */
	ISMStatikPackage eINSTANCE= eu.mdd4soa.smm.statik.impl.ISMStatikPackageImpl.init();

	/**
	 * The meta object id for the '
	 * {@link eu.mdd4soa.smm.statik.impl.SMMTypeImpl <em>SMM Type</em>}' class.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @see eu.mdd4soa.smm.statik.impl.SMMTypeImpl
	 * @see eu.mdd4soa.smm.statik.impl.ISMStatikPackageImpl#getSMMType()
	 * @generated
	 */
	int SMM_TYPE= 0;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int SMM_TYPE__NAME= 0;

	/**
	 * The number of structural features of the '<em>SMM Type</em>' class. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int SMM_TYPE_FEATURE_COUNT= 1;

	/**
	 * The meta object id for the '
	 * {@link eu.mdd4soa.smm.statik.impl.PrimitiveTypeImpl
	 * <em>Primitive Type</em>}' class. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @see eu.mdd4soa.smm.statik.impl.PrimitiveTypeImpl
	 * @see eu.mdd4soa.smm.statik.impl.ISMStatikPackageImpl#getPrimitiveType()
	 * @generated
	 */
	int PRIMITIVE_TYPE= 1;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PRIMITIVE_TYPE__NAME= SMM_TYPE__NAME;

	/**
	 * The number of structural features of the '<em>Primitive Type</em>' class.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PRIMITIVE_TYPE_FEATURE_COUNT= SMM_TYPE_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '
	 * {@link eu.mdd4soa.smm.statik.impl.StringTypeImpl <em>String Type</em>}'
	 * class. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @see eu.mdd4soa.smm.statik.impl.StringTypeImpl
	 * @see eu.mdd4soa.smm.statik.impl.ISMStatikPackageImpl#getStringType()
	 * @generated
	 */
	int STRING_TYPE= 2;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STRING_TYPE__NAME= PRIMITIVE_TYPE__NAME;

	/**
	 * The number of structural features of the '<em>String Type</em>' class.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int STRING_TYPE_FEATURE_COUNT= PRIMITIVE_TYPE_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '
	 * {@link eu.mdd4soa.smm.statik.impl.BooleanTypeImpl <em>Boolean Type</em>}'
	 * class. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @see eu.mdd4soa.smm.statik.impl.BooleanTypeImpl
	 * @see eu.mdd4soa.smm.statik.impl.ISMStatikPackageImpl#getBooleanType()
	 * @generated
	 */
	int BOOLEAN_TYPE= 3;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int BOOLEAN_TYPE__NAME= PRIMITIVE_TYPE__NAME;

	/**
	 * The number of structural features of the '<em>Boolean Type</em>' class.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int BOOLEAN_TYPE_FEATURE_COUNT= PRIMITIVE_TYPE_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '
	 * {@link eu.mdd4soa.smm.statik.impl.IntegerTypeImpl <em>Integer Type</em>}'
	 * class. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @see eu.mdd4soa.smm.statik.impl.IntegerTypeImpl
	 * @see eu.mdd4soa.smm.statik.impl.ISMStatikPackageImpl#getIntegerType()
	 * @generated
	 */
	int INTEGER_TYPE= 4;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INTEGER_TYPE__NAME= PRIMITIVE_TYPE__NAME;

	/**
	 * The number of structural features of the '<em>Integer Type</em>' class.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INTEGER_TYPE_FEATURE_COUNT= PRIMITIVE_TYPE_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '
	 * {@link eu.mdd4soa.smm.statik.impl.RealTypeImpl <em>Real Type</em>}'
	 * class. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @see eu.mdd4soa.smm.statik.impl.RealTypeImpl
	 * @see eu.mdd4soa.smm.statik.impl.ISMStatikPackageImpl#getRealType()
	 * @generated
	 */
	int REAL_TYPE= 5;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int REAL_TYPE__NAME= PRIMITIVE_TYPE__NAME;

	/**
	 * The number of structural features of the '<em>Real Type</em>' class. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int REAL_TYPE_FEATURE_COUNT= PRIMITIVE_TYPE_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '
	 * {@link eu.mdd4soa.smm.statik.impl.DateTypeImpl <em>Date Type</em>}'
	 * class. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @see eu.mdd4soa.smm.statik.impl.DateTypeImpl
	 * @see eu.mdd4soa.smm.statik.impl.ISMStatikPackageImpl#getDateType()
	 * @generated
	 */
	int DATE_TYPE= 6;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DATE_TYPE__NAME= PRIMITIVE_TYPE__NAME;

	/**
	 * The number of structural features of the '<em>Date Type</em>' class. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int DATE_TYPE_FEATURE_COUNT= PRIMITIVE_TYPE_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '
	 * {@link eu.mdd4soa.smm.statik.impl.MessageTypeImpl <em>Message Type</em>}'
	 * class. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @see eu.mdd4soa.smm.statik.impl.MessageTypeImpl
	 * @see eu.mdd4soa.smm.statik.impl.ISMStatikPackageImpl#getMessageType()
	 * @generated
	 */
	int MESSAGE_TYPE= 7;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int MESSAGE_TYPE__NAME= SMM_TYPE__NAME;

	/**
	 * The feature id for the '<em><b>Properties</b></em>' containment reference
	 * list. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int MESSAGE_TYPE__PROPERTIES= SMM_TYPE_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Message Type</em>' class.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int MESSAGE_TYPE_FEATURE_COUNT= SMM_TYPE_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '
	 * {@link eu.mdd4soa.smm.statik.impl.TypedMultiElementImpl
	 * <em>Typed Multi Element</em>}' class. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @see eu.mdd4soa.smm.statik.impl.TypedMultiElementImpl
	 * @see eu.mdd4soa.smm.statik.impl.ISMStatikPackageImpl#getTypedMultiElement()
	 * @generated
	 */
	int TYPED_MULTI_ELEMENT= 20;

	/**
	 * The feature id for the '<em><b>Min</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int TYPED_MULTI_ELEMENT__MIN= 0;

	/**
	 * The feature id for the '<em><b>Max</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int TYPED_MULTI_ELEMENT__MAX= 1;

	/**
	 * The feature id for the '<em><b>Is Ordered</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int TYPED_MULTI_ELEMENT__IS_ORDERED= 2;

	/**
	 * The feature id for the '<em><b>Type</b></em>' reference. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int TYPED_MULTI_ELEMENT__TYPE= 3;

	/**
	 * The number of structural features of the '<em>Typed Multi Element</em>'
	 * class. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int TYPED_MULTI_ELEMENT_FEATURE_COUNT= 4;

	/**
	 * The meta object id for the '
	 * {@link eu.mdd4soa.smm.statik.impl.MessagePropertyImpl
	 * <em>Message Property</em>}' class. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @see eu.mdd4soa.smm.statik.impl.MessagePropertyImpl
	 * @see eu.mdd4soa.smm.statik.impl.ISMStatikPackageImpl#getMessageProperty()
	 * @generated
	 */
	int MESSAGE_PROPERTY= 8;

	/**
	 * The feature id for the '<em><b>Min</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int MESSAGE_PROPERTY__MIN= TYPED_MULTI_ELEMENT__MIN;

	/**
	 * The feature id for the '<em><b>Max</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int MESSAGE_PROPERTY__MAX= TYPED_MULTI_ELEMENT__MAX;

	/**
	 * The feature id for the '<em><b>Is Ordered</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int MESSAGE_PROPERTY__IS_ORDERED= TYPED_MULTI_ELEMENT__IS_ORDERED;

	/**
	 * The feature id for the '<em><b>Type</b></em>' reference. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int MESSAGE_PROPERTY__TYPE= TYPED_MULTI_ELEMENT__TYPE;

	/**
	 * The feature id for the '<em><b>Identifier</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int MESSAGE_PROPERTY__IDENTIFIER= TYPED_MULTI_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Message Property</em>'
	 * class. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int MESSAGE_PROPERTY_FEATURE_COUNT= TYPED_MULTI_ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '
	 * {@link eu.mdd4soa.smm.statik.impl.NullTypeImpl <em>Null Type</em>}'
	 * class. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @see eu.mdd4soa.smm.statik.impl.NullTypeImpl
	 * @see eu.mdd4soa.smm.statik.impl.ISMStatikPackageImpl#getNullType()
	 * @generated
	 */
	int NULL_TYPE= 9;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int NULL_TYPE__NAME= SMM_TYPE__NAME;

	/**
	 * The number of structural features of the '<em>Null Type</em>' class. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int NULL_TYPE_FEATURE_COUNT= SMM_TYPE_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '
	 * {@link eu.mdd4soa.smm.statik.impl.ServiceImpl <em>Service</em>}' class.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @see eu.mdd4soa.smm.statik.impl.ServiceImpl
	 * @see eu.mdd4soa.smm.statik.impl.ISMStatikPackageImpl#getService()
	 * @generated
	 */
	int SERVICE= 10;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int SERVICE__NAME= 0;

	/**
	 * The feature id for the '<em><b>Interface</b></em>' reference. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int SERVICE__INTERFACE= 1;

	/**
	 * The feature id for the '<em><b>Protocol</b></em>' containment reference.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int SERVICE__PROTOCOL= 2;

	/**
	 * The number of structural features of the '<em>Service</em>' class. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int SERVICE_FEATURE_COUNT= 3;

	/**
	 * The meta object id for the '
	 * {@link eu.mdd4soa.smm.statik.impl.InterfaceOperationImpl
	 * <em>Interface Operation</em>}' class. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @see eu.mdd4soa.smm.statik.impl.InterfaceOperationImpl
	 * @see eu.mdd4soa.smm.statik.impl.ISMStatikPackageImpl#getInterfaceOperation()
	 * @generated
	 */
	int INTERFACE_OPERATION= 11;

	/**
	 * The feature id for the '<em><b>Used In</b></em>' reference list. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INTERFACE_OPERATION__USED_IN= 0;

	/**
	 * The feature id for the '<em><b>Parameters</b></em>' containment reference
	 * list. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INTERFACE_OPERATION__PARAMETERS= 1;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INTERFACE_OPERATION__NAME= 2;

	/**
	 * The number of structural features of the '<em>Interface Operation</em>'
	 * class. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INTERFACE_OPERATION_FEATURE_COUNT= 3;

	/**
	 * The meta object id for the '
	 * {@link eu.mdd4soa.smm.statik.impl.InterfaceTypeImpl
	 * <em>Interface Type</em>}' class. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @see eu.mdd4soa.smm.statik.impl.InterfaceTypeImpl
	 * @see eu.mdd4soa.smm.statik.impl.ISMStatikPackageImpl#getInterfaceType()
	 * @generated
	 */
	int INTERFACE_TYPE= 12;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INTERFACE_TYPE__NAME= SMM_TYPE__NAME;

	/**
	 * The feature id for the '<em><b>Used</b></em>' containment reference list.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INTERFACE_TYPE__USED= SMM_TYPE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Implemented</b></em>' containment
	 * reference list. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INTERFACE_TYPE__IMPLEMENTED= SMM_TYPE_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Interface Type</em>' class.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INTERFACE_TYPE_FEATURE_COUNT= SMM_TYPE_FEATURE_COUNT + 2;

	/**
	 * The meta object id for the '
	 * {@link eu.mdd4soa.smm.statik.impl.ProvidedServiceImpl
	 * <em>Provided Service</em>}' class. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @see eu.mdd4soa.smm.statik.impl.ProvidedServiceImpl
	 * @see eu.mdd4soa.smm.statik.impl.ISMStatikPackageImpl#getProvidedService()
	 * @generated
	 */
	int PROVIDED_SERVICE= 13;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PROVIDED_SERVICE__NAME= SERVICE__NAME;

	/**
	 * The feature id for the '<em><b>Interface</b></em>' reference. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PROVIDED_SERVICE__INTERFACE= SERVICE__INTERFACE;

	/**
	 * The feature id for the '<em><b>Protocol</b></em>' containment reference.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PROVIDED_SERVICE__PROTOCOL= SERVICE__PROTOCOL;

	/**
	 * The number of structural features of the '<em>Provided Service</em>'
	 * class. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PROVIDED_SERVICE_FEATURE_COUNT= SERVICE_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '
	 * {@link eu.mdd4soa.smm.statik.impl.RequiredServiceImpl
	 * <em>Required Service</em>}' class. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @see eu.mdd4soa.smm.statik.impl.RequiredServiceImpl
	 * @see eu.mdd4soa.smm.statik.impl.ISMStatikPackageImpl#getRequiredService()
	 * @generated
	 */
	int REQUIRED_SERVICE= 14;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int REQUIRED_SERVICE__NAME= SERVICE__NAME;

	/**
	 * The feature id for the '<em><b>Interface</b></em>' reference. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int REQUIRED_SERVICE__INTERFACE= SERVICE__INTERFACE;

	/**
	 * The feature id for the '<em><b>Protocol</b></em>' containment reference.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int REQUIRED_SERVICE__PROTOCOL= SERVICE__PROTOCOL;

	/**
	 * The number of structural features of the '<em>Required Service</em>'
	 * class. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int REQUIRED_SERVICE_FEATURE_COUNT= SERVICE_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '
	 * {@link eu.mdd4soa.smm.statik.impl.InterfaceParameterImpl
	 * <em>Interface Parameter</em>}' class. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @see eu.mdd4soa.smm.statik.impl.InterfaceParameterImpl
	 * @see eu.mdd4soa.smm.statik.impl.ISMStatikPackageImpl#getInterfaceParameter()
	 * @generated
	 */
	int INTERFACE_PARAMETER= 15;

	/**
	 * The feature id for the '<em><b>Min</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INTERFACE_PARAMETER__MIN= TYPED_MULTI_ELEMENT__MIN;

	/**
	 * The feature id for the '<em><b>Max</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INTERFACE_PARAMETER__MAX= TYPED_MULTI_ELEMENT__MAX;

	/**
	 * The feature id for the '<em><b>Is Ordered</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INTERFACE_PARAMETER__IS_ORDERED= TYPED_MULTI_ELEMENT__IS_ORDERED;

	/**
	 * The feature id for the '<em><b>Type</b></em>' reference. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INTERFACE_PARAMETER__TYPE= TYPED_MULTI_ELEMENT__TYPE;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INTERFACE_PARAMETER__NAME= TYPED_MULTI_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Operation</b></em>' container reference.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INTERFACE_PARAMETER__OPERATION= TYPED_MULTI_ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Interface Parameter</em>'
	 * class. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int INTERFACE_PARAMETER_FEATURE_COUNT= TYPED_MULTI_ELEMENT_FEATURE_COUNT + 2;

	/**
	 * The meta object id for the '
	 * {@link eu.mdd4soa.smm.statik.impl.InParameterImpl <em>In Parameter</em>}'
	 * class. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @see eu.mdd4soa.smm.statik.impl.InParameterImpl
	 * @see eu.mdd4soa.smm.statik.impl.ISMStatikPackageImpl#getInParameter()
	 * @generated
	 */
	int IN_PARAMETER= 16;

	/**
	 * The feature id for the '<em><b>Min</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int IN_PARAMETER__MIN= INTERFACE_PARAMETER__MIN;

	/**
	 * The feature id for the '<em><b>Max</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int IN_PARAMETER__MAX= INTERFACE_PARAMETER__MAX;

	/**
	 * The feature id for the '<em><b>Is Ordered</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int IN_PARAMETER__IS_ORDERED= INTERFACE_PARAMETER__IS_ORDERED;

	/**
	 * The feature id for the '<em><b>Type</b></em>' reference. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int IN_PARAMETER__TYPE= INTERFACE_PARAMETER__TYPE;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int IN_PARAMETER__NAME= INTERFACE_PARAMETER__NAME;

	/**
	 * The feature id for the '<em><b>Operation</b></em>' container reference.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int IN_PARAMETER__OPERATION= INTERFACE_PARAMETER__OPERATION;

	/**
	 * The number of structural features of the '<em>In Parameter</em>' class.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int IN_PARAMETER_FEATURE_COUNT= INTERFACE_PARAMETER_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '
	 * {@link eu.mdd4soa.smm.statik.impl.OutParameterImpl
	 * <em>Out Parameter</em>}' class. <!-- begin-user-doc --> <!-- end-user-doc
	 * -->
	 * 
	 * @see eu.mdd4soa.smm.statik.impl.OutParameterImpl
	 * @see eu.mdd4soa.smm.statik.impl.ISMStatikPackageImpl#getOutParameter()
	 * @generated
	 */
	int OUT_PARAMETER= 17;

	/**
	 * The feature id for the '<em><b>Min</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int OUT_PARAMETER__MIN= INTERFACE_PARAMETER__MIN;

	/**
	 * The feature id for the '<em><b>Max</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int OUT_PARAMETER__MAX= INTERFACE_PARAMETER__MAX;

	/**
	 * The feature id for the '<em><b>Is Ordered</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int OUT_PARAMETER__IS_ORDERED= INTERFACE_PARAMETER__IS_ORDERED;

	/**
	 * The feature id for the '<em><b>Type</b></em>' reference. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int OUT_PARAMETER__TYPE= INTERFACE_PARAMETER__TYPE;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int OUT_PARAMETER__NAME= INTERFACE_PARAMETER__NAME;

	/**
	 * The feature id for the '<em><b>Operation</b></em>' container reference.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int OUT_PARAMETER__OPERATION= INTERFACE_PARAMETER__OPERATION;

	/**
	 * The number of structural features of the '<em>Out Parameter</em>' class.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int OUT_PARAMETER_FEATURE_COUNT= INTERFACE_PARAMETER_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '
	 * {@link eu.mdd4soa.smm.statik.impl.ParticipantImpl <em>Participant</em>}'
	 * class. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @see eu.mdd4soa.smm.statik.impl.ParticipantImpl
	 * @see eu.mdd4soa.smm.statik.impl.ISMStatikPackageImpl#getParticipant()
	 * @generated
	 */
	int PARTICIPANT= 18;

	/**
	 * The feature id for the '<em><b>Partners</b></em>' containment reference
	 * list. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PARTICIPANT__PARTNERS= 0;

	/**
	 * The feature id for the '<em><b>Behaviours</b></em>' containment reference
	 * list. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PARTICIPANT__BEHAVIOURS= 1;

	/**
	 * The feature id for the '<em><b>Types</b></em>' containment reference
	 * list. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PARTICIPANT__TYPES= 2;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PARTICIPANT__NAME= 3;

	/**
	 * The number of structural features of the '<em>Participant</em>' class.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int PARTICIPANT_FEATURE_COUNT= 4;


	/**
	 * The meta object id for the '
	 * {@link eu.mdd4soa.smm.statik.impl.ExceptionTypeImpl
	 * <em>Exception Type</em>}' class. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @see eu.mdd4soa.smm.statik.impl.ExceptionTypeImpl
	 * @see eu.mdd4soa.smm.statik.impl.ISMStatikPackageImpl#getExceptionType()
	 * @generated
	 */
	int EXCEPTION_TYPE= 19;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int EXCEPTION_TYPE__NAME= SMM_TYPE__NAME;

	/**
	 * The number of structural features of the '<em>Exception Type</em>' class.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 * @ordered
	 */
	int EXCEPTION_TYPE_FEATURE_COUNT= SMM_TYPE_FEATURE_COUNT + 0;


	/**
	 * Returns the meta object for class '{@link eu.mdd4soa.smm.statik.SMMType
	 * <em>SMM Type</em>}'. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @return the meta object for class '<em>SMM Type</em>'.
	 * @see eu.mdd4soa.smm.statik.SMMType
	 * @generated
	 */
	EClass getSMMType();

	/**
	 * Returns the meta object for the attribute '
	 * {@link eu.mdd4soa.smm.statik.SMMType#getName <em>Name</em>}'. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @return the meta object for the attribute '<em>Name</em>'.
	 * @see eu.mdd4soa.smm.statik.SMMType#getName()
	 * @see #getSMMType()
	 * @generated
	 */
	EAttribute getSMMType_Name();

	/**
	 * Returns the meta object for class '
	 * {@link eu.mdd4soa.smm.statik.PrimitiveType <em>Primitive Type</em>}'.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @return the meta object for class '<em>Primitive Type</em>'.
	 * @see eu.mdd4soa.smm.statik.PrimitiveType
	 * @generated
	 */
	EClass getPrimitiveType();

	/**
	 * Returns the meta object for class '
	 * {@link eu.mdd4soa.smm.statik.StringType <em>String Type</em>}'. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @return the meta object for class '<em>String Type</em>'.
	 * @see eu.mdd4soa.smm.statik.StringType
	 * @generated
	 */
	EClass getStringType();

	/**
	 * Returns the meta object for class '
	 * {@link eu.mdd4soa.smm.statik.BooleanType <em>Boolean Type</em>}'. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @return the meta object for class '<em>Boolean Type</em>'.
	 * @see eu.mdd4soa.smm.statik.BooleanType
	 * @generated
	 */
	EClass getBooleanType();

	/**
	 * Returns the meta object for class '
	 * {@link eu.mdd4soa.smm.statik.IntegerType <em>Integer Type</em>}'. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @return the meta object for class '<em>Integer Type</em>'.
	 * @see eu.mdd4soa.smm.statik.IntegerType
	 * @generated
	 */
	EClass getIntegerType();

	/**
	 * Returns the meta object for class '{@link eu.mdd4soa.smm.statik.RealType
	 * <em>Real Type</em>}'. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @return the meta object for class '<em>Real Type</em>'.
	 * @see eu.mdd4soa.smm.statik.RealType
	 * @generated
	 */
	EClass getRealType();

	/**
	 * Returns the meta object for class '{@link eu.mdd4soa.smm.statik.DateType
	 * <em>Date Type</em>}'. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @return the meta object for class '<em>Date Type</em>'.
	 * @see eu.mdd4soa.smm.statik.DateType
	 * @generated
	 */
	EClass getDateType();

	/**
	 * Returns the meta object for class '
	 * {@link eu.mdd4soa.smm.statik.MessageType <em>Message Type</em>}'. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @return the meta object for class '<em>Message Type</em>'.
	 * @see eu.mdd4soa.smm.statik.MessageType
	 * @generated
	 */
	EClass getMessageType();

	/**
	 * Returns the meta object for the containment reference list '
	 * {@link eu.mdd4soa.smm.statik.MessageType#getProperties
	 * <em>Properties</em>}'. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @return the meta object for the containment reference list '
	 *         <em>Properties</em>'.
	 * @see eu.mdd4soa.smm.statik.MessageType#getProperties()
	 * @see #getMessageType()
	 * @generated
	 */
	EReference getMessageType_Properties();

	/**
	 * Returns the meta object for class '
	 * {@link eu.mdd4soa.smm.statik.MessageProperty <em>Message Property</em>}'.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @return the meta object for class '<em>Message Property</em>'.
	 * @see eu.mdd4soa.smm.statik.MessageProperty
	 * @generated
	 */
	EClass getMessageProperty();

	/**
	 * Returns the meta object for the attribute '
	 * {@link eu.mdd4soa.smm.statik.MessageProperty#getIdentifier
	 * <em>Identifier</em>}'. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @return the meta object for the attribute '<em>Identifier</em>'.
	 * @see eu.mdd4soa.smm.statik.MessageProperty#getIdentifier()
	 * @see #getMessageProperty()
	 * @generated
	 */
	EAttribute getMessageProperty_Identifier();

	/**
	 * Returns the meta object for class '{@link eu.mdd4soa.smm.statik.NullType
	 * <em>Null Type</em>}'. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @return the meta object for class '<em>Null Type</em>'.
	 * @see eu.mdd4soa.smm.statik.NullType
	 * @generated
	 */
	EClass getNullType();

	/**
	 * Returns the meta object for class '{@link eu.mdd4soa.smm.statik.Service
	 * <em>Service</em>}'. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @return the meta object for class '<em>Service</em>'.
	 * @see eu.mdd4soa.smm.statik.Service
	 * @generated
	 */
	EClass getService();

	/**
	 * Returns the meta object for the attribute '
	 * {@link eu.mdd4soa.smm.statik.Service#getName <em>Name</em>}'. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @return the meta object for the attribute '<em>Name</em>'.
	 * @see eu.mdd4soa.smm.statik.Service#getName()
	 * @see #getService()
	 * @generated
	 */
	EAttribute getService_Name();

	/**
	 * Returns the meta object for the reference '
	 * {@link eu.mdd4soa.smm.statik.Service#getInterface <em>Interface</em>}'.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @return the meta object for the reference '<em>Interface</em>'.
	 * @see eu.mdd4soa.smm.statik.Service#getInterface()
	 * @see #getService()
	 * @generated
	 */
	EReference getService_Interface();

	/**
	 * Returns the meta object for the containment reference '
	 * {@link eu.mdd4soa.smm.statik.Service#getProtocol <em>Protocol</em>}'.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @return the meta object for the containment reference '<em>Protocol</em>
	 *         '.
	 * @see eu.mdd4soa.smm.statik.Service#getProtocol()
	 * @see #getService()
	 * @generated
	 */
	EReference getService_Protocol();

	/**
	 * Returns the meta object for class '
	 * {@link eu.mdd4soa.smm.statik.InterfaceOperation
	 * <em>Interface Operation</em>}'. <!-- begin-user-doc --> <!-- end-user-doc
	 * -->
	 * 
	 * @return the meta object for class '<em>Interface Operation</em>'.
	 * @see eu.mdd4soa.smm.statik.InterfaceOperation
	 * @generated
	 */
	EClass getInterfaceOperation();

	/**
	 * Returns the meta object for the reference list '
	 * {@link eu.mdd4soa.smm.statik.InterfaceOperation#getUsedIn
	 * <em>Used In</em>}'. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @return the meta object for the reference list '<em>Used In</em>'.
	 * @see eu.mdd4soa.smm.statik.InterfaceOperation#getUsedIn()
	 * @see #getInterfaceOperation()
	 * @generated
	 */
	EReference getInterfaceOperation_UsedIn();

	/**
	 * Returns the meta object for the containment reference list '
	 * {@link eu.mdd4soa.smm.statik.InterfaceOperation#getParameters
	 * <em>Parameters</em>}'. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @return the meta object for the containment reference list '
	 *         <em>Parameters</em>'.
	 * @see eu.mdd4soa.smm.statik.InterfaceOperation#getParameters()
	 * @see #getInterfaceOperation()
	 * @generated
	 */
	EReference getInterfaceOperation_Parameters();

	/**
	 * Returns the meta object for the attribute '
	 * {@link eu.mdd4soa.smm.statik.InterfaceOperation#getName <em>Name</em>}'.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @return the meta object for the attribute '<em>Name</em>'.
	 * @see eu.mdd4soa.smm.statik.InterfaceOperation#getName()
	 * @see #getInterfaceOperation()
	 * @generated
	 */
	EAttribute getInterfaceOperation_Name();

	/**
	 * Returns the meta object for class '
	 * {@link eu.mdd4soa.smm.statik.InterfaceType <em>Interface Type</em>}'.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @return the meta object for class '<em>Interface Type</em>'.
	 * @see eu.mdd4soa.smm.statik.InterfaceType
	 * @generated
	 */
	EClass getInterfaceType();

	/**
	 * Returns the meta object for the containment reference list '
	 * {@link eu.mdd4soa.smm.statik.InterfaceType#getUsed <em>Used</em>}'. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @return the meta object for the containment reference list '<em>Used</em>
	 *         '.
	 * @see eu.mdd4soa.smm.statik.InterfaceType#getUsed()
	 * @see #getInterfaceType()
	 * @generated
	 */
	EReference getInterfaceType_Used();

	/**
	 * Returns the meta object for the containment reference list '
	 * {@link eu.mdd4soa.smm.statik.InterfaceType#getImplemented
	 * <em>Implemented</em>}'. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @return the meta object for the containment reference list '
	 *         <em>Implemented</em>'.
	 * @see eu.mdd4soa.smm.statik.InterfaceType#getImplemented()
	 * @see #getInterfaceType()
	 * @generated
	 */
	EReference getInterfaceType_Implemented();

	/**
	 * Returns the meta object for class '
	 * {@link eu.mdd4soa.smm.statik.ProvidedService <em>Provided Service</em>}'.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @return the meta object for class '<em>Provided Service</em>'.
	 * @see eu.mdd4soa.smm.statik.ProvidedService
	 * @generated
	 */
	EClass getProvidedService();

	/**
	 * Returns the meta object for class '
	 * {@link eu.mdd4soa.smm.statik.RequiredService <em>Required Service</em>}'.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @return the meta object for class '<em>Required Service</em>'.
	 * @see eu.mdd4soa.smm.statik.RequiredService
	 * @generated
	 */
	EClass getRequiredService();

	/**
	 * Returns the meta object for class '
	 * {@link eu.mdd4soa.smm.statik.InterfaceParameter
	 * <em>Interface Parameter</em>}'. <!-- begin-user-doc --> <!-- end-user-doc
	 * -->
	 * 
	 * @return the meta object for class '<em>Interface Parameter</em>'.
	 * @see eu.mdd4soa.smm.statik.InterfaceParameter
	 * @generated
	 */
	EClass getInterfaceParameter();

	/**
	 * Returns the meta object for the attribute '
	 * {@link eu.mdd4soa.smm.statik.InterfaceParameter#getName <em>Name</em>}'.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @return the meta object for the attribute '<em>Name</em>'.
	 * @see eu.mdd4soa.smm.statik.InterfaceParameter#getName()
	 * @see #getInterfaceParameter()
	 * @generated
	 */
	EAttribute getInterfaceParameter_Name();

	/**
	 * Returns the meta object for the container reference '
	 * {@link eu.mdd4soa.smm.statik.InterfaceParameter#getOperation
	 * <em>Operation</em>}'. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @return the meta object for the container reference '<em>Operation</em>'.
	 * @see eu.mdd4soa.smm.statik.InterfaceParameter#getOperation()
	 * @see #getInterfaceParameter()
	 * @generated
	 */
	EReference getInterfaceParameter_Operation();

	/**
	 * Returns the meta object for class '
	 * {@link eu.mdd4soa.smm.statik.InParameter <em>In Parameter</em>}'. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @return the meta object for class '<em>In Parameter</em>'.
	 * @see eu.mdd4soa.smm.statik.InParameter
	 * @generated
	 */
	EClass getInParameter();

	/**
	 * Returns the meta object for class '
	 * {@link eu.mdd4soa.smm.statik.OutParameter <em>Out Parameter</em>}'. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @return the meta object for class '<em>Out Parameter</em>'.
	 * @see eu.mdd4soa.smm.statik.OutParameter
	 * @generated
	 */
	EClass getOutParameter();

	/**
	 * Returns the meta object for class '
	 * {@link eu.mdd4soa.smm.statik.Participant <em>Participant</em>}'. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @return the meta object for class '<em>Participant</em>'.
	 * @see eu.mdd4soa.smm.statik.Participant
	 * @generated
	 */
	EClass getParticipant();

	/**
	 * Returns the meta object for the containment reference list '
	 * {@link eu.mdd4soa.smm.statik.Participant#getPartners <em>Partners</em>}'.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @return the meta object for the containment reference list '
	 *         <em>Partners</em>'.
	 * @see eu.mdd4soa.smm.statik.Participant#getPartners()
	 * @see #getParticipant()
	 * @generated
	 */
	EReference getParticipant_Partners();

	/**
	 * Returns the meta object for the containment reference list '
	 * {@link eu.mdd4soa.smm.statik.Participant#getBehaviours
	 * <em>Behaviours</em>}'. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @return the meta object for the containment reference list '
	 *         <em>Behaviours</em>'.
	 * @see eu.mdd4soa.smm.statik.Participant#getBehaviours()
	 * @see #getParticipant()
	 * @generated
	 */
	EReference getParticipant_Behaviours();

	/**
	 * Returns the meta object for the containment reference list '
	 * {@link eu.mdd4soa.smm.statik.Participant#getTypes <em>Types</em>}'. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @return the meta object for the containment reference list '
	 *         <em>Types</em>'.
	 * @see eu.mdd4soa.smm.statik.Participant#getTypes()
	 * @see #getParticipant()
	 * @generated
	 */
	EReference getParticipant_Types();

	/**
	 * Returns the meta object for the attribute '
	 * {@link eu.mdd4soa.smm.statik.Participant#getName <em>Name</em>}'. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @return the meta object for the attribute '<em>Name</em>'.
	 * @see eu.mdd4soa.smm.statik.Participant#getName()
	 * @see #getParticipant()
	 * @generated
	 */
	EAttribute getParticipant_Name();

	/**
	 * Returns the meta object for class '
	 * {@link eu.mdd4soa.smm.statik.ExceptionType <em>Exception Type</em>}'.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @return the meta object for class '<em>Exception Type</em>'.
	 * @see eu.mdd4soa.smm.statik.ExceptionType
	 * @generated
	 */
	EClass getExceptionType();

	/**
	 * Returns the meta object for class '
	 * {@link eu.mdd4soa.smm.statik.TypedMultiElement
	 * <em>Typed Multi Element</em>}'. <!-- begin-user-doc --> <!-- end-user-doc
	 * -->
	 * 
	 * @return the meta object for class '<em>Typed Multi Element</em>'.
	 * @see eu.mdd4soa.smm.statik.TypedMultiElement
	 * @generated
	 */
	EClass getTypedMultiElement();

	/**
	 * Returns the meta object for the attribute '
	 * {@link eu.mdd4soa.smm.statik.TypedMultiElement#getMin <em>Min</em>}'.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @return the meta object for the attribute '<em>Min</em>'.
	 * @see eu.mdd4soa.smm.statik.TypedMultiElement#getMin()
	 * @see #getTypedMultiElement()
	 * @generated
	 */
	EAttribute getTypedMultiElement_Min();

	/**
	 * Returns the meta object for the attribute '
	 * {@link eu.mdd4soa.smm.statik.TypedMultiElement#getMax <em>Max</em>}'.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @return the meta object for the attribute '<em>Max</em>'.
	 * @see eu.mdd4soa.smm.statik.TypedMultiElement#getMax()
	 * @see #getTypedMultiElement()
	 * @generated
	 */
	EAttribute getTypedMultiElement_Max();

	/**
	 * Returns the meta object for the attribute '
	 * {@link eu.mdd4soa.smm.statik.TypedMultiElement#isIsOrdered
	 * <em>Is Ordered</em>}'. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @return the meta object for the attribute '<em>Is Ordered</em>'.
	 * @see eu.mdd4soa.smm.statik.TypedMultiElement#isIsOrdered()
	 * @see #getTypedMultiElement()
	 * @generated
	 */
	EAttribute getTypedMultiElement_IsOrdered();

	/**
	 * Returns the meta object for the reference '
	 * {@link eu.mdd4soa.smm.statik.TypedMultiElement#getType <em>Type</em>}'.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @return the meta object for the reference '<em>Type</em>'.
	 * @see eu.mdd4soa.smm.statik.TypedMultiElement#getType()
	 * @see #getTypedMultiElement()
	 * @generated
	 */
	EReference getTypedMultiElement_Type();

	/**
	 * Returns the factory that creates the instances of the model. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @return the factory that creates the instances of the model.
	 * @generated
	 */
	ISMStatikFactory getISMStatikFactory();

	/**
	 * <!-- begin-user-doc --> Defines literals for the meta objects that
	 * represent
	 * <ul>
	 * <li>each class,</li>
	 * <li>each feature of each class,</li>
	 * <li>each enum,</li>
	 * <li>and each data type</li>
	 * </ul>
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	interface Literals {
		/**
		 * The meta object literal for the '
		 * {@link eu.mdd4soa.smm.statik.impl.SMMTypeImpl <em>SMM Type</em>}'
		 * class. <!-- begin-user-doc --> <!-- end-user-doc -->
		 * 
		 * @see eu.mdd4soa.smm.statik.impl.SMMTypeImpl
		 * @see eu.mdd4soa.smm.statik.impl.ISMStatikPackageImpl#getSMMType()
		 * @generated
		 */
		EClass SMM_TYPE= eINSTANCE.getSMMType();

		/**
		 * The meta object literal for the '<em><b>Name</b></em>' attribute
		 * feature. <!-- begin-user-doc --> <!-- end-user-doc -->
		 * 
		 * @generated
		 */
		EAttribute SMM_TYPE__NAME= eINSTANCE.getSMMType_Name();

		/**
		 * The meta object literal for the '
		 * {@link eu.mdd4soa.smm.statik.impl.PrimitiveTypeImpl
		 * <em>Primitive Type</em>}' class. <!-- begin-user-doc --> <!--
		 * end-user-doc -->
		 * 
		 * @see eu.mdd4soa.smm.statik.impl.PrimitiveTypeImpl
		 * @see eu.mdd4soa.smm.statik.impl.ISMStatikPackageImpl#getPrimitiveType()
		 * @generated
		 */
		EClass PRIMITIVE_TYPE= eINSTANCE.getPrimitiveType();

		/**
		 * The meta object literal for the '
		 * {@link eu.mdd4soa.smm.statik.impl.StringTypeImpl
		 * <em>String Type</em>}' class. <!-- begin-user-doc --> <!--
		 * end-user-doc -->
		 * 
		 * @see eu.mdd4soa.smm.statik.impl.StringTypeImpl
		 * @see eu.mdd4soa.smm.statik.impl.ISMStatikPackageImpl#getStringType()
		 * @generated
		 */
		EClass STRING_TYPE= eINSTANCE.getStringType();

		/**
		 * The meta object literal for the '
		 * {@link eu.mdd4soa.smm.statik.impl.BooleanTypeImpl
		 * <em>Boolean Type</em>}' class. <!-- begin-user-doc --> <!--
		 * end-user-doc -->
		 * 
		 * @see eu.mdd4soa.smm.statik.impl.BooleanTypeImpl
		 * @see eu.mdd4soa.smm.statik.impl.ISMStatikPackageImpl#getBooleanType()
		 * @generated
		 */
		EClass BOOLEAN_TYPE= eINSTANCE.getBooleanType();

		/**
		 * The meta object literal for the '
		 * {@link eu.mdd4soa.smm.statik.impl.IntegerTypeImpl
		 * <em>Integer Type</em>}' class. <!-- begin-user-doc --> <!--
		 * end-user-doc -->
		 * 
		 * @see eu.mdd4soa.smm.statik.impl.IntegerTypeImpl
		 * @see eu.mdd4soa.smm.statik.impl.ISMStatikPackageImpl#getIntegerType()
		 * @generated
		 */
		EClass INTEGER_TYPE= eINSTANCE.getIntegerType();

		/**
		 * The meta object literal for the '
		 * {@link eu.mdd4soa.smm.statik.impl.RealTypeImpl <em>Real Type</em>}'
		 * class. <!-- begin-user-doc --> <!-- end-user-doc -->
		 * 
		 * @see eu.mdd4soa.smm.statik.impl.RealTypeImpl
		 * @see eu.mdd4soa.smm.statik.impl.ISMStatikPackageImpl#getRealType()
		 * @generated
		 */
		EClass REAL_TYPE= eINSTANCE.getRealType();

		/**
		 * The meta object literal for the '
		 * {@link eu.mdd4soa.smm.statik.impl.DateTypeImpl <em>Date Type</em>}'
		 * class. <!-- begin-user-doc --> <!-- end-user-doc -->
		 * 
		 * @see eu.mdd4soa.smm.statik.impl.DateTypeImpl
		 * @see eu.mdd4soa.smm.statik.impl.ISMStatikPackageImpl#getDateType()
		 * @generated
		 */
		EClass DATE_TYPE= eINSTANCE.getDateType();

		/**
		 * The meta object literal for the '
		 * {@link eu.mdd4soa.smm.statik.impl.MessageTypeImpl
		 * <em>Message Type</em>}' class. <!-- begin-user-doc --> <!--
		 * end-user-doc -->
		 * 
		 * @see eu.mdd4soa.smm.statik.impl.MessageTypeImpl
		 * @see eu.mdd4soa.smm.statik.impl.ISMStatikPackageImpl#getMessageType()
		 * @generated
		 */
		EClass MESSAGE_TYPE= eINSTANCE.getMessageType();

		/**
		 * The meta object literal for the '<em><b>Properties</b></em>'
		 * containment reference list feature. <!-- begin-user-doc --> <!--
		 * end-user-doc -->
		 * 
		 * @generated
		 */
		EReference MESSAGE_TYPE__PROPERTIES= eINSTANCE.getMessageType_Properties();

		/**
		 * The meta object literal for the '
		 * {@link eu.mdd4soa.smm.statik.impl.MessagePropertyImpl
		 * <em>Message Property</em>}' class. <!-- begin-user-doc --> <!--
		 * end-user-doc -->
		 * 
		 * @see eu.mdd4soa.smm.statik.impl.MessagePropertyImpl
		 * @see eu.mdd4soa.smm.statik.impl.ISMStatikPackageImpl#getMessageProperty()
		 * @generated
		 */
		EClass MESSAGE_PROPERTY= eINSTANCE.getMessageProperty();

		/**
		 * The meta object literal for the '<em><b>Identifier</b></em>'
		 * attribute feature. <!-- begin-user-doc --> <!-- end-user-doc -->
		 * 
		 * @generated
		 */
		EAttribute MESSAGE_PROPERTY__IDENTIFIER= eINSTANCE.getMessageProperty_Identifier();

		/**
		 * The meta object literal for the '
		 * {@link eu.mdd4soa.smm.statik.impl.NullTypeImpl <em>Null Type</em>}'
		 * class. <!-- begin-user-doc --> <!-- end-user-doc -->
		 * 
		 * @see eu.mdd4soa.smm.statik.impl.NullTypeImpl
		 * @see eu.mdd4soa.smm.statik.impl.ISMStatikPackageImpl#getNullType()
		 * @generated
		 */
		EClass NULL_TYPE= eINSTANCE.getNullType();

		/**
		 * The meta object literal for the '
		 * {@link eu.mdd4soa.smm.statik.impl.ServiceImpl <em>Service</em>}'
		 * class. <!-- begin-user-doc --> <!-- end-user-doc -->
		 * 
		 * @see eu.mdd4soa.smm.statik.impl.ServiceImpl
		 * @see eu.mdd4soa.smm.statik.impl.ISMStatikPackageImpl#getService()
		 * @generated
		 */
		EClass SERVICE= eINSTANCE.getService();

		/**
		 * The meta object literal for the '<em><b>Name</b></em>' attribute
		 * feature. <!-- begin-user-doc --> <!-- end-user-doc -->
		 * 
		 * @generated
		 */
		EAttribute SERVICE__NAME= eINSTANCE.getService_Name();

		/**
		 * The meta object literal for the '<em><b>Interface</b></em>' reference
		 * feature. <!-- begin-user-doc --> <!-- end-user-doc -->
		 * 
		 * @generated
		 */
		EReference SERVICE__INTERFACE= eINSTANCE.getService_Interface();

		/**
		 * The meta object literal for the '<em><b>Protocol</b></em>'
		 * containment reference feature. <!-- begin-user-doc --> <!--
		 * end-user-doc -->
		 * 
		 * @generated
		 */
		EReference SERVICE__PROTOCOL= eINSTANCE.getService_Protocol();

		/**
		 * The meta object literal for the '
		 * {@link eu.mdd4soa.smm.statik.impl.InterfaceOperationImpl
		 * <em>Interface Operation</em>}' class. <!-- begin-user-doc --> <!--
		 * end-user-doc -->
		 * 
		 * @see eu.mdd4soa.smm.statik.impl.InterfaceOperationImpl
		 * @see eu.mdd4soa.smm.statik.impl.ISMStatikPackageImpl#getInterfaceOperation()
		 * @generated
		 */
		EClass INTERFACE_OPERATION= eINSTANCE.getInterfaceOperation();

		/**
		 * The meta object literal for the '<em><b>Used In</b></em>' reference
		 * list feature. <!-- begin-user-doc --> <!-- end-user-doc -->
		 * 
		 * @generated
		 */
		EReference INTERFACE_OPERATION__USED_IN= eINSTANCE.getInterfaceOperation_UsedIn();

		/**
		 * The meta object literal for the '<em><b>Parameters</b></em>'
		 * containment reference list feature. <!-- begin-user-doc --> <!--
		 * end-user-doc -->
		 * 
		 * @generated
		 */
		EReference INTERFACE_OPERATION__PARAMETERS= eINSTANCE.getInterfaceOperation_Parameters();

		/**
		 * The meta object literal for the '<em><b>Name</b></em>' attribute
		 * feature. <!-- begin-user-doc --> <!-- end-user-doc -->
		 * 
		 * @generated
		 */
		EAttribute INTERFACE_OPERATION__NAME= eINSTANCE.getInterfaceOperation_Name();

		/**
		 * The meta object literal for the '
		 * {@link eu.mdd4soa.smm.statik.impl.InterfaceTypeImpl
		 * <em>Interface Type</em>}' class. <!-- begin-user-doc --> <!--
		 * end-user-doc -->
		 * 
		 * @see eu.mdd4soa.smm.statik.impl.InterfaceTypeImpl
		 * @see eu.mdd4soa.smm.statik.impl.ISMStatikPackageImpl#getInterfaceType()
		 * @generated
		 */
		EClass INTERFACE_TYPE= eINSTANCE.getInterfaceType();

		/**
		 * The meta object literal for the '<em><b>Used</b></em>' containment
		 * reference list feature. <!-- begin-user-doc --> <!-- end-user-doc -->
		 * 
		 * @generated
		 */
		EReference INTERFACE_TYPE__USED= eINSTANCE.getInterfaceType_Used();

		/**
		 * The meta object literal for the '<em><b>Implemented</b></em>'
		 * containment reference list feature. <!-- begin-user-doc --> <!--
		 * end-user-doc -->
		 * 
		 * @generated
		 */
		EReference INTERFACE_TYPE__IMPLEMENTED= eINSTANCE.getInterfaceType_Implemented();

		/**
		 * The meta object literal for the '
		 * {@link eu.mdd4soa.smm.statik.impl.ProvidedServiceImpl
		 * <em>Provided Service</em>}' class. <!-- begin-user-doc --> <!--
		 * end-user-doc -->
		 * 
		 * @see eu.mdd4soa.smm.statik.impl.ProvidedServiceImpl
		 * @see eu.mdd4soa.smm.statik.impl.ISMStatikPackageImpl#getProvidedService()
		 * @generated
		 */
		EClass PROVIDED_SERVICE= eINSTANCE.getProvidedService();

		/**
		 * The meta object literal for the '
		 * {@link eu.mdd4soa.smm.statik.impl.RequiredServiceImpl
		 * <em>Required Service</em>}' class. <!-- begin-user-doc --> <!--
		 * end-user-doc -->
		 * 
		 * @see eu.mdd4soa.smm.statik.impl.RequiredServiceImpl
		 * @see eu.mdd4soa.smm.statik.impl.ISMStatikPackageImpl#getRequiredService()
		 * @generated
		 */
		EClass REQUIRED_SERVICE= eINSTANCE.getRequiredService();

		/**
		 * The meta object literal for the '
		 * {@link eu.mdd4soa.smm.statik.impl.InterfaceParameterImpl
		 * <em>Interface Parameter</em>}' class. <!-- begin-user-doc --> <!--
		 * end-user-doc -->
		 * 
		 * @see eu.mdd4soa.smm.statik.impl.InterfaceParameterImpl
		 * @see eu.mdd4soa.smm.statik.impl.ISMStatikPackageImpl#getInterfaceParameter()
		 * @generated
		 */
		EClass INTERFACE_PARAMETER= eINSTANCE.getInterfaceParameter();

		/**
		 * The meta object literal for the '<em><b>Name</b></em>' attribute
		 * feature. <!-- begin-user-doc --> <!-- end-user-doc -->
		 * 
		 * @generated
		 */
		EAttribute INTERFACE_PARAMETER__NAME= eINSTANCE.getInterfaceParameter_Name();

		/**
		 * The meta object literal for the '<em><b>Operation</b></em>' container
		 * reference feature. <!-- begin-user-doc --> <!-- end-user-doc -->
		 * 
		 * @generated
		 */
		EReference INTERFACE_PARAMETER__OPERATION= eINSTANCE.getInterfaceParameter_Operation();

		/**
		 * The meta object literal for the '
		 * {@link eu.mdd4soa.smm.statik.impl.InParameterImpl
		 * <em>In Parameter</em>}' class. <!-- begin-user-doc --> <!--
		 * end-user-doc -->
		 * 
		 * @see eu.mdd4soa.smm.statik.impl.InParameterImpl
		 * @see eu.mdd4soa.smm.statik.impl.ISMStatikPackageImpl#getInParameter()
		 * @generated
		 */
		EClass IN_PARAMETER= eINSTANCE.getInParameter();

		/**
		 * The meta object literal for the '
		 * {@link eu.mdd4soa.smm.statik.impl.OutParameterImpl
		 * <em>Out Parameter</em>}' class. <!-- begin-user-doc --> <!--
		 * end-user-doc -->
		 * 
		 * @see eu.mdd4soa.smm.statik.impl.OutParameterImpl
		 * @see eu.mdd4soa.smm.statik.impl.ISMStatikPackageImpl#getOutParameter()
		 * @generated
		 */
		EClass OUT_PARAMETER= eINSTANCE.getOutParameter();

		/**
		 * The meta object literal for the '
		 * {@link eu.mdd4soa.smm.statik.impl.ParticipantImpl
		 * <em>Participant</em>}' class. <!-- begin-user-doc --> <!--
		 * end-user-doc -->
		 * 
		 * @see eu.mdd4soa.smm.statik.impl.ParticipantImpl
		 * @see eu.mdd4soa.smm.statik.impl.ISMStatikPackageImpl#getParticipant()
		 * @generated
		 */
		EClass PARTICIPANT= eINSTANCE.getParticipant();

		/**
		 * The meta object literal for the '<em><b>Partners</b></em>'
		 * containment reference list feature. <!-- begin-user-doc --> <!--
		 * end-user-doc -->
		 * 
		 * @generated
		 */
		EReference PARTICIPANT__PARTNERS= eINSTANCE.getParticipant_Partners();

		/**
		 * The meta object literal for the '<em><b>Behaviours</b></em>'
		 * containment reference list feature. <!-- begin-user-doc --> <!--
		 * end-user-doc -->
		 * 
		 * @generated
		 */
		EReference PARTICIPANT__BEHAVIOURS= eINSTANCE.getParticipant_Behaviours();

		/**
		 * The meta object literal for the '<em><b>Types</b></em>' containment
		 * reference list feature. <!-- begin-user-doc --> <!-- end-user-doc -->
		 * 
		 * @generated
		 */
		EReference PARTICIPANT__TYPES= eINSTANCE.getParticipant_Types();

		/**
		 * The meta object literal for the '<em><b>Name</b></em>' attribute
		 * feature. <!-- begin-user-doc --> <!-- end-user-doc -->
		 * 
		 * @generated
		 */
		EAttribute PARTICIPANT__NAME= eINSTANCE.getParticipant_Name();

		/**
		 * The meta object literal for the '
		 * {@link eu.mdd4soa.smm.statik.impl.ExceptionTypeImpl
		 * <em>Exception Type</em>}' class. <!-- begin-user-doc --> <!--
		 * end-user-doc -->
		 * 
		 * @see eu.mdd4soa.smm.statik.impl.ExceptionTypeImpl
		 * @see eu.mdd4soa.smm.statik.impl.ISMStatikPackageImpl#getExceptionType()
		 * @generated
		 */
		EClass EXCEPTION_TYPE= eINSTANCE.getExceptionType();

		/**
		 * The meta object literal for the '
		 * {@link eu.mdd4soa.smm.statik.impl.TypedMultiElementImpl
		 * <em>Typed Multi Element</em>}' class. <!-- begin-user-doc --> <!--
		 * end-user-doc -->
		 * 
		 * @see eu.mdd4soa.smm.statik.impl.TypedMultiElementImpl
		 * @see eu.mdd4soa.smm.statik.impl.ISMStatikPackageImpl#getTypedMultiElement()
		 * @generated
		 */
		EClass TYPED_MULTI_ELEMENT= eINSTANCE.getTypedMultiElement();

		/**
		 * The meta object literal for the '<em><b>Min</b></em>' attribute
		 * feature. <!-- begin-user-doc --> <!-- end-user-doc -->
		 * 
		 * @generated
		 */
		EAttribute TYPED_MULTI_ELEMENT__MIN= eINSTANCE.getTypedMultiElement_Min();

		/**
		 * The meta object literal for the '<em><b>Max</b></em>' attribute
		 * feature. <!-- begin-user-doc --> <!-- end-user-doc -->
		 * 
		 * @generated
		 */
		EAttribute TYPED_MULTI_ELEMENT__MAX= eINSTANCE.getTypedMultiElement_Max();

		/**
		 * The meta object literal for the '<em><b>Is Ordered</b></em>'
		 * attribute feature. <!-- begin-user-doc --> <!-- end-user-doc -->
		 * 
		 * @generated
		 */
		EAttribute TYPED_MULTI_ELEMENT__IS_ORDERED= eINSTANCE.getTypedMultiElement_IsOrdered();

		/**
		 * The meta object literal for the '<em><b>Type</b></em>' reference
		 * feature. <!-- begin-user-doc --> <!-- end-user-doc -->
		 * 
		 * @generated
		 */
		EReference TYPED_MULTI_ELEMENT__TYPE= eINSTANCE.getTypedMultiElement_Type();

	}

} // ISMStatikPackage
