/*
 * This file has been developed at the University of Munich, Chair for Programming & Software Engineering.
 * 
 * This file is licensed under the Eclipse Public License (EPL) 1.0
 * 
 */
package eu.mdd4soa.smm.statik;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;

import eu.mdd4soa.smm.behaviour.ServiceInteraction;

/**
 * <!-- begin-user-doc --> A representation of the model object '
 * <em><b>Interface Operation</b></em>'.
 * 
 * @extends Comparable<InterfaceOperation> <!-- end-user-doc -->
 * 
 *          <p>
 *          The following features are supported:
 *          <ul>
 *          <li>{@link eu.mdd4soa.smm.statik.InterfaceOperation#getUsedIn <em>
 *          Used In</em>}</li>
 *          <li>{@link eu.mdd4soa.smm.statik.InterfaceOperation#getParameters
 *          <em>Parameters</em>}</li>
 *          <li>{@link eu.mdd4soa.smm.statik.InterfaceOperation#getName <em>Name
 *          </em>}</li>
 *          </ul>
 *          </p>
 * 
 * @see eu.mdd4soa.smm.statik.ISMStatikPackage#getInterfaceOperation()
 * @model
 * @generated
 */
public interface InterfaceOperation extends EObject, Comparable<InterfaceOperation> {
	/**
	 * Returns the value of the '<em><b>Used In</b></em>' reference list. The
	 * list contents are of type
	 * {@link eu.mdd4soa.smm.behaviour.ServiceInteraction}. It is bidirectional
	 * and its opposite is '
	 * {@link eu.mdd4soa.smm.behaviour.ServiceInteraction#getOperation
	 * <em>Operation</em>}'. <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Used In</em>' reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * 
	 * @return the value of the '<em>Used In</em>' reference list.
	 * @see eu.mdd4soa.smm.statik.ISMStatikPackage#getInterfaceOperation_UsedIn()
	 * @see eu.mdd4soa.smm.behaviour.ServiceInteraction#getOperation
	 * @model opposite="operation"
	 * @generated
	 */
	EList<ServiceInteraction> getUsedIn();

	/**
	 * Returns the value of the '<em><b>Parameters</b></em>' containment
	 * reference list. The list contents are of type
	 * {@link eu.mdd4soa.smm.statik.InterfaceParameter}. It is bidirectional and
	 * its opposite is '
	 * {@link eu.mdd4soa.smm.statik.InterfaceParameter#getOperation
	 * <em>Operation</em>}'. <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Parameters</em>' containment reference list
	 * isn't clear, there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * 
	 * @return the value of the '<em>Parameters</em>' containment reference
	 *         list.
	 * @see eu.mdd4soa.smm.statik.ISMStatikPackage#getInterfaceOperation_Parameters()
	 * @see eu.mdd4soa.smm.statik.InterfaceParameter#getOperation
	 * @model opposite="operation" containment="true"
	 * @generated
	 */
	EList<InterfaceParameter> getParameters();

	/**
	 * Returns the value of the '<em><b>Name</b></em>' attribute. <!--
	 * begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Name</em>' attribute isn't clear, there really
	 * should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * 
	 * @return the value of the '<em>Name</em>' attribute.
	 * @see #setName(String)
	 * @see eu.mdd4soa.smm.statik.ISMStatikPackage#getInterfaceOperation_Name()
	 * @model
	 * @generated
	 */
	String getName();

	/**
	 * Sets the value of the '
	 * {@link eu.mdd4soa.smm.statik.InterfaceOperation#getName <em>Name</em>}'
	 * attribute. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @param value the new value of the '<em>Name</em>' attribute.
	 * @see #getName()
	 * @generated
	 */
	void setName(String value);

} // InterfaceOperation
