/*
 * This file has been developed at the University of Munich, Chair for Programming & Software Engineering.
 * 
 * This file is licensed under the Eclipse Public License (EPL) 1.0
 * 
 */
package eu.mdd4soa.smm.statik;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;

import eu.mdd4soa.smm.behaviour.ServiceActivity;

/**
 * <!-- begin-user-doc --> A representation of the model object '
 * <em><b>Participant</b></em>'. <!-- end-user-doc -->
 * 
 * <p>
 * The following features are supported:
 * <ul>
 * <li>{@link eu.mdd4soa.smm.statik.Participant#getPartners <em>Partners</em>}</li>
 * <li>{@link eu.mdd4soa.smm.statik.Participant#getBehaviours <em>Behaviours
 * </em>}</li>
 * <li>{@link eu.mdd4soa.smm.statik.Participant#getTypes <em>Types</em>}</li>
 * <li>{@link eu.mdd4soa.smm.statik.Participant#getName <em>Name</em>}</li>
 * </ul>
 * </p>
 * 
 * @see eu.mdd4soa.smm.statik.ISMStatikPackage#getParticipant()
 * @model
 * @generated
 */
public interface Participant extends EObject {
	/**
	 * Returns the value of the '<em><b>Partners</b></em>' containment reference
	 * list. The list contents are of type {@link eu.mdd4soa.smm.statik.Service}
	 * . <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Partners</em>' containment reference list
	 * isn't clear, there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * 
	 * @return the value of the '<em>Partners</em>' containment reference list.
	 * @see eu.mdd4soa.smm.statik.ISMStatikPackage#getParticipant_Partners()
	 * @model containment="true"
	 * @generated
	 */
	EList<Service> getPartners();

	/**
	 * Returns the value of the '<em><b>Behaviours</b></em>' containment
	 * reference list. The list contents are of type
	 * {@link eu.mdd4soa.smm.behaviour.ServiceActivity}. It is bidirectional and
	 * its opposite is '
	 * {@link eu.mdd4soa.smm.behaviour.ServiceActivity#getParticipant
	 * <em>Participant</em>}'. <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Behaviours</em>' containment reference list
	 * isn't clear, there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * 
	 * @return the value of the '<em>Behaviours</em>' containment reference
	 *         list.
	 * @see eu.mdd4soa.smm.statik.ISMStatikPackage#getParticipant_Behaviours()
	 * @see eu.mdd4soa.smm.behaviour.ServiceActivity#getParticipant
	 * @model opposite="participant" containment="true"
	 * @generated
	 */
	EList<ServiceActivity> getBehaviours();

	/**
	 * Returns the value of the '<em><b>Types</b></em>' containment reference
	 * list. The list contents are of type {@link eu.mdd4soa.smm.statik.SMMType}
	 * . <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Types</em>' containment reference list isn't
	 * clear, there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * 
	 * @return the value of the '<em>Types</em>' containment reference list.
	 * @see eu.mdd4soa.smm.statik.ISMStatikPackage#getParticipant_Types()
	 * @model containment="true"
	 * @generated
	 */
	EList<SMMType> getTypes();

	/**
	 * Returns the value of the '<em><b>Name</b></em>' attribute. <!--
	 * begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Name</em>' attribute isn't clear, there really
	 * should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * 
	 * @return the value of the '<em>Name</em>' attribute.
	 * @see #setName(String)
	 * @see eu.mdd4soa.smm.statik.ISMStatikPackage#getParticipant_Name()
	 * @model
	 * @generated
	 */
	String getName();

	/**
	 * Sets the value of the '{@link eu.mdd4soa.smm.statik.Participant#getName
	 * <em>Name</em>}' attribute. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @param value the new value of the '<em>Name</em>' attribute.
	 * @see #getName()
	 * @generated
	 */
	void setName(String value);

} // Participant
