/*
 * This file has been developed at the University of Munich, Chair for Programming & Software Engineering.
 * 
 * This file is licensed under the Eclipse Public License (EPL) 1.0
 * 
 */
package eu.mdd4soa.smm.statik.impl;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.impl.EFactoryImpl;
import org.eclipse.emf.ecore.plugin.EcorePlugin;

import eu.mdd4soa.smm.statik.BooleanType;
import eu.mdd4soa.smm.statik.DateType;
import eu.mdd4soa.smm.statik.ExceptionType;
import eu.mdd4soa.smm.statik.ISMStatikFactory;
import eu.mdd4soa.smm.statik.ISMStatikPackage;
import eu.mdd4soa.smm.statik.InParameter;
import eu.mdd4soa.smm.statik.IntegerType;
import eu.mdd4soa.smm.statik.InterfaceOperation;
import eu.mdd4soa.smm.statik.InterfaceType;
import eu.mdd4soa.smm.statik.MessageProperty;
import eu.mdd4soa.smm.statik.MessageType;
import eu.mdd4soa.smm.statik.NullType;
import eu.mdd4soa.smm.statik.OutParameter;
import eu.mdd4soa.smm.statik.Participant;
import eu.mdd4soa.smm.statik.ProvidedService;
import eu.mdd4soa.smm.statik.RealType;
import eu.mdd4soa.smm.statik.RequiredService;
import eu.mdd4soa.smm.statik.StringType;

/**
 * <!-- begin-user-doc --> An implementation of the model <b>Factory</b>. <!--
 * end-user-doc -->
 * 
 * @generated
 */
public class ISMStatikFactoryImpl extends EFactoryImpl implements ISMStatikFactory {
	/**
	 * Creates the default factory implementation. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @generated
	 */
	public static ISMStatikFactory init() {
		try {
			ISMStatikFactory theISMStatikFactory= (ISMStatikFactory) EPackage.Registry.INSTANCE.getEFactory("http://www.mdd4soa.eu/ism/statik");
			if (theISMStatikFactory != null) {
				return theISMStatikFactory;
			}
		} catch (Exception exception) {
			EcorePlugin.INSTANCE.log(exception);
		}
		return new ISMStatikFactoryImpl();
	}

	/**
	 * Creates an instance of the factory. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @generated
	 */
	public ISMStatikFactoryImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public EObject create(EClass eClass) {
		switch (eClass.getClassifierID()) {
			case ISMStatikPackage.STRING_TYPE:
				return createStringType();
			case ISMStatikPackage.BOOLEAN_TYPE:
				return createBooleanType();
			case ISMStatikPackage.INTEGER_TYPE:
				return createIntegerType();
			case ISMStatikPackage.REAL_TYPE:
				return createRealType();
			case ISMStatikPackage.DATE_TYPE:
				return createDateType();
			case ISMStatikPackage.MESSAGE_TYPE:
				return createMessageType();
			case ISMStatikPackage.MESSAGE_PROPERTY:
				return createMessageProperty();
			case ISMStatikPackage.NULL_TYPE:
				return createNullType();
			case ISMStatikPackage.INTERFACE_OPERATION:
				return createInterfaceOperation();
			case ISMStatikPackage.INTERFACE_TYPE:
				return createInterfaceType();
			case ISMStatikPackage.PROVIDED_SERVICE:
				return createProvidedService();
			case ISMStatikPackage.REQUIRED_SERVICE:
				return createRequiredService();
			case ISMStatikPackage.IN_PARAMETER:
				return createInParameter();
			case ISMStatikPackage.OUT_PARAMETER:
				return createOutParameter();
			case ISMStatikPackage.PARTICIPANT:
				return createParticipant();
			case ISMStatikPackage.EXCEPTION_TYPE:
				return createExceptionType();
			default:
				throw new IllegalArgumentException("The class '" + eClass.getName() + "' is not a valid classifier");
		}
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public StringType createStringType() {
		StringTypeImpl stringType= new StringTypeImpl();
		return stringType;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public BooleanType createBooleanType() {
		BooleanTypeImpl booleanType= new BooleanTypeImpl();
		return booleanType;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public IntegerType createIntegerType() {
		IntegerTypeImpl integerType= new IntegerTypeImpl();
		return integerType;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public RealType createRealType() {
		RealTypeImpl realType= new RealTypeImpl();
		return realType;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public DateType createDateType() {
		DateTypeImpl dateType= new DateTypeImpl();
		return dateType;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public MessageType createMessageType() {
		MessageTypeImpl messageType= new MessageTypeImpl();
		return messageType;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public MessageProperty createMessageProperty() {
		MessagePropertyImpl messageProperty= new MessagePropertyImpl();
		return messageProperty;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public NullType createNullType() {
		NullTypeImpl nullType= new NullTypeImpl();
		return nullType;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public InterfaceOperation createInterfaceOperation() {
		InterfaceOperationImpl interfaceOperation= new InterfaceOperationImpl();
		return interfaceOperation;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public InterfaceType createInterfaceType() {
		InterfaceTypeImpl interfaceType= new InterfaceTypeImpl();
		return interfaceType;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public ProvidedService createProvidedService() {
		ProvidedServiceImpl providedService= new ProvidedServiceImpl();
		return providedService;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public RequiredService createRequiredService() {
		RequiredServiceImpl requiredService= new RequiredServiceImpl();
		return requiredService;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public InParameter createInParameter() {
		InParameterImpl inParameter= new InParameterImpl();
		return inParameter;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public OutParameter createOutParameter() {
		OutParameterImpl outParameter= new OutParameterImpl();
		return outParameter;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public Participant createParticipant() {
		ParticipantImpl participant= new ParticipantImpl();
		return participant;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public ExceptionType createExceptionType() {
		ExceptionTypeImpl exceptionType= new ExceptionTypeImpl();
		return exceptionType;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public ISMStatikPackage getISMStatikPackage() {
		return (ISMStatikPackage) getEPackage();
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @deprecated
	 * @generated
	 */
	@Deprecated
	public static ISMStatikPackage getPackage() {
		return ISMStatikPackage.eINSTANCE;
	}

} // ISMStatikFactoryImpl
