/*
 * This file has been developed at the University of Munich, Chair for Programming & Software Engineering.
 * 
 * This file is licensed under the Eclipse Public License (EPL) 1.0
 * 
 */
package eu.mdd4soa.smm.statik.impl;

import java.util.Collection;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.EObjectImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentWithInverseEList;
import org.eclipse.emf.ecore.util.EObjectWithInverseResolvingEList;
import org.eclipse.emf.ecore.util.InternalEList;

import eu.mdd4soa.smm.behaviour.ISMBehaviourPackage;
import eu.mdd4soa.smm.behaviour.ServiceInteraction;
import eu.mdd4soa.smm.statik.ISMStatikPackage;
import eu.mdd4soa.smm.statik.InterfaceOperation;
import eu.mdd4soa.smm.statik.InterfaceParameter;

/**
 * <!-- begin-user-doc --> An implementation of the model object '
 * <em><b>Interface Operation</b></em>'. <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 * <li>{@link eu.mdd4soa.smm.statik.impl.InterfaceOperationImpl#getUsedIn <em>
 * Used In</em>}</li>
 * <li>{@link eu.mdd4soa.smm.statik.impl.InterfaceOperationImpl#getParameters
 * <em>Parameters</em>}</li>
 * <li>{@link eu.mdd4soa.smm.statik.impl.InterfaceOperationImpl#getName <em>Name
 * </em>}</li>
 * </ul>
 * </p>
 * 
 * @generated
 */
public class InterfaceOperationImpl extends EObjectImpl implements InterfaceOperation {
	/**
	 * The cached value of the '{@link #getUsedIn() <em>Used In</em>}' reference
	 * list. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @see #getUsedIn()
	 * @generated
	 * @ordered
	 */
	protected EList<ServiceInteraction> usedIn;

	/**
	 * The cached value of the '{@link #getParameters() <em>Parameters</em>}'
	 * containment reference list. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @see #getParameters()
	 * @generated
	 * @ordered
	 */
	protected EList<InterfaceParameter> parameters;

	/**
	 * The default value of the '{@link #getName() <em>Name</em>}' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @see #getName()
	 * @generated
	 * @ordered
	 */
	protected static final String NAME_EDEFAULT= null;

	/**
	 * The cached value of the '{@link #getName() <em>Name</em>}' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @see #getName()
	 * @generated
	 * @ordered
	 */
	protected String name= NAME_EDEFAULT;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected InterfaceOperationImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return ISMStatikPackage.Literals.INTERFACE_OPERATION;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public EList<ServiceInteraction> getUsedIn() {
		if (usedIn == null) {
			usedIn= new EObjectWithInverseResolvingEList<ServiceInteraction>(ServiceInteraction.class, this,
					ISMStatikPackage.INTERFACE_OPERATION__USED_IN, ISMBehaviourPackage.SERVICE_INTERACTION__OPERATION);
		}
		return usedIn;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public EList<InterfaceParameter> getParameters() {
		if (parameters == null) {
			parameters= new EObjectContainmentWithInverseEList<InterfaceParameter>(InterfaceParameter.class, this,
					ISMStatikPackage.INTERFACE_OPERATION__PARAMETERS, ISMStatikPackage.INTERFACE_PARAMETER__OPERATION);
		}
		return parameters;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public String getName() {
		return name;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public void setName(String newName) {
		String oldName= name;
		name= newName;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ISMStatikPackage.INTERFACE_OPERATION__NAME, oldName, name));
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case ISMStatikPackage.INTERFACE_OPERATION__USED_IN:
				return ((InternalEList<InternalEObject>) (InternalEList<?>) getUsedIn()).basicAdd(otherEnd, msgs);
			case ISMStatikPackage.INTERFACE_OPERATION__PARAMETERS:
				return ((InternalEList<InternalEObject>) (InternalEList<?>) getParameters()).basicAdd(otherEnd, msgs);
		}
		return super.eInverseAdd(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case ISMStatikPackage.INTERFACE_OPERATION__USED_IN:
				return ((InternalEList<?>) getUsedIn()).basicRemove(otherEnd, msgs);
			case ISMStatikPackage.INTERFACE_OPERATION__PARAMETERS:
				return ((InternalEList<?>) getParameters()).basicRemove(otherEnd, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case ISMStatikPackage.INTERFACE_OPERATION__USED_IN:
				return getUsedIn();
			case ISMStatikPackage.INTERFACE_OPERATION__PARAMETERS:
				return getParameters();
			case ISMStatikPackage.INTERFACE_OPERATION__NAME:
				return getName();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case ISMStatikPackage.INTERFACE_OPERATION__USED_IN:
				getUsedIn().clear();
				getUsedIn().addAll((Collection<? extends ServiceInteraction>) newValue);
				return;
			case ISMStatikPackage.INTERFACE_OPERATION__PARAMETERS:
				getParameters().clear();
				getParameters().addAll((Collection<? extends InterfaceParameter>) newValue);
				return;
			case ISMStatikPackage.INTERFACE_OPERATION__NAME:
				setName((String) newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case ISMStatikPackage.INTERFACE_OPERATION__USED_IN:
				getUsedIn().clear();
				return;
			case ISMStatikPackage.INTERFACE_OPERATION__PARAMETERS:
				getParameters().clear();
				return;
			case ISMStatikPackage.INTERFACE_OPERATION__NAME:
				setName(NAME_EDEFAULT);
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case ISMStatikPackage.INTERFACE_OPERATION__USED_IN:
				return usedIn != null && !usedIn.isEmpty();
			case ISMStatikPackage.INTERFACE_OPERATION__PARAMETERS:
				return parameters != null && !parameters.isEmpty();
			case ISMStatikPackage.INTERFACE_OPERATION__NAME:
				return NAME_EDEFAULT == null ? name != null : !NAME_EDEFAULT.equals(name);
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy())
			return super.toString();

		StringBuffer result= new StringBuffer(super.toString());
		result.append(" (name: ");
		result.append(name);
		result.append(')');
		return result.toString();
	}

	/**
	 * @generated NOT
	 */
	@Override
	public int compareTo(InterfaceOperation o) {

		if (o == null)
			return 1;

		if (getName() == null)
			return 1;

		return getName().compareTo(o.getName());
	}

} // InterfaceOperationImpl
