/*
 * This file has been developed at the University of Munich, Chair for Programming & Software Engineering.
 * 
 * This file is licensed under the Eclipse Public License (EPL) 1.0
 * 
 */
package eu.mdd4soa.smm.statik.impl;

import java.util.Collection;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.EObjectImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.EObjectContainmentWithInverseEList;
import org.eclipse.emf.ecore.util.InternalEList;

import eu.mdd4soa.smm.behaviour.ISMBehaviourPackage;
import eu.mdd4soa.smm.behaviour.ServiceActivity;
import eu.mdd4soa.smm.statik.ISMStatikPackage;
import eu.mdd4soa.smm.statik.Participant;
import eu.mdd4soa.smm.statik.SMMType;
import eu.mdd4soa.smm.statik.Service;

/**
 * <!-- begin-user-doc --> An implementation of the model object '
 * <em><b>Participant</b></em>'. <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 * <li>{@link eu.mdd4soa.smm.statik.impl.ParticipantImpl#getPartners <em>
 * Partners</em>}</li>
 * <li>{@link eu.mdd4soa.smm.statik.impl.ParticipantImpl#getBehaviours <em>
 * Behaviours</em>}</li>
 * <li>{@link eu.mdd4soa.smm.statik.impl.ParticipantImpl#getTypes <em>Types
 * </em>}</li>
 * <li>{@link eu.mdd4soa.smm.statik.impl.ParticipantImpl#getName <em>Name</em>}</li>
 * </ul>
 * </p>
 * 
 * @generated
 */
public class ParticipantImpl extends EObjectImpl implements Participant {
	/**
	 * The cached value of the '{@link #getPartners() <em>Partners</em>}'
	 * containment reference list. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @see #getPartners()
	 * @generated
	 * @ordered
	 */
	protected EList<Service> partners;

	/**
	 * The cached value of the '{@link #getBehaviours() <em>Behaviours</em>}'
	 * containment reference list. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @see #getBehaviours()
	 * @generated
	 * @ordered
	 */
	protected EList<ServiceActivity> behaviours;

	/**
	 * The cached value of the '{@link #getTypes() <em>Types</em>}' containment
	 * reference list. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @see #getTypes()
	 * @generated
	 * @ordered
	 */
	protected EList<SMMType> types;

	/**
	 * The default value of the '{@link #getName() <em>Name</em>}' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @see #getName()
	 * @generated
	 * @ordered
	 */
	protected static final String NAME_EDEFAULT= null;

	/**
	 * The cached value of the '{@link #getName() <em>Name</em>}' attribute.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @see #getName()
	 * @generated
	 * @ordered
	 */
	protected String name= NAME_EDEFAULT;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected ParticipantImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return ISMStatikPackage.Literals.PARTICIPANT;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public EList<Service> getPartners() {
		if (partners == null) {
			partners= new EObjectContainmentEList<Service>(Service.class, this, ISMStatikPackage.PARTICIPANT__PARTNERS);
		}
		return partners;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public EList<ServiceActivity> getBehaviours() {
		if (behaviours == null) {
			behaviours= new EObjectContainmentWithInverseEList<ServiceActivity>(ServiceActivity.class, this,
					ISMStatikPackage.PARTICIPANT__BEHAVIOURS, ISMBehaviourPackage.SERVICE_ACTIVITY__PARTICIPANT);
		}
		return behaviours;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public EList<SMMType> getTypes() {
		if (types == null) {
			types= new EObjectContainmentEList<SMMType>(SMMType.class, this, ISMStatikPackage.PARTICIPANT__TYPES);
		}
		return types;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public String getName() {
		return name;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public void setName(String newName) {
		String oldName= name;
		name= newName;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ISMStatikPackage.PARTICIPANT__NAME, oldName, name));
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case ISMStatikPackage.PARTICIPANT__BEHAVIOURS:
				return ((InternalEList<InternalEObject>) (InternalEList<?>) getBehaviours()).basicAdd(otherEnd, msgs);
		}
		return super.eInverseAdd(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case ISMStatikPackage.PARTICIPANT__PARTNERS:
				return ((InternalEList<?>) getPartners()).basicRemove(otherEnd, msgs);
			case ISMStatikPackage.PARTICIPANT__BEHAVIOURS:
				return ((InternalEList<?>) getBehaviours()).basicRemove(otherEnd, msgs);
			case ISMStatikPackage.PARTICIPANT__TYPES:
				return ((InternalEList<?>) getTypes()).basicRemove(otherEnd, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case ISMStatikPackage.PARTICIPANT__PARTNERS:
				return getPartners();
			case ISMStatikPackage.PARTICIPANT__BEHAVIOURS:
				return getBehaviours();
			case ISMStatikPackage.PARTICIPANT__TYPES:
				return getTypes();
			case ISMStatikPackage.PARTICIPANT__NAME:
				return getName();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case ISMStatikPackage.PARTICIPANT__PARTNERS:
				getPartners().clear();
				getPartners().addAll((Collection<? extends Service>) newValue);
				return;
			case ISMStatikPackage.PARTICIPANT__BEHAVIOURS:
				getBehaviours().clear();
				getBehaviours().addAll((Collection<? extends ServiceActivity>) newValue);
				return;
			case ISMStatikPackage.PARTICIPANT__TYPES:
				getTypes().clear();
				getTypes().addAll((Collection<? extends SMMType>) newValue);
				return;
			case ISMStatikPackage.PARTICIPANT__NAME:
				setName((String) newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case ISMStatikPackage.PARTICIPANT__PARTNERS:
				getPartners().clear();
				return;
			case ISMStatikPackage.PARTICIPANT__BEHAVIOURS:
				getBehaviours().clear();
				return;
			case ISMStatikPackage.PARTICIPANT__TYPES:
				getTypes().clear();
				return;
			case ISMStatikPackage.PARTICIPANT__NAME:
				setName(NAME_EDEFAULT);
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case ISMStatikPackage.PARTICIPANT__PARTNERS:
				return partners != null && !partners.isEmpty();
			case ISMStatikPackage.PARTICIPANT__BEHAVIOURS:
				return behaviours != null && !behaviours.isEmpty();
			case ISMStatikPackage.PARTICIPANT__TYPES:
				return types != null && !types.isEmpty();
			case ISMStatikPackage.PARTICIPANT__NAME:
				return NAME_EDEFAULT == null ? name != null : !NAME_EDEFAULT.equals(name);
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy())
			return super.toString();

		StringBuffer result= new StringBuffer(super.toString());
		result.append(" (name: ");
		result.append(name);
		result.append(')');
		return result.toString();
	}

} // ParticipantImpl
