/*
 * This file has been developed at the University of Munich, Chair for Programming & Software Engineering.
 * 
 * This file is licensed under the Eclipse Public License (EPL) 1.0
 * 
 */
package eu.mdd4soa.smm.statik.util;

import java.util.List;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;

import eu.mdd4soa.smm.statik.BooleanType;
import eu.mdd4soa.smm.statik.DateType;
import eu.mdd4soa.smm.statik.ExceptionType;
import eu.mdd4soa.smm.statik.ISMStatikPackage;
import eu.mdd4soa.smm.statik.InParameter;
import eu.mdd4soa.smm.statik.IntegerType;
import eu.mdd4soa.smm.statik.InterfaceOperation;
import eu.mdd4soa.smm.statik.InterfaceParameter;
import eu.mdd4soa.smm.statik.InterfaceType;
import eu.mdd4soa.smm.statik.MessageProperty;
import eu.mdd4soa.smm.statik.MessageType;
import eu.mdd4soa.smm.statik.NullType;
import eu.mdd4soa.smm.statik.OutParameter;
import eu.mdd4soa.smm.statik.Participant;
import eu.mdd4soa.smm.statik.PrimitiveType;
import eu.mdd4soa.smm.statik.ProvidedService;
import eu.mdd4soa.smm.statik.RealType;
import eu.mdd4soa.smm.statik.RequiredService;
import eu.mdd4soa.smm.statik.SMMType;
import eu.mdd4soa.smm.statik.Service;
import eu.mdd4soa.smm.statik.StringType;
import eu.mdd4soa.smm.statik.TypedMultiElement;

/**
 * <!-- begin-user-doc --> The <b>Switch</b> for the model's inheritance
 * hierarchy. It supports the call {@link #doSwitch(EObject) doSwitch(object)}
 * to invoke the <code>caseXXX</code> method for each class of the model,
 * starting with the actual class of the object and proceeding up the
 * inheritance hierarchy until a non-null result is returned, which is the
 * result of the switch. <!-- end-user-doc -->
 * 
 * @see eu.mdd4soa.smm.statik.ISMStatikPackage
 * @generated
 */
public class ISMStatikSwitch<T> {
	/**
	 * The cached model package <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected static ISMStatikPackage modelPackage;

	/**
	 * Creates an instance of the switch. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @generated
	 */
	public ISMStatikSwitch() {
		if (modelPackage == null) {
			modelPackage= ISMStatikPackage.eINSTANCE;
		}
	}

	/**
	 * Calls <code>caseXXX</code> for each class of the model until one returns
	 * a non null result; it yields that result. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @return the first non-null result returned by a <code>caseXXX</code>
	 *         call.
	 * @generated
	 */
	public T doSwitch(EObject theEObject) {
		return doSwitch(theEObject.eClass(), theEObject);
	}

	/**
	 * Calls <code>caseXXX</code> for each class of the model until one returns
	 * a non null result; it yields that result. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @return the first non-null result returned by a <code>caseXXX</code>
	 *         call.
	 * @generated
	 */
	protected T doSwitch(EClass theEClass, EObject theEObject) {
		if (theEClass.eContainer() == modelPackage) {
			return doSwitch(theEClass.getClassifierID(), theEObject);
		} else {
			List<EClass> eSuperTypes= theEClass.getESuperTypes();
			return eSuperTypes.isEmpty() ? defaultCase(theEObject) : doSwitch(eSuperTypes.get(0), theEObject);
		}
	}

	/**
	 * Calls <code>caseXXX</code> for each class of the model until one returns
	 * a non null result; it yields that result. <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @return the first non-null result returned by a <code>caseXXX</code>
	 *         call.
	 * @generated
	 */
	protected T doSwitch(int classifierID, EObject theEObject) {
		switch (classifierID) {
			case ISMStatikPackage.SMM_TYPE: {
				SMMType smmType= (SMMType) theEObject;
				T result= caseSMMType(smmType);
				if (result == null)
					result= defaultCase(theEObject);
				return result;
			}
			case ISMStatikPackage.PRIMITIVE_TYPE: {
				PrimitiveType primitiveType= (PrimitiveType) theEObject;
				T result= casePrimitiveType(primitiveType);
				if (result == null)
					result= caseSMMType(primitiveType);
				if (result == null)
					result= defaultCase(theEObject);
				return result;
			}
			case ISMStatikPackage.STRING_TYPE: {
				StringType stringType= (StringType) theEObject;
				T result= caseStringType(stringType);
				if (result == null)
					result= casePrimitiveType(stringType);
				if (result == null)
					result= caseSMMType(stringType);
				if (result == null)
					result= defaultCase(theEObject);
				return result;
			}
			case ISMStatikPackage.BOOLEAN_TYPE: {
				BooleanType booleanType= (BooleanType) theEObject;
				T result= caseBooleanType(booleanType);
				if (result == null)
					result= casePrimitiveType(booleanType);
				if (result == null)
					result= caseSMMType(booleanType);
				if (result == null)
					result= defaultCase(theEObject);
				return result;
			}
			case ISMStatikPackage.INTEGER_TYPE: {
				IntegerType integerType= (IntegerType) theEObject;
				T result= caseIntegerType(integerType);
				if (result == null)
					result= casePrimitiveType(integerType);
				if (result == null)
					result= caseSMMType(integerType);
				if (result == null)
					result= defaultCase(theEObject);
				return result;
			}
			case ISMStatikPackage.REAL_TYPE: {
				RealType realType= (RealType) theEObject;
				T result= caseRealType(realType);
				if (result == null)
					result= casePrimitiveType(realType);
				if (result == null)
					result= caseSMMType(realType);
				if (result == null)
					result= defaultCase(theEObject);
				return result;
			}
			case ISMStatikPackage.DATE_TYPE: {
				DateType dateType= (DateType) theEObject;
				T result= caseDateType(dateType);
				if (result == null)
					result= casePrimitiveType(dateType);
				if (result == null)
					result= caseSMMType(dateType);
				if (result == null)
					result= defaultCase(theEObject);
				return result;
			}
			case ISMStatikPackage.MESSAGE_TYPE: {
				MessageType messageType= (MessageType) theEObject;
				T result= caseMessageType(messageType);
				if (result == null)
					result= caseSMMType(messageType);
				if (result == null)
					result= defaultCase(theEObject);
				return result;
			}
			case ISMStatikPackage.MESSAGE_PROPERTY: {
				MessageProperty messageProperty= (MessageProperty) theEObject;
				T result= caseMessageProperty(messageProperty);
				if (result == null)
					result= caseTypedMultiElement(messageProperty);
				if (result == null)
					result= defaultCase(theEObject);
				return result;
			}
			case ISMStatikPackage.NULL_TYPE: {
				NullType nullType= (NullType) theEObject;
				T result= caseNullType(nullType);
				if (result == null)
					result= caseSMMType(nullType);
				if (result == null)
					result= defaultCase(theEObject);
				return result;
			}
			case ISMStatikPackage.SERVICE: {
				Service service= (Service) theEObject;
				T result= caseService(service);
				if (result == null)
					result= defaultCase(theEObject);
				return result;
			}
			case ISMStatikPackage.INTERFACE_OPERATION: {
				InterfaceOperation interfaceOperation= (InterfaceOperation) theEObject;
				T result= caseInterfaceOperation(interfaceOperation);
				if (result == null)
					result= defaultCase(theEObject);
				return result;
			}
			case ISMStatikPackage.INTERFACE_TYPE: {
				InterfaceType interfaceType= (InterfaceType) theEObject;
				T result= caseInterfaceType(interfaceType);
				if (result == null)
					result= caseSMMType(interfaceType);
				if (result == null)
					result= defaultCase(theEObject);
				return result;
			}
			case ISMStatikPackage.PROVIDED_SERVICE: {
				ProvidedService providedService= (ProvidedService) theEObject;
				T result= caseProvidedService(providedService);
				if (result == null)
					result= caseService(providedService);
				if (result == null)
					result= defaultCase(theEObject);
				return result;
			}
			case ISMStatikPackage.REQUIRED_SERVICE: {
				RequiredService requiredService= (RequiredService) theEObject;
				T result= caseRequiredService(requiredService);
				if (result == null)
					result= caseService(requiredService);
				if (result == null)
					result= defaultCase(theEObject);
				return result;
			}
			case ISMStatikPackage.INTERFACE_PARAMETER: {
				InterfaceParameter interfaceParameter= (InterfaceParameter) theEObject;
				T result= caseInterfaceParameter(interfaceParameter);
				if (result == null)
					result= caseTypedMultiElement(interfaceParameter);
				if (result == null)
					result= defaultCase(theEObject);
				return result;
			}
			case ISMStatikPackage.IN_PARAMETER: {
				InParameter inParameter= (InParameter) theEObject;
				T result= caseInParameter(inParameter);
				if (result == null)
					result= caseInterfaceParameter(inParameter);
				if (result == null)
					result= caseTypedMultiElement(inParameter);
				if (result == null)
					result= defaultCase(theEObject);
				return result;
			}
			case ISMStatikPackage.OUT_PARAMETER: {
				OutParameter outParameter= (OutParameter) theEObject;
				T result= caseOutParameter(outParameter);
				if (result == null)
					result= caseInterfaceParameter(outParameter);
				if (result == null)
					result= caseTypedMultiElement(outParameter);
				if (result == null)
					result= defaultCase(theEObject);
				return result;
			}
			case ISMStatikPackage.PARTICIPANT: {
				Participant participant= (Participant) theEObject;
				T result= caseParticipant(participant);
				if (result == null)
					result= defaultCase(theEObject);
				return result;
			}
			case ISMStatikPackage.EXCEPTION_TYPE: {
				ExceptionType exceptionType= (ExceptionType) theEObject;
				T result= caseExceptionType(exceptionType);
				if (result == null)
					result= caseSMMType(exceptionType);
				if (result == null)
					result= defaultCase(theEObject);
				return result;
			}
			case ISMStatikPackage.TYPED_MULTI_ELEMENT: {
				TypedMultiElement typedMultiElement= (TypedMultiElement) theEObject;
				T result= caseTypedMultiElement(typedMultiElement);
				if (result == null)
					result= defaultCase(theEObject);
				return result;
			}
			default:
				return defaultCase(theEObject);
		}
	}

	/**
	 * Returns the result of interpreting the object as an instance of '
	 * <em>SMM Type</em>'. <!-- begin-user-doc --> This implementation returns
	 * null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * 
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '
	 *         <em>SMM Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseSMMType(SMMType object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '
	 * <em>Primitive Type</em>'. <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * 
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '
	 *         <em>Primitive Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T casePrimitiveType(PrimitiveType object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '
	 * <em>String Type</em>'. <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * 
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '
	 *         <em>String Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseStringType(StringType object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '
	 * <em>Boolean Type</em>'. <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * 
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '
	 *         <em>Boolean Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseBooleanType(BooleanType object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '
	 * <em>Integer Type</em>'. <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * 
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '
	 *         <em>Integer Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIntegerType(IntegerType object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '
	 * <em>Real Type</em>'. <!-- begin-user-doc --> This implementation returns
	 * null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * 
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '
	 *         <em>Real Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseRealType(RealType object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '
	 * <em>Date Type</em>'. <!-- begin-user-doc --> This implementation returns
	 * null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * 
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '
	 *         <em>Date Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseDateType(DateType object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '
	 * <em>Message Type</em>'. <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * 
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '
	 *         <em>Message Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseMessageType(MessageType object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '
	 * <em>Message Property</em>'. <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * 
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '
	 *         <em>Message Property</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseMessageProperty(MessageProperty object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '
	 * <em>Null Type</em>'. <!-- begin-user-doc --> This implementation returns
	 * null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * 
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '
	 *         <em>Null Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseNullType(NullType object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '
	 * <em>Service</em>'. <!-- begin-user-doc --> This implementation returns
	 * null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * 
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '
	 *         <em>Service</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseService(Service object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '
	 * <em>Interface Operation</em>'. <!-- begin-user-doc --> This
	 * implementation returns null; returning a non-null result will terminate
	 * the switch. <!-- end-user-doc -->
	 * 
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '
	 *         <em>Interface Operation</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseInterfaceOperation(InterfaceOperation object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '
	 * <em>Interface Type</em>'. <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * 
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '
	 *         <em>Interface Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseInterfaceType(InterfaceType object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '
	 * <em>Provided Service</em>'. <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * 
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '
	 *         <em>Provided Service</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseProvidedService(ProvidedService object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '
	 * <em>Required Service</em>'. <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * 
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '
	 *         <em>Required Service</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseRequiredService(RequiredService object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '
	 * <em>Interface Parameter</em>'. <!-- begin-user-doc --> This
	 * implementation returns null; returning a non-null result will terminate
	 * the switch. <!-- end-user-doc -->
	 * 
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '
	 *         <em>Interface Parameter</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseInterfaceParameter(InterfaceParameter object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '
	 * <em>In Parameter</em>'. <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * 
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '
	 *         <em>In Parameter</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseInParameter(InParameter object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '
	 * <em>Out Parameter</em>'. <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * 
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '
	 *         <em>Out Parameter</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseOutParameter(OutParameter object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '
	 * <em>Participant</em>'. <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * 
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '
	 *         <em>Participant</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseParticipant(Participant object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '
	 * <em>Exception Type</em>'. <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * 
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '
	 *         <em>Exception Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseExceptionType(ExceptionType object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '
	 * <em>Typed Multi Element</em>'. <!-- begin-user-doc --> This
	 * implementation returns null; returning a non-null result will terminate
	 * the switch. <!-- end-user-doc -->
	 * 
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '
	 *         <em>Typed Multi Element</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseTypedMultiElement(TypedMultiElement object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '
	 * <em>EObject</em>'. <!-- begin-user-doc --> This implementation returns
	 * null; returning a non-null result will terminate the switch, but this is
	 * the last case anyway. <!-- end-user-doc -->
	 * 
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '
	 *         <em>EObject</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject)
	 * @generated
	 */
	public T defaultCase(EObject object) {
		return null;
	}

} // ISMStatikSwitch
