/*
 * This file has been developed at the University of Munich, Chair for Programming & Software Engineering.
 * 
 * This file is licensed under the Eclipse Public License (EPL) 1.0
 * 
 */
package eu.mdd4soa.trans.smm2bpel;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.bpel.apache.ode.deploy.model.dd.TDeployment;
import org.eclipse.bpel.model.Process;
import org.eclipse.wst.wsdl.Definition;
import org.eclipse.xsd.XSDSchema;

public class BPELImplementationPackage {

	private List<Process> fBPELProcesses;

	private List<Definition> fWSDLDefinitions;

	private List<TDeployment> fDeploymentDescriptors;

	private XSDSchema fXSDSchema;

	public BPELImplementationPackage() {
		fBPELProcesses= new ArrayList<Process>();
		fWSDLDefinitions= new ArrayList<Definition>();
		fDeploymentDescriptors= new ArrayList<TDeployment>();
	}

	public List<Process> getBPELProcesses() {
		return fBPELProcesses;
	}

	public List<Definition> getWSDLDefinitions() {
		return fWSDLDefinitions;
	}

	public XSDSchema getXSDSchema() {
		return fXSDSchema;
	}

	public void setXSDSchema(XSDSchema xSDSchema) {
		fXSDSchema= xSDSchema;
	}

	public List<TDeployment> getDeploymentDescriptors() {
		return fDeploymentDescriptors;
	}

}
