/*
 * This file has been developed at the University of Munich, Chair for Programming & Software Engineering.
 * 
 * This file is licensed under the Eclipse Public License (EPL) 1.0
 * 
 */
package eu.mdd4soa.trans.smm2bpel.impl;

import org.eclipse.emf.common.util.EList;

import eu.mdd4soa.smm.behaviour.ServiceActivity;
import eu.mdd4soa.smm.exception.TransformationException;
import eu.mdd4soa.smm.statik.Participant;
import eu.mdd4soa.smm.statik.Service;
import eu.mdd4soa.trans.smm2bpel.BPELImplementationPackage;
import eu.mdd4soa.trans.smm2bpel.impl.util.GPTracker;

public class SMM2BpelTransformer {

	public static BPELImplementationPackage execute(Participant participant) throws TransformationException {
		SMM2BpelTransformer transformer= new SMM2BpelTransformer(participant);
		transformer.run();
		return transformer.getResult();
	}

	private BPELImplementationPackage fImplPackage;

	private Participant fParticipant;

	public SMM2BpelTransformer(Participant participant) {
		fParticipant= participant;
		fImplPackage= new BPELImplementationPackage();
	}

	private BPELImplementationPackage getResult() {
		return fImplPackage;
	}

	private void run() throws TransformationException {

		GPTracker tracker= new GPTracker(fParticipant.getName());

		// Static part: Data (XSD)
		fImplPackage.setXSDSchema(StaticDataConverter.convert(tracker, fParticipant));

		// WSDL for correlation
		fImplPackage.getWSDLDefinitions().add(StaticCorrelationConverter.convert(tracker, fParticipant));

		// Static part: Interfaces (WSDL)
		EList<Service> partners= fParticipant.getPartners();
		for (Service partnerPoint : partners) {
			fImplPackage.getWSDLDefinitions().add(StaticPartnerConverter.convert(tracker, fParticipant, partnerPoint));
		}

		// Behavioural part: BPEL + Deployment
		EList<ServiceActivity> behaviours= fParticipant.getBehaviours();
		for (ServiceActivity serviceActivity : behaviours) {
			fImplPackage.getBPELProcesses().add(BehaviourConverter.convert(tracker, fParticipant, serviceActivity));
			fImplPackage.getDeploymentDescriptors().add(DeploymentCreator.create(tracker, fParticipant, serviceActivity));
		}

	}

}
