/*
 * This file has been developed at the University of Munich, Chair for Programming & Software Engineering.
 * 
 * This file is licensed under the Eclipse Public License (EPL) 1.0
 * 
 */
package eu.mdd4soa.trans.ism2java.test;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;

import org.eclipse.acceleo.model.mtl.MtlPackage;
import org.eclipse.emf.common.util.BasicMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.Resource.Factory.Registry;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.XMIResource;
import org.eclipse.emf.ecore.xmi.impl.EcoreResourceFactoryImpl;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.eclipse.emf.ecore.xmi.impl.XMLContentHandlerImpl;
import org.eclipse.emf.ecore.xmi.impl.XMLResourceFactoryImpl;
import org.eclipse.gmt.modisco.java.Model;
import org.eclipse.gmt.modisco.java.emf.JavaPackage;
import org.eclipse.gmt.modisco.java.generation.files.Generate_JavaStructures;
import org.junit.Test;

import eu.mdd4soa.smm.exception.InvalidSetupException;
import eu.mdd4soa.smm.exception.TransformationException;
import eu.mdd4soa.smm.statik.ISMStatikFactory;
import eu.mdd4soa.smm.statik.Participant;
import eu.mdd4soa.trans.smm2java.SMM2JavaPlugin;
import eu.mdd4soa.trans.smm2java.impl.SMM2JavaTransformer;

public class SimpleTests {

	@Test
	public void testOne() throws IOException, InvalidSetupException, TransformationException {

		Participant p1= ISMStatikFactory.eINSTANCE.createParticipant();
		p1.setName("ThesisManager");

		Model model= SMM2JavaTransformer.execute(p1);

		ResourceSet resourceSet= new ResourceSetImpl();
		addHeadlessInformation(resourceSet);

		URI fileURI= URI.createFileURI("x.javaxmi");

		XMIResource xmlResource= (XMIResource) resourceSet.createResource(fileURI);
		xmlResource.getContents().add(model);
		try {
			xmlResource.save(null);
		} catch (IOException e) {
			throw new InvalidSetupException("Unable to write XMI file: " + e.getMessage());
		}

		Generate_JavaStructures s= new Generate_JavaStructures(model, new File("."), new ArrayList<Object>());
		s.doGenerate(new BasicMonitor());

	}

	private static void addHeadlessInformation(ResourceSet resourceSet) {

		// Headless?
		if (SMM2JavaPlugin.getDefault() == null || SMM2JavaPlugin.getDefault().getBundle() == null) {

			resourceSet.getPackageRegistry().put(JavaPackage.eNS_URI, JavaPackage.eINSTANCE);

			resourceSet.getPackageRegistry().put(EcorePackage.eNS_URI, EcorePackage.eINSTANCE);

			// TODO for some reason, 0.8.0 is expected which seems to be an
			// older version...
			resourceSet.getPackageRegistry().put(MtlPackage.eNS_URI, MtlPackage.eINSTANCE);
			// esourceSet.getPackageRegistry().put("http://www.eclipse.org/acceleo/mtl/0.8.0",
			// MtlPackage.eINSTANCE);

			resourceSet.getResourceFactoryRegistry().getContentTypeToFactoryMap()
					.put("org.eclipse.emf.ecore:contentType", new XMLContentHandlerImpl());

			Registry registry= resourceSet.getResourceFactoryRegistry();

			registry.getExtensionToFactoryMap().put("ecore", new EcoreResourceFactoryImpl());
			registry.getExtensionToFactoryMap().put("xml", new XMLResourceFactoryImpl());
			registry.getExtensionToFactoryMap().put("xmi", new XMIResourceFactoryImpl());
			registry.getExtensionToFactoryMap().put("javaxmi", new XMIResourceFactoryImpl());
		}
	}

}
