/*
 * This file has been developed at the University of Munich, Chair for Programming & Software Engineering.
 * 
 * This file is licensed under the Eclipse Public License (EPL) 1.0
 * 
 */
package eu.mdd4soa.trans.smm2java.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.eclipse.gmt.modisco.java.FieldDeclaration;
import org.eclipse.gmt.modisco.java.InterfaceDeclaration;
import org.eclipse.gmt.modisco.java.MethodDeclaration;

import eu.mdd4soa.smm.statik.InterfaceOperation;
import eu.mdd4soa.smm.statik.Service;

public class PartnerTracker {

	public static enum Type {
		PROVIDED, REQUIRED
	}

	public static class Partner {

		private List<InterfaceOperation> fOperations;

		private InterfaceDeclaration fInterface;

		private Service fPartner;

		private Map<InterfaceOperation, MethodDeclaration> fOperationToMethod;

		private FieldDeclaration fPartnerField;

		public Partner(Service partner, InterfaceDeclaration declaration, List<InterfaceOperation> operations) {
			fPartner= partner;
			fInterface= declaration;
			fOperations= operations;
			fOperationToMethod= new HashMap<InterfaceOperation, MethodDeclaration>();
		}

		public InterfaceDeclaration getInterface() {
			return fInterface;
		}

		public List<InterfaceOperation> getOperations() {
			return fOperations;
		}

		public String getPartnerName() {
			return fPartner.getName();
		}

		public Service getPartner() {
			return fPartner;
		}

		public void setPartnerField(FieldDeclaration partnerField) {
			fPartnerField= partnerField;
		}

		public FieldDeclaration getPartnerField() {
			return fPartnerField;
		}

		public MethodDeclaration getMethodDeclaration(InterfaceOperation someOp) {
			return fOperationToMethod.get(someOp);
		}

		public void setOperation(InterfaceOperation interfaceOperation, MethodDeclaration declaration) {
			fOperationToMethod.put(interfaceOperation, declaration);
		}

	}

	private List<Partner> fRequiredPoints;

	private List<Partner> fProvidedPoints;

	public PartnerTracker() {
		fRequiredPoints= new ArrayList<Partner>();
		fProvidedPoints= new ArrayList<Partner>();
	}

	public Partner getPartner(eu.mdd4soa.trans.smm2java.impl.PartnerTracker.Type type, Service partner) {

		List<Partner> partners= getPartners(type);
		for (Partner partner2 : partners) {
			if (partner2.getPartner().equals(partner))
				return partner2;
		}

		return null;
	}

	public List<Partner> getPartners(eu.mdd4soa.trans.smm2java.impl.PartnerTracker.Type type) {
		switch (type) {
			case PROVIDED:
				return fProvidedPoints;
			case REQUIRED:
				return fRequiredPoints;
		}
		return null;
	}

	public void addPartner(eu.mdd4soa.trans.smm2java.impl.PartnerTracker.Type provided, Partner partner) {
		switch (provided) {
			case PROVIDED:
				fProvidedPoints.add(partner);
				break;
			case REQUIRED:
				fRequiredPoints.add(partner);
				break;
		}

	}



}
