/*
 * This file has been developed at the University of Munich, Chair for Programming & Software Engineering.
 * 
 * This file is licensed under the Eclipse Public License (EPL) 1.0
 * 
 */
package eu.mdd4soa.trans.smm2java.impl;

import org.eclipse.emf.common.util.EList;
import org.eclipse.gmt.modisco.java.Model;
import org.eclipse.gmt.modisco.java.Package;
import org.eclipse.gmt.modisco.java.emf.JavaFactory;

import eu.mdd4soa.smm.behaviour.ServiceActivity;
import eu.mdd4soa.smm.exception.TransformationException;
import eu.mdd4soa.smm.statik.Participant;
import eu.mdd4soa.trans.smm2java.JMHelper;

/**
 * 
 * This class converts from SMM models to Java models.
 * 
 * @author Philip Mayer
 * 
 */
public class SMM2JavaTransformer {

	public static Model execute(Participant part) throws TransformationException {
		SMM2JavaTransformer ism2JavaTransformer= new SMM2JavaTransformer(part);
		ism2JavaTransformer.execute();
		return ism2JavaTransformer.getResult();
	}

	private Participant fParticipant;

	private Model fModel;

	private TypeTracker fTypeTracker;

	private Package fRootPackage;

	private PartnerTracker fPartners;

	public SMM2JavaTransformer(Participant part) {
		fParticipant= part;

		fModel= JavaFactory.eINSTANCE.createModel();
		fModel.setName(JMHelper.toLowerCase(fParticipant.getName()));

		fPartners= new PartnerTracker();
	}

	private Model getResult() {
		return fModel;
	}

	private void execute() throws TransformationException {

		fRootPackage= JavaFactory.eINSTANCE.createPackage();
		fRootPackage.setName(JMHelper.toLowerCase(fParticipant.getName()));
		fModel.getOwnedElements().add(fRootPackage);

		fTypeTracker= new TypeTracker(fModel, fRootPackage);

		StaticConverter.convert(fModel, fParticipant, fRootPackage, fTypeTracker, fPartners);

		EList<ServiceActivity> behaviours= fParticipant.getBehaviours();
		for (ServiceActivity serviceActivity : behaviours) {
			BehaviourConverter.convert(serviceActivity, fRootPackage, fTypeTracker, fPartners);
			SimulationCreator.createSimulation(fModel, fParticipant, serviceActivity, fRootPackage, fTypeTracker, fPartners);
		}


	}

}
