/*
 * This file has been developed at the University of Munich, Chair for Programming & Software Engineering.
 * 
 * This file is licensed under the Eclipse Public License (EPL) 1.0
 * 
 */
package eu.mdd4soa.trans.uml2ism.test;

import static org.junit.Assert.assertFalse;

import org.junit.BeforeClass;
import org.junit.Test;

import eu.mdd4soa.smm.exception.InvalidSetupException;

public class ActionTests extends AbstractUML2SMMTest {

	@BeforeClass
	public static void setUp() throws InvalidSetupException {
		AbstractUML2SMMTest.setUp("resources/xmi/TestCases.uml");
	}

	@Test
	public void testEmptyParticipant() throws Exception {
		checkOrch("ActionParticipant", "a01_EmptyParticipant");
	}

	@Test
	public void testParticipantWithOneAction() throws Exception {
		checkOrch("ActionParticipant", "a02_ParticipantWithOneAction");
	}

	@Test
	public void testParticipantWithSeveralActions() throws Exception {
		checkOrch("ActionParticipant", "a03_ParticipantWithSeveralActions");
	}

	@Test
	public void testParticipantWithTwoStartActions() throws Exception {
		try {
			checkOrch("ActionParticipant", "a04_TwoStartActions");
			assertFalse("Must throw an exception!", true);
		} catch (Exception e) {
			// expected.
		}
	}

	@Test
	public void testParticipantWithStartAndEndSpecialNodes() throws Exception {
		checkOrch("ActionParticipant", "a05_StartAndEndSpecialNodes");
	}

}
