/*
 * This file has been developed at the University of Munich, Chair for Programming & Software Engineering.
 * 
 * This file is licensed under the Eclipse Public License (EPL) 1.0
 * 
 */
package eu.mdd4soa.trans.uml2ism.test;

import org.junit.BeforeClass;
import org.junit.Test;

import eu.mdd4soa.smm.exception.InvalidSetupException;

public class DataTests extends AbstractUML2SMMTest {

	@BeforeClass
	public static void setUp() throws InvalidSetupException {
		AbstractUML2SMMTest.setUp("resources/xmi/TestCases.uml");
	}

	@Test
	public void testDataHandlingWithPrimitiveTypes() throws Exception {
		checkOrch("DataParticipant", "01_PrimitiveDataHandling");
	}

	@Test
	public void testDataHandlingWithMessageTypes() throws Exception {
		checkOrch("DataParticipant", "02_MessageTypeDataHandling");
	}

	@Test
	public void testOperation() throws Exception {
		checkOrch("DataParticipant", "03_Operation");
	}

	@Test
	public void testRcvPin() throws Exception {
		checkOrch("DataParticipant", "04_ReceivePin");
	}

	@Test
	public void testSndPin() throws Exception {
		checkOrch("DataParticipant", "05_SendPin");
	}

	@Test
	public void testDecisionCondition() throws Exception {
		checkOrch("DataParticipant", "06_DecisionCondition");
	}

	@Test
	public void testLoopCondition() throws Exception {
		checkOrch("DataParticipant", "07_LoopCondition");
	}


}
