/*
 * This file has been developed at the University of Munich, Chair for Programming & Software Engineering.
 * 
 * This file is licensed under the Eclipse Public License (EPL) 1.0
 * 
 */
package eu.mdd4soa.trans.uml2ism.test;

import org.junit.BeforeClass;
import org.junit.Test;

import eu.mdd4soa.smm.exception.InvalidSetupException;

public class HandlerTests extends AbstractUML2SMMTest {

	@BeforeClass
	public static void setUp() throws InvalidSetupException {
		AbstractUML2SMMTest.setUp("resources/xmi/TestCases.uml");
	}

	@Test
	public void testEventHandler() throws Exception {
		checkOrch("HandlerParticipant", "01_EventHandler");
	}

	@Test
	public void testCompensationHandler() throws Exception {
		checkOrch("HandlerParticipant", "02_CompensationHandler");
	}

	@Test
	public void testExceptionHandler() throws Exception {
		checkOrch("HandlerParticipant", "03_ExceptionHandler");
	}

	@Test
	public void testCompensateCalls() throws Exception {
		checkOrch("HandlerParticipant", "04_CompensateCalls");
	}

}
