/*
 * This file has been developed at the University of Munich, Chair for Programming & Software Engineering.
 * 
 * This file is licensed under the Eclipse Public License (EPL) 1.0
 * 
 */
package eu.mdd4soa.trans.uml2ism.test;

import org.junit.BeforeClass;
import org.junit.Test;

import eu.mdd4soa.smm.exception.InvalidSetupException;

public class StaticTests extends AbstractUML2SMMTest {

	@BeforeClass
	public static void setUp() throws InvalidSetupException {
		AbstractUML2SMMTest.setUp("resources/xmi/TestCases.uml");
	}

	@Test
	public void testParticipantWithoutPorts() throws Exception {
		checkStatic("01_NoPortParticipant");
	}

	@Test
	public void testParticipantWithOnePort() throws Exception {
		checkStatic("02_PartWithPort");
	}

	@Test
	public void testParticipantWithOperations() throws Exception {
		checkStatic("03_PartWithOperations");
	}

	@Test
	public void testParticipantWithInheritedOperations() throws Exception {
		checkStatic("04_PartWithInheritedOperations");
	}

	@Test
	public void testParticipantWithServiceAndRequestPoint() throws Exception {
		checkStatic("05_PartWithServiceAndRequestPoint");
	}

	@Test
	public void testParticipantWithMessageTypes() throws Exception {
		checkStatic("06_PartWithMessageType");
	}
}
