/*
 * This file has been developed at the University of Munich, Chair for Programming & Software Engineering.
 * 
 * This file is licensed under the Eclipse Public License (EPL) 1.0
 * 
 */
package eu.mdd4soa.trans.uml2ism.test;

import org.junit.BeforeClass;
import org.junit.Test;

import eu.mdd4soa.smm.exception.InvalidSetupException;

public class StructuredTests extends AbstractUML2SMMTest {

	@BeforeClass
	public static void setUp() throws InvalidSetupException {
		AbstractUML2SMMTest.setUp("resources/xmi/TestCases.uml");
	}

	@Test
	public void testSimpleLoop() throws Exception {
		checkOrch("StructuredParticipant", "s01_Loop");
	}

	@Test
	public void testSimpleDecision() throws Exception {
		checkOrch("StructuredParticipant", "s02_Decision");
	}

	@Test
	public void testSimpleDecisionNoEnd() throws Exception {
		checkOrch("StructuredParticipant", "s03_Decision_NoEnd");
	}

	@Test
	public void testSimpleParallel() throws Exception {
		checkOrch("StructuredParticipant", "s04_Parallel");
	}

	@Test
	public void testSimpleInnerServiceActivity() throws Exception {
		checkOrch("StructuredParticipant", "s05_ServiceActivity");
	}

	@Test
	public void testDecisionInDecision() throws Exception {
		checkOrch("StructuredParticipant", "s06_DecisionInDecision");
	}

	@Test
	public void testLoopInLoop() throws Exception {
		checkOrch("StructuredParticipant", "s07_LoopInLoop");
	}

	@Test
	public void testDecisionInLoop() throws Exception {
		checkOrch("StructuredParticipant", "s08_DecisionInLoop");
	}

	@Test
	public void testLoopInDecision() throws Exception {
		checkOrch("StructuredParticipant", "s09_LoopInDecision");
	}

	@Test
	public void testInterruptingReceive() throws Exception {
		checkOrch("StructuredParticipant", "s10_Interrupt");
	}
}
