/*
 * This file has been developed at the University of Munich, Chair for Programming & Software Engineering.
 * 
 * This file is licensed under the Eclipse Public License (EPL) 1.0
 * 
 */
package eu.mdd4soa.trans.uml2smm;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Stereotype;

/**
 * 
 * Stereotyping information of the UML4SOA profile.
 * 
 * @author Philip Mayer
 * 
 */
public class StereotypeUtil {

	/**
	 * 
	 * Enumeration of stereotypes for easy checks from the Java code
	 * 
	 * @author Philip Mayer
	 * 
	 */
	public static enum StereoType {
		// UML4SOA;
		SERVICEACTIVITY, SEND, RECEIVE, REPLY, SENDANDRECEIVE, COMPENSATE, COMPENSATEALL, COMPENSATIONFLOW, LNKPIN, SNDPIN, RCVPIN, EVENTFLOW, MESSAGETYPE, DATA,
		// soaML:
		PARTICIPANT, SERVICEPOINT, REQUESTPOINT, SERVICEINTERFACE
	}

	/**
	 * Checks, if a list of stereotypes contains the one specified as second
	 * parameter
	 * 
	 * @param stereotypes
	 * @param which
	 * @return
	 */
	public static boolean hasStereotype(List<Stereotype> stereotypes, StereoType... which) {
		for (Stereotype stereotype : stereotypes) {
			for (StereoType stereoType : which) {
				if (stereoType.equals(fStereotypeMap.get(stereotype.getName().toLowerCase())))
					return true;
			}
		}
		return false;
	}

	/**
	 * Wrapper for convenience.
	 * 
	 * @param e {@link Element} which stereotypes will be checked against the
	 *        parameter which
	 * @param which {@link StereoType}
	 * @param compensateall
	 * @param compensate
	 * @return
	 */
	public static boolean hasStereotype(Element e, StereoType... which) {
		return hasStereotype(e.getAppliedStereotypes(), which);
	}

	public static StereoType getFirstStereotype(List<Stereotype> stereotypes) {
		for (Stereotype stereotype : stereotypes) {
			StereoType sType= fStereotypeMap.get(stereotype.getName().toLowerCase());
			if (sType != null)
				return sType;
		}
		return null;
	}

	public static void addStereotype(Element e, StereoType type) {
		for (Stereotype applicableType : e.getApplicableStereotypes()) {
			if (type.equals(fStereotypeMap.get(applicableType.getName().toLowerCase()))) {
				e.applyStereotype(applicableType);
			}
		}
	}

	public static Map<String, StereoType> fStereotypeMap= new HashMap<String, StereoType>();
	static {
		fStereotypeMap.put("serviceactivity", StereoType.SERVICEACTIVITY);

		fStereotypeMap.put("send", StereoType.SEND);
		fStereotypeMap.put("receive", StereoType.RECEIVE);
		fStereotypeMap.put("reply", StereoType.REPLY);
		fStereotypeMap.put("send&receive", StereoType.SENDANDRECEIVE);

		fStereotypeMap.put("compensate", StereoType.COMPENSATE);
		fStereotypeMap.put("compensateall", StereoType.COMPENSATEALL);

		fStereotypeMap.put("compensation", StereoType.COMPENSATIONFLOW);
		fStereotypeMap.put("event", StereoType.EVENTFLOW);

		fStereotypeMap.put("lnk", StereoType.LNKPIN);
		fStereotypeMap.put("snd", StereoType.SNDPIN);
		fStereotypeMap.put("rcv", StereoType.RCVPIN);

		// structure type
		fStereotypeMap.put("messagetype", StereoType.MESSAGETYPE);

		// data handling
		fStereotypeMap.put("data", StereoType.DATA);

		// soaML
		fStereotypeMap.put("participant", StereoType.PARTICIPANT);
		fStereotypeMap.put("servicepoint", StereoType.SERVICEPOINT);
		fStereotypeMap.put("service", StereoType.SERVICEPOINT);
		fStereotypeMap.put("requestpoint", StereoType.REQUESTPOINT);
		fStereotypeMap.put("request", StereoType.REQUESTPOINT);
		fStereotypeMap.put("serviceinterface", StereoType.SERVICEINTERFACE);

	}


}
