/*
 * This file has been developed at the University of Munich, Chair for Programming & Software Engineering.
 * 
 * This file is licensed under the Eclipse Public License (EPL) 1.0
 * 
 */
package eu.mdd4soa.trans.uml2smm;

import org.eclipse.core.runtime.Status;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

/**
 * The activator class controls the plug-in life cycle
 */
public class UML2SMM2Plugin extends AbstractUIPlugin {

	// The plug-in ID
	public static final String PLUGIN_ID= "eu.mdd4soa.trans.uml2smm";

	// The shared instance
	private static UML2SMM2Plugin plugin;

	/**
	 * The constructor
	 */
	public UML2SMM2Plugin() {
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * org.eclipse.ui.plugin.AbstractUIPlugin#start(org.osgi.framework.BundleContext
	 * )
	 */
	public void start(BundleContext context) throws Exception {
		super.start(context);
		plugin= this;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * org.eclipse.ui.plugin.AbstractUIPlugin#stop(org.osgi.framework.BundleContext
	 * )
	 */
	public void stop(BundleContext context) throws Exception {
		plugin= null;
		super.stop(context);
	}

	/**
	 * Returns the shared instance
	 * 
	 * @return the shared instance
	 */
	public static UML2SMM2Plugin getDefault() {
		return plugin;
	}

	public static void logError(Throwable e) {
		Status status= new Status(Status.ERROR, PLUGIN_ID, e.getMessage(), e);
		getDefault().getLog().log(status);
	}

	public static void logError(String message, Throwable e) {
		Status status= new Status(Status.ERROR, PLUGIN_ID, message, e);
		getDefault().getLog().log(status);
	}

}
