/*
 * This file has been developed at the University of Munich, Chair for Programming & Software Engineering.
 * 
 * This file is licensed under the Eclipse Public License (EPL) 1.0
 * 
 */
package eu.mdd4soa.trans.uml2smm.data;

/**
 * The lexer generated by antlr from the grammar Data.g
 * @author andreas rogge-solti
 */


import org.antlr.runtime.BaseRecognizer;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.CommonToken;
import org.antlr.runtime.DFA;
import org.antlr.runtime.EarlyExitException;
import org.antlr.runtime.IntStream;
import org.antlr.runtime.Lexer;
import org.antlr.runtime.MismatchedSetException;
import org.antlr.runtime.NoViableAltException;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.RecognizerSharedState;
import org.antlr.runtime.Token;

public class DataLexer extends Lexer {
	public static final int SIGN= 36;

	public static final int MOD= 23;

	public static final int ESC= 29;

	public static final int EQUALS= 13;

	public static final int NOT= 24;

	public static final int ID= 31;

	public static final int AND= 10;

	public static final int EOF= -1;

	public static final int UMLAUTS= 38;

	public static final int NOT_EQUALS= 14;

	public static final int SINGLE_QUOTE= 37;

	public static final int SCOPE_REF= 6;

	public static final int GREATER= 17;

	public static final int ZERO_TO_NINE= 34;

	public static final int LESS= 15;

	public static final int PLUS= 19;

	public static final int DOT= 7;

	public static final int COMMENT= 40;

	public static final int ARRAY= 32;

	public static final int T__42= 42;

	public static final int T__43= 43;

	public static final int T__41= 41;

	public static final int EQUALS2= 12;

	public static final int AND2= 11;

	public static final int NULL= 26;

	public static final int HEX_DIGIT= 30;

	public static final int SET= 33;

	public static final int SEMICOLON= 5;

	public static final int MINUS= 20;

	public static final int MULT= 21;

	public static final int TRUE= 27;

	public static final int COLON= 35;

	public static final int WS= 39;

	public static final int OR= 8;

	public static final int ASSIGN= 4;

	public static final int OR2= 9;

	public static final int LESS_EQUAL= 16;

	public static final int DIV= 22;

	public static final int FALSE= 28;

	public static final int GREATER_EQUAL= 18;

	public static final int STRING= 25;

	// delegates
	// delegators

	public DataLexer() {
		;
	}

	public DataLexer(CharStream input) {
		this(input, new RecognizerSharedState());
	}

	public DataLexer(CharStream input, RecognizerSharedState state) {
		super(input, state);

	}

	public String getGrammarFileName() {
		return "/home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g";
	}

	// $ANTLR start "T__41"
	public final void mT__41() throws RecognitionException {
		try {
			int _type= T__41;
			int _channel= DEFAULT_TOKEN_CHANNEL;
			// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:10:7:
			// ( '(' )
			// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:10:9:
			// '('
			{
				match('(');

			}

			state.type= _type;
			state.channel= _channel;
		} finally {
		}
	}

	// $ANTLR end "T__41"

	// $ANTLR start "T__42"
	public final void mT__42() throws RecognitionException {
		try {
			int _type= T__42;
			int _channel= DEFAULT_TOKEN_CHANNEL;
			// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:11:7:
			// ( ')' )
			// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:11:9:
			// ')'
			{
				match(')');

			}

			state.type= _type;
			state.channel= _channel;
		} finally {
		}
	}

	// $ANTLR end "T__42"

	// $ANTLR start "T__43"
	public final void mT__43() throws RecognitionException {
		try {
			int _type= T__43;
			int _channel= DEFAULT_TOKEN_CHANNEL;
			// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:12:7:
			// ( '\"' )
			// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:12:9:
			// '\"'
			{
				match('\"');

			}

			state.type= _type;
			state.channel= _channel;
		} finally {
		}
	}

	// $ANTLR end "T__43"

	// $ANTLR start "STRING"
	public final void mSTRING() throws RecognitionException {
		try {
			int _type= STRING;
			int _channel= DEFAULT_TOKEN_CHANNEL;
			Token escaped= null;
			int normal;

			StringBuilder lBuf= new StringBuilder();
			// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:359:5:
			// ( ( '\"' (escaped= ESC | normal=~ ( '\"' | '\\\\' | '\\n' | '\\r'
			// ) )* '\"' | '\\'' (escaped= ESC | normal=~ ( '\\'' | '\\\\' |
			// '\\n' | '\\r' ) )* '\\'' ) )
			// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:360:12:
			// ( '\"' (escaped= ESC | normal=~ ( '\"' | '\\\\' | '\\n' | '\\r' )
			// )* '\"' | '\\'' (escaped= ESC | normal=~ ( '\\'' | '\\\\' | '\\n'
			// | '\\r' ) )* '\\'' )
			{
				// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:360:12:
				// ( '\"' (escaped= ESC | normal=~ ( '\"' | '\\\\' | '\\n' |
				// '\\r' ) )* '\"' | '\\'' (escaped= ESC | normal=~ ( '\\'' |
				// '\\\\' | '\\n' | '\\r' ) )* '\\'' )
				int alt3= 2;
				int LA3_0= input.LA(1);

				if ( (LA3_0 == '\"')) {
					alt3= 1;
				} else if ( (LA3_0 == '\'')) {
					alt3= 2;
				} else {
					NoViableAltException nvae= new NoViableAltException("", 3, 0, input);

					throw nvae;
				}
				switch (alt3) {
					case 1:
						// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:360:13:
						// '\"' (escaped= ESC | normal=~ ( '\"' | '\\\\' | '\\n'
						// | '\\r' ) )* '\"'
					{
						match('\"');
						// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:361:12:
						// (escaped= ESC | normal=~ ( '\"' | '\\\\' | '\\n' |
						// '\\r' ) )*
						loop1: do {
							int alt1= 3;
							int LA1_0= input.LA(1);

							if ( (LA1_0 == '\\')) {
								alt1= 1;
							} else if ( ( (LA1_0 >= '\u0000' && LA1_0 <= '\t') || (LA1_0 >= '\u000B' && LA1_0 <= '\f')
									|| (LA1_0 >= '\u000E' && LA1_0 <= '!') || (LA1_0 >= '#' && LA1_0 <= '[') || (LA1_0 >= ']' && LA1_0 <= '\uFFFF'))) {
								alt1= 2;
							}


							switch (alt1) {
								case 1:
									// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:361:14:
									// escaped= ESC
								{
									int escapedStart95= getCharIndex();
									mESC();
									escaped= new CommonToken(input, Token.INVALID_TOKEN_TYPE, Token.DEFAULT_CHANNEL, escapedStart95,
											getCharIndex() - 1);
									lBuf.append(escaped.getText());

								}
									break;
								case 2:
									// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:362:14:
									// normal=~ ( '\"' | '\\\\' | '\\n' | '\\r'
									// )
								{
									normal= input.LA(1);
									if ( (input.LA(1) >= '\u0000' && input.LA(1) <= '\t') || (input.LA(1) >= '\u000B' && input.LA(1) <= '\f')
											|| (input.LA(1) >= '\u000E' && input.LA(1) <= '!') || (input.LA(1) >= '#' && input.LA(1) <= '[')
											|| (input.LA(1) >= ']' && input.LA(1) <= '\uFFFF')) {
										input.consume();

									} else {
										MismatchedSetException mse= new MismatchedSetException(null, input);
										recover(mse);
										throw mse;
									}

									lBuf.appendCodePoint(normal);

								}
									break;

								default:
									break loop1;
							}
						} while (true);

						match('\"');

					}
						break;
					case 2:
						// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:364:13:
						// '\\'' (escaped= ESC | normal=~ ( '\\'' | '\\\\' |
						// '\\n' | '\\r' ) )* '\\''
					{
						match('\'');
						// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:365:12:
						// (escaped= ESC | normal=~ ( '\\'' | '\\\\' | '\\n' |
						// '\\r' ) )*
						loop2: do {
							int alt2= 3;
							int LA2_0= input.LA(1);

							if ( (LA2_0 == '\\')) {
								alt2= 1;
							} else if ( ( (LA2_0 >= '\u0000' && LA2_0 <= '\t') || (LA2_0 >= '\u000B' && LA2_0 <= '\f')
									|| (LA2_0 >= '\u000E' && LA2_0 <= '&') || (LA2_0 >= '(' && LA2_0 <= '[') || (LA2_0 >= ']' && LA2_0 <= '\uFFFF'))) {
								alt2= 2;
							}


							switch (alt2) {
								case 1:
									// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:365:14:
									// escaped= ESC
								{
									int escapedStart180= getCharIndex();
									mESC();
									escaped= new CommonToken(input, Token.INVALID_TOKEN_TYPE, Token.DEFAULT_CHANNEL, escapedStart180,
											getCharIndex() - 1);
									lBuf.append(escaped.getText());

								}
									break;
								case 2:
									// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:366:14:
									// normal=~ ( '\\'' | '\\\\' | '\\n' | '\\r'
									// )
								{
									normal= input.LA(1);
									if ( (input.LA(1) >= '\u0000' && input.LA(1) <= '\t') || (input.LA(1) >= '\u000B' && input.LA(1) <= '\f')
											|| (input.LA(1) >= '\u000E' && input.LA(1) <= '&') || (input.LA(1) >= '(' && input.LA(1) <= '[')
											|| (input.LA(1) >= ']' && input.LA(1) <= '\uFFFF')) {
										input.consume();

									} else {
										MismatchedSetException mse= new MismatchedSetException(null, input);
										recover(mse);
										throw mse;
									}

									lBuf.appendCodePoint(normal);

								}
									break;

								default:
									break loop2;
							}
						} while (true);

						match('\'');

					}
						break;

				}

				setText(lBuf.toString());

			}

			state.type= _type;
			state.channel= _channel;
		} finally {
		}
	}

	// $ANTLR end "STRING"

	// $ANTLR start "ESC"
	public final void mESC() throws RecognitionException {
		try {
			// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:374:5:
			// ( '\\\\' ( 'n' | 'r' | 't' | 'b' | 'f' | '\"' | '\\'' | '/' |
			// '\\\\' | ( 'u' )+ HEX_DIGIT HEX_DIGIT HEX_DIGIT HEX_DIGIT ) )
			// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:374:9:
			// '\\\\' ( 'n' | 'r' | 't' | 'b' | 'f' | '\"' | '\\'' | '/' |
			// '\\\\' | ( 'u' )+ HEX_DIGIT HEX_DIGIT HEX_DIGIT HEX_DIGIT )
			{
				match('\\');
				// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:375:9:
				// ( 'n' | 'r' | 't' | 'b' | 'f' | '\"' | '\\'' | '/' | '\\\\' |
				// ( 'u' )+ HEX_DIGIT HEX_DIGIT HEX_DIGIT HEX_DIGIT )
				int alt5= 10;
				switch (input.LA(1)) {
					case 'n': {
						alt5= 1;
					}
						break;
					case 'r': {
						alt5= 2;
					}
						break;
					case 't': {
						alt5= 3;
					}
						break;
					case 'b': {
						alt5= 4;
					}
						break;
					case 'f': {
						alt5= 5;
					}
						break;
					case '\"': {
						alt5= 6;
					}
						break;
					case '\'': {
						alt5= 7;
					}
						break;
					case '/': {
						alt5= 8;
					}
						break;
					case '\\': {
						alt5= 9;
					}
						break;
					case 'u': {
						alt5= 10;
					}
						break;
					default:
						NoViableAltException nvae= new NoViableAltException("", 5, 0, input);

						throw nvae;
				}

				switch (alt5) {
					case 1:
						// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:375:17:
						// 'n'
					{
						match('n');
						setText("\n");

					}
						break;
					case 2:
						// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:376:17:
						// 'r'
					{
						match('r');
						setText("\r");

					}
						break;
					case 3:
						// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:377:17:
						// 't'
					{
						match('t');
						setText("\t");

					}
						break;
					case 4:
						// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:378:17:
						// 'b'
					{
						match('b');
						setText("\b");

					}
						break;
					case 5:
						// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:379:17:
						// 'f'
					{
						match('f');
						setText("\f");

					}
						break;
					case 6:
						// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:380:17:
						// '\"'
					{
						match('\"');
						setText("\"");

					}
						break;
					case 7:
						// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:381:17:
						// '\\''
					{
						match('\'');
						setText("\'");

					}
						break;
					case 8:
						// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:382:17:
						// '/'
					{
						match('/');
						setText("/");

					}
						break;
					case 9:
						// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:383:17:
						// '\\\\'
					{
						match('\\');
						setText("\\");

					}
						break;
					case 10:
						// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:384:17:
						// ( 'u' )+ HEX_DIGIT HEX_DIGIT HEX_DIGIT HEX_DIGIT
					{
						// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:384:17:
						// ( 'u' )+
						int cnt4= 0;
						loop4: do {
							int alt4= 2;
							int LA4_0= input.LA(1);

							if ( (LA4_0 == 'u')) {
								alt4= 1;
							}


							switch (alt4) {
								case 1:
									// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:384:18:
									// 'u'
								{
									match('u');

								}
									break;

								default:
									if (cnt4 >= 1)
										break loop4;
									EarlyExitException eee= new EarlyExitException(4, input);
									throw eee;
							}
							cnt4++;
						} while (true);

						mHEX_DIGIT();
						mHEX_DIGIT();
						mHEX_DIGIT();
						mHEX_DIGIT();

					}
						break;

				}


			}

		} finally {
		}
	}

	// $ANTLR end "ESC"

	// $ANTLR start "HEX_DIGIT"
	public final void mHEX_DIGIT() throws RecognitionException {
		try {
			// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:405:2:
			// ( ( '0' .. '9' | 'a' .. 'f' | 'A' .. 'F' ) )
			// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:405:4:
			// ( '0' .. '9' | 'a' .. 'f' | 'A' .. 'F' )
			{
				if ( (input.LA(1) >= '0' && input.LA(1) <= '9') || (input.LA(1) >= 'A' && input.LA(1) <= 'F')
						|| (input.LA(1) >= 'a' && input.LA(1) <= 'f')) {
					input.consume();

				} else {
					MismatchedSetException mse= new MismatchedSetException(null, input);
					recover(mse);
					throw mse;
				}


			}

		} finally {
		}
	}

	// $ANTLR end "HEX_DIGIT"

	// $ANTLR start "ASSIGN"
	public final void mASSIGN() throws RecognitionException {
		try {
			int _type= ASSIGN;
			int _channel= DEFAULT_TOKEN_CHANNEL;
			// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:442:2:
			// ( ':=' )
			// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:442:4:
			// ':='
			{
				match(":=");


			}

			state.type= _type;
			state.channel= _channel;
		} finally {
		}
	}

	// $ANTLR end "ASSIGN"

	// $ANTLR start "PLUS"
	public final void mPLUS() throws RecognitionException {
		try {
			int _type= PLUS;
			int _channel= DEFAULT_TOKEN_CHANNEL;
			// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:444:2:
			// ( '+' )
			// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:444:4:
			// '+'
			{
				match('+');

			}

			state.type= _type;
			state.channel= _channel;
		} finally {
		}
	}

	// $ANTLR end "PLUS"

	// $ANTLR start "MINUS"
	public final void mMINUS() throws RecognitionException {
		try {
			int _type= MINUS;
			int _channel= DEFAULT_TOKEN_CHANNEL;
			// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:446:2:
			// ( '-' )
			// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:446:4:
			// '-'
			{
				match('-');

			}

			state.type= _type;
			state.channel= _channel;
		} finally {
		}
	}

	// $ANTLR end "MINUS"

	// $ANTLR start "MULT"
	public final void mMULT() throws RecognitionException {
		try {
			int _type= MULT;
			int _channel= DEFAULT_TOKEN_CHANNEL;
			// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:448:2:
			// ( '*' )
			// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:448:4:
			// '*'
			{
				match('*');

			}

			state.type= _type;
			state.channel= _channel;
		} finally {
		}
	}

	// $ANTLR end "MULT"

	// $ANTLR start "DIV"
	public final void mDIV() throws RecognitionException {
		try {
			int _type= DIV;
			int _channel= DEFAULT_TOKEN_CHANNEL;
			// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:450:2:
			// ( '/' )
			// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:450:4:
			// '/'
			{
				match('/');

			}

			state.type= _type;
			state.channel= _channel;
		} finally {
		}
	}

	// $ANTLR end "DIV"

	// $ANTLR start "MOD"
	public final void mMOD() throws RecognitionException {
		try {
			int _type= MOD;
			int _channel= DEFAULT_TOKEN_CHANNEL;
			// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:452:2:
			// ( '%' )
			// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:452:4:
			// '%'
			{
				match('%');

			}

			state.type= _type;
			state.channel= _channel;
		} finally {
		}
	}

	// $ANTLR end "MOD"

	// $ANTLR start "OR"
	public final void mOR() throws RecognitionException {
		try {
			int _type= OR;
			int _channel= DEFAULT_TOKEN_CHANNEL;
			// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:454:2:
			// ( '||' )
			// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:454:4:
			// '||'
			{
				match("||");


			}

			state.type= _type;
			state.channel= _channel;
		} finally {
		}
	}

	// $ANTLR end "OR"

	// $ANTLR start "OR2"
	public final void mOR2() throws RecognitionException {
		try {
			int _type= OR2;
			int _channel= DEFAULT_TOKEN_CHANNEL;
			// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:456:2:
			// ( 'or' )
			// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:456:4:
			// 'or'
			{
				match("or");


			}

			state.type= _type;
			state.channel= _channel;
		} finally {
		}
	}

	// $ANTLR end "OR2"

	// $ANTLR start "AND"
	public final void mAND() throws RecognitionException {
		try {
			int _type= AND;
			int _channel= DEFAULT_TOKEN_CHANNEL;
			// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:458:2:
			// ( '&&' )
			// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:458:4:
			// '&&'
			{
				match("&&");


			}

			state.type= _type;
			state.channel= _channel;
		} finally {
		}
	}

	// $ANTLR end "AND"

	// $ANTLR start "AND2"
	public final void mAND2() throws RecognitionException {
		try {
			int _type= AND2;
			int _channel= DEFAULT_TOKEN_CHANNEL;
			// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:460:2:
			// ( 'and' )
			// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:460:4:
			// 'and'
			{
				match("and");


			}

			state.type= _type;
			state.channel= _channel;
		} finally {
		}
	}

	// $ANTLR end "AND2"

	// $ANTLR start "NOT"
	public final void mNOT() throws RecognitionException {
		try {
			int _type= NOT;
			int _channel= DEFAULT_TOKEN_CHANNEL;
			// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:462:2:
			// ( '!' )
			// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:462:4:
			// '!'
			{
				match('!');

			}

			state.type= _type;
			state.channel= _channel;
		} finally {
		}
	}

	// $ANTLR end "NOT"

	// $ANTLR start "EQUALS"
	public final void mEQUALS() throws RecognitionException {
		try {
			int _type= EQUALS;
			int _channel= DEFAULT_TOKEN_CHANNEL;
			// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:464:2:
			// ( '=' )
			// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:464:4:
			// '='
			{
				match('=');

			}

			state.type= _type;
			state.channel= _channel;
		} finally {
		}
	}

	// $ANTLR end "EQUALS"

	// $ANTLR start "EQUALS2"
	public final void mEQUALS2() throws RecognitionException {
		try {
			int _type= EQUALS2;
			int _channel= DEFAULT_TOKEN_CHANNEL;
			// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:466:2:
			// ( '==' )
			// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:466:4:
			// '=='
			{
				match("==");


			}

			state.type= _type;
			state.channel= _channel;
		} finally {
		}
	}

	// $ANTLR end "EQUALS2"

	// $ANTLR start "NOT_EQUALS"
	public final void mNOT_EQUALS() throws RecognitionException {
		try {
			int _type= NOT_EQUALS;
			int _channel= DEFAULT_TOKEN_CHANNEL;
			// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:468:2:
			// ( '!=' )
			// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:468:4:
			// '!='
			{
				match("!=");


			}

			state.type= _type;
			state.channel= _channel;
		} finally {
		}
	}

	// $ANTLR end "NOT_EQUALS"

	// $ANTLR start "LESS"
	public final void mLESS() throws RecognitionException {
		try {
			int _type= LESS;
			int _channel= DEFAULT_TOKEN_CHANNEL;
			// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:470:2:
			// ( '<' )
			// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:470:4:
			// '<'
			{
				match('<');

			}

			state.type= _type;
			state.channel= _channel;
		} finally {
		}
	}

	// $ANTLR end "LESS"

	// $ANTLR start "LESS_EQUAL"
	public final void mLESS_EQUAL() throws RecognitionException {
		try {
			int _type= LESS_EQUAL;
			int _channel= DEFAULT_TOKEN_CHANNEL;
			// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:472:2:
			// ( '<=' )
			// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:472:4:
			// '<='
			{
				match("<=");


			}

			state.type= _type;
			state.channel= _channel;
		} finally {
		}
	}

	// $ANTLR end "LESS_EQUAL"

	// $ANTLR start "GREATER"
	public final void mGREATER() throws RecognitionException {
		try {
			int _type= GREATER;
			int _channel= DEFAULT_TOKEN_CHANNEL;
			// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:474:2:
			// ( '>' )
			// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:474:4:
			// '>'
			{
				match('>');

			}

			state.type= _type;
			state.channel= _channel;
		} finally {
		}
	}

	// $ANTLR end "GREATER"

	// $ANTLR start "GREATER_EQUAL"
	public final void mGREATER_EQUAL() throws RecognitionException {
		try {
			int _type= GREATER_EQUAL;
			int _channel= DEFAULT_TOKEN_CHANNEL;
			// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:476:2:
			// ( '>=' )
			// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:476:4:
			// '>='
			{
				match(">=");


			}

			state.type= _type;
			state.channel= _channel;
		} finally {
		}
	}

	// $ANTLR end "GREATER_EQUAL"

	// $ANTLR start "DOT"
	public final void mDOT() throws RecognitionException {
		try {
			int _type= DOT;
			int _channel= DEFAULT_TOKEN_CHANNEL;
			// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:478:2:
			// ( '.' )
			// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:478:4:
			// '.'
			{
				match('.');

			}

			state.type= _type;
			state.channel= _channel;
		} finally {
		}
	}

	// $ANTLR end "DOT"

	// $ANTLR start "SEMICOLON"
	public final void mSEMICOLON() throws RecognitionException {
		try {
			int _type= SEMICOLON;
			int _channel= DEFAULT_TOKEN_CHANNEL;
			// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:480:2:
			// ( ';' )
			// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:480:4:
			// ';'
			{
				match(';');

			}

			state.type= _type;
			state.channel= _channel;
		} finally {
		}
	}

	// $ANTLR end "SEMICOLON"

	// $ANTLR start "COLON"
	public final void mCOLON() throws RecognitionException {
		try {
			int _type= COLON;
			int _channel= DEFAULT_TOKEN_CHANNEL;
			// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:482:2:
			// ( ':' )
			// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:482:4:
			// ':'
			{
				match(':');

			}

			state.type= _type;
			state.channel= _channel;
		} finally {
		}
	}

	// $ANTLR end "COLON"

	// $ANTLR start "SCOPE_REF"
	public final void mSCOPE_REF() throws RecognitionException {
		try {
			int _type= SCOPE_REF;
			int _channel= DEFAULT_TOKEN_CHANNEL;
			// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:484:2:
			// ( '::' )
			// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:484:4:
			// '::'
			{
				match("::");


			}

			state.type= _type;
			state.channel= _channel;
		} finally {
		}
	}

	// $ANTLR end "SCOPE_REF"

	// $ANTLR start "SIGN"
	public final void mSIGN() throws RecognitionException {
		try {
			int _type= SIGN;
			int _channel= DEFAULT_TOKEN_CHANNEL;
			// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:486:2:
			// ( '_' )
			// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:486:4:
			// '_'
			{
				match('_');

			}

			state.type= _type;
			state.channel= _channel;
		} finally {
		}
	}

	// $ANTLR end "SIGN"

	// $ANTLR start "ARRAY"
	public final void mARRAY() throws RecognitionException {
		try {
			int _type= ARRAY;
			int _channel= DEFAULT_TOKEN_CHANNEL;
			// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:488:2:
			// ( '[]' )
			// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:488:4:
			// '[]'
			{
				match("[]");


			}

			state.type= _type;
			state.channel= _channel;
		} finally {
		}
	}

	// $ANTLR end "ARRAY"

	// $ANTLR start "SET"
	public final void mSET() throws RecognitionException {
		try {
			int _type= SET;
			int _channel= DEFAULT_TOKEN_CHANNEL;
			// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:490:2:
			// ( '{}' )
			// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:490:4:
			// '{}'
			{
				match("{}");


			}

			state.type= _type;
			state.channel= _channel;
		} finally {
		}
	}

	// $ANTLR end "SET"

	// $ANTLR start "SINGLE_QUOTE"
	public final void mSINGLE_QUOTE() throws RecognitionException {
		try {
			int _type= SINGLE_QUOTE;
			int _channel= DEFAULT_TOKEN_CHANNEL;
			// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:492:2:
			// ( '\\'' )
			// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:492:4:
			// '\\''
			{
				match('\'');

			}

			state.type= _type;
			state.channel= _channel;
		} finally {
		}
	}

	// $ANTLR end "SINGLE_QUOTE"

	// $ANTLR start "UMLAUTS"
	public final void mUMLAUTS() throws RecognitionException {
		try {
			int _type= UMLAUTS;
			int _channel= DEFAULT_TOKEN_CHANNEL;
			// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:494:2:
			// ( 'ä' | 'ö' | 'ü' | 'Ä' | 'Ö' | 'Ü' | 'ß' )
			// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:
			{
				if (input.LA(1) == '\u00C4' || input.LA(1) == '\u00D6' || input.LA(1) == '\u00DC' || input.LA(1) == '\u00DF'
						|| input.LA(1) == '\u00E4' || input.LA(1) == '\u00F6' || input.LA(1) == '\u00FC') {
					input.consume();

				} else {
					MismatchedSetException mse= new MismatchedSetException(null, input);
					recover(mse);
					throw mse;
				}


			}

			state.type= _type;
			state.channel= _channel;
		} finally {
		}
	}

	// $ANTLR end "UMLAUTS"

	// $ANTLR start "NULL"
	public final void mNULL() throws RecognitionException {
		try {
			int _type= NULL;
			int _channel= DEFAULT_TOKEN_CHANNEL;
			// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:496:6:
			// ( 'null' )
			// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:496:8:
			// 'null'
			{
				match("null");


			}

			state.type= _type;
			state.channel= _channel;
		} finally {
		}
	}

	// $ANTLR end "NULL"

	// $ANTLR start "TRUE"
	public final void mTRUE() throws RecognitionException {
		try {
			int _type= TRUE;
			int _channel= DEFAULT_TOKEN_CHANNEL;
			// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:498:6:
			// ( 'true' )
			// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:498:8:
			// 'true'
			{
				match("true");


			}

			state.type= _type;
			state.channel= _channel;
		} finally {
		}
	}

	// $ANTLR end "TRUE"

	// $ANTLR start "FALSE"
	public final void mFALSE() throws RecognitionException {
		try {
			int _type= FALSE;
			int _channel= DEFAULT_TOKEN_CHANNEL;
			// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:500:7:
			// ( 'false' )
			// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:500:9:
			// 'false'
			{
				match("false");


			}

			state.type= _type;
			state.channel= _channel;
		} finally {
		}
	}

	// $ANTLR end "FALSE"

	// $ANTLR start "ID"
	public final void mID() throws RecognitionException {
		try {
			int _type= ID;
			int _channel= DEFAULT_TOKEN_CHANNEL;
			// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:503:4:
			// ( ( 'a' .. 'z' | 'A' .. 'Z' | SIGN ) ( 'a' .. 'z' | 'A' .. 'Z' |
			// '0' .. '9' | SIGN )* )
			// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:503:6:
			// ( 'a' .. 'z' | 'A' .. 'Z' | SIGN ) ( 'a' .. 'z' | 'A' .. 'Z' |
			// '0' .. '9' | SIGN )*
			{
				if ( (input.LA(1) >= 'A' && input.LA(1) <= 'Z') || input.LA(1) == '_' || (input.LA(1) >= 'a' && input.LA(1) <= 'z')) {
					input.consume();

				} else {
					MismatchedSetException mse= new MismatchedSetException(null, input);
					recover(mse);
					throw mse;
				}

				// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:503:33:
				// ( 'a' .. 'z' | 'A' .. 'Z' | '0' .. '9' | SIGN )*
				loop6: do {
					int alt6= 2;
					int LA6_0= input.LA(1);

					if ( ( (LA6_0 >= '0' && LA6_0 <= '9') || (LA6_0 >= 'A' && LA6_0 <= 'Z') || LA6_0 == '_' || (LA6_0 >= 'a' && LA6_0 <= 'z'))) {
						alt6= 1;
					}


					switch (alt6) {
						case 1:
							// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:
						{
							if ( (input.LA(1) >= '0' && input.LA(1) <= '9') || (input.LA(1) >= 'A' && input.LA(1) <= 'Z') || input.LA(1) == '_'
									|| (input.LA(1) >= 'a' && input.LA(1) <= 'z')) {
								input.consume();

							} else {
								MismatchedSetException mse= new MismatchedSetException(null, input);
								recover(mse);
								throw mse;
							}


						}
							break;

						default:
							break loop6;
					}
				} while (true);


			}

			state.type= _type;
			state.channel= _channel;
		} finally {
		}
	}

	// $ANTLR end "ID"

	// $ANTLR start "ZERO_TO_NINE"
	public final void mZERO_TO_NINE() throws RecognitionException {
		try {
			int _type= ZERO_TO_NINE;
			int _channel= DEFAULT_TOKEN_CHANNEL;
			// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:504:14:
			// ( '0' .. '9' )
			// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:504:16:
			// '0' .. '9'
			{
				matchRange('0', '9');

			}

			state.type= _type;
			state.channel= _channel;
		} finally {
		}
	}

	// $ANTLR end "ZERO_TO_NINE"

	// $ANTLR start "WS"
	public final void mWS() throws RecognitionException {
		try {
			int _type= WS;
			int _channel= DEFAULT_TOKEN_CHANNEL;
			// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:507:5:
			// ( ( ' ' | '\\r' | '\\t' | '\ ' | '\\n' ) )
			// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:507:8:
			// ( ' ' | '\\r' | '\\t' | '\ ' | '\\n' )
			{
				if ( (input.LA(1) >= '\t' && input.LA(1) <= '\n') || (input.LA(1) >= '\f' && input.LA(1) <= '\r') || input.LA(1) == ' ') {
					input.consume();

				} else {
					MismatchedSetException mse= new MismatchedSetException(null, input);
					recover(mse);
					throw mse;
				}

				_channel= HIDDEN;

			}

			state.type= _type;
			state.channel= _channel;
		} finally {
		}
	}

	// $ANTLR end "WS"

	// $ANTLR start "COMMENT"
	public final void mCOMMENT() throws RecognitionException {
		try {
			int _type= COMMENT;
			int _channel= DEFAULT_TOKEN_CHANNEL;
			// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:511:5:
			// ( '/*' ( . )* '*/' )
			// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:511:9:
			// '/*' ( . )* '*/'
			{
				match("/*");

				// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:511:14:
				// ( . )*
				loop7: do {
					int alt7= 2;
					int LA7_0= input.LA(1);

					if ( (LA7_0 == '*')) {
						int LA7_1= input.LA(2);

						if ( (LA7_1 == '/')) {
							alt7= 2;
						} else if ( ( (LA7_1 >= '\u0000' && LA7_1 <= '.') || (LA7_1 >= '0' && LA7_1 <= '\uFFFF'))) {
							alt7= 1;
						}


					} else if ( ( (LA7_0 >= '\u0000' && LA7_0 <= ')') || (LA7_0 >= '+' && LA7_0 <= '\uFFFF'))) {
						alt7= 1;
					}


					switch (alt7) {
						case 1:
							// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:511:14:
							// .
						{
							matchAny();

						}
							break;

						default:
							break loop7;
					}
				} while (true);

				match("*/");

				_channel= HIDDEN;

			}

			state.type= _type;
			state.channel= _channel;
		} finally {
		}
	}

	// $ANTLR end "COMMENT"

	public void mTokens() throws RecognitionException {
		// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:1:8:
		// ( T__41 | T__42 | T__43 | STRING | ASSIGN | PLUS | MINUS | MULT | DIV
		// | MOD | OR | OR2 | AND | AND2 | NOT | EQUALS | EQUALS2 | NOT_EQUALS |
		// LESS | LESS_EQUAL | GREATER | GREATER_EQUAL | DOT | SEMICOLON | COLON
		// | SCOPE_REF | SIGN | ARRAY | SET | SINGLE_QUOTE | UMLAUTS | NULL |
		// TRUE | FALSE | ID | ZERO_TO_NINE | WS | COMMENT )
		int alt8= 38;
		alt8= dfa8.predict(input);
		switch (alt8) {
			case 1:
				// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:1:10:
				// T__41
			{
				mT__41();

			}
				break;
			case 2:
				// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:1:16:
				// T__42
			{
				mT__42();

			}
				break;
			case 3:
				// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:1:22:
				// T__43
			{
				mT__43();

			}
				break;
			case 4:
				// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:1:28:
				// STRING
			{
				mSTRING();

			}
				break;
			case 5:
				// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:1:35:
				// ASSIGN
			{
				mASSIGN();

			}
				break;
			case 6:
				// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:1:42:
				// PLUS
			{
				mPLUS();

			}
				break;
			case 7:
				// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:1:47:
				// MINUS
			{
				mMINUS();

			}
				break;
			case 8:
				// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:1:53:
				// MULT
			{
				mMULT();

			}
				break;
			case 9:
				// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:1:58:
				// DIV
			{
				mDIV();

			}
				break;
			case 10:
				// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:1:62:
				// MOD
			{
				mMOD();

			}
				break;
			case 11:
				// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:1:66:
				// OR
			{
				mOR();

			}
				break;
			case 12:
				// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:1:69:
				// OR2
			{
				mOR2();

			}
				break;
			case 13:
				// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:1:73:
				// AND
			{
				mAND();

			}
				break;
			case 14:
				// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:1:77:
				// AND2
			{
				mAND2();

			}
				break;
			case 15:
				// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:1:82:
				// NOT
			{
				mNOT();

			}
				break;
			case 16:
				// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:1:86:
				// EQUALS
			{
				mEQUALS();

			}
				break;
			case 17:
				// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:1:93:
				// EQUALS2
			{
				mEQUALS2();

			}
				break;
			case 18:
				// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:1:101:
				// NOT_EQUALS
			{
				mNOT_EQUALS();

			}
				break;
			case 19:
				// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:1:112:
				// LESS
			{
				mLESS();

			}
				break;
			case 20:
				// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:1:117:
				// LESS_EQUAL
			{
				mLESS_EQUAL();

			}
				break;
			case 21:
				// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:1:128:
				// GREATER
			{
				mGREATER();

			}
				break;
			case 22:
				// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:1:136:
				// GREATER_EQUAL
			{
				mGREATER_EQUAL();

			}
				break;
			case 23:
				// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:1:150:
				// DOT
			{
				mDOT();

			}
				break;
			case 24:
				// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:1:154:
				// SEMICOLON
			{
				mSEMICOLON();

			}
				break;
			case 25:
				// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:1:164:
				// COLON
			{
				mCOLON();

			}
				break;
			case 26:
				// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:1:170:
				// SCOPE_REF
			{
				mSCOPE_REF();

			}
				break;
			case 27:
				// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:1:180:
				// SIGN
			{
				mSIGN();

			}
				break;
			case 28:
				// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:1:185:
				// ARRAY
			{
				mARRAY();

			}
				break;
			case 29:
				// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:1:191:
				// SET
			{
				mSET();

			}
				break;
			case 30:
				// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:1:195:
				// SINGLE_QUOTE
			{
				mSINGLE_QUOTE();

			}
				break;
			case 31:
				// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:1:208:
				// UMLAUTS
			{
				mUMLAUTS();

			}
				break;
			case 32:
				// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:1:216:
				// NULL
			{
				mNULL();

			}
				break;
			case 33:
				// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:1:221:
				// TRUE
			{
				mTRUE();

			}
				break;
			case 34:
				// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:1:226:
				// FALSE
			{
				mFALSE();

			}
				break;
			case 35:
				// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:1:232:
				// ID
			{
				mID();

			}
				break;
			case 36:
				// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:1:235:
				// ZERO_TO_NINE
			{
				mZERO_TO_NINE();

			}
				break;
			case 37:
				// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:1:248:
				// WS
			{
				mWS();

			}
				break;
			case 38:
				// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:1:251:
				// COMMENT
			{
				mCOMMENT();

			}
				break;

		}

	}


	protected DFA8 dfa8= new DFA8(this);

	static final String DFA8_eotS= "\3\uffff\1\37\1\41\1\44\3\uffff\1\46\2\uffff\1\34\1\uffff\1\34\1"
			+ "\52\1\54\1\56\1\60\2\uffff\1\61\3\uffff\3\34\13\uffff\1\65\1\34" + "\11\uffff\3\34\1\uffff\1\72\3\34\1\uffff\1\76\1\77\1\34\2\uffff"
			+ "\1\101\1\uffff";

	static final String DFA8_eofS= "\102\uffff";

	static final String DFA8_minS= "\1\11\2\uffff\2\0\1\72\3\uffff\1\52\2\uffff\1\162\1\uffff\1\156"
			+ "\4\75\2\uffff\1\60\3\uffff\1\165\1\162\1\141\13\uffff\1\60\1\144"
			+ "\11\uffff\1\154\1\165\1\154\1\uffff\1\60\1\154\1\145\1\163\1\uffff" + "\2\60\1\145\2\uffff\1\60\1\uffff";

	static final String DFA8_maxS= "\1\u00fc\2\uffff\2\uffff\1\75\3\uffff\1\52\2\uffff\1\162\1\uffff"
			+ "\1\156\4\75\2\uffff\1\172\3\uffff\1\165\1\162\1\141\13\uffff\1\172"
			+ "\1\144\11\uffff\1\154\1\165\1\154\1\uffff\1\172\1\154\1\145\1\163" + "\1\uffff\2\172\1\145\2\uffff\1\172\1\uffff";

	static final String DFA8_acceptS= "\1\uffff\1\1\1\2\3\uffff\1\6\1\7\1\10\1\uffff\1\12\1\13\1\uffff"
			+ "\1\15\5\uffff\1\27\1\30\1\uffff\1\34\1\35\1\37\3\uffff\1\43\1\44"
			+ "\1\45\1\3\1\4\1\36\1\5\1\32\1\31\1\46\1\11\2\uffff\1\22\1\17\1\21"
			+ "\1\20\1\24\1\23\1\26\1\25\1\33\3\uffff\1\14\4\uffff\1\16\3\uffff" + "\1\40\1\41\1\uffff\1\42";

	static final String DFA8_specialS= "\3\uffff\1\1\1\0\75\uffff}>";

	static final String[] DFA8_transitionS= {
			"\2\36\1\uffff\2\36\22\uffff\1\36\1\17\1\3\2\uffff\1\12\1\15" + "\1\4\1\1\1\2\1\10\1\6\1\uffff\1\7\1\23\1\11\12\35\1\5\1\24\1"
					+ "\21\1\20\1\22\2\uffff\32\34\1\26\3\uffff\1\25\1\uffff\1\16\4" + "\34\1\33\7\34\1\31\1\14\4\34\1\32\6\34\1\27\1\13\107\uffff\1"
					+ "\30\21\uffff\1\30\5\uffff\1\30\2\uffff\1\30\4\uffff\1\30\21" + "\uffff\1\30\5\uffff\1\30", "", "",
			"\12\40\1\uffff\2\40\1\uffff\ufff2\40", "\12\40\1\uffff\2\40\1\uffff\ufff2\40", "\1\43\2\uffff\1\42", "", "", "", "\1\45", "", "",
			"\1\47", "", "\1\50", "\1\51", "\1\53", "\1\55", "\1\57", "", "", "\12\34\7\uffff\32\34\4\uffff\1\34\1\uffff\32\34", "", "", "", "\1\62",
			"\1\63", "\1\64", "", "", "", "", "", "", "", "", "", "", "", "\12\34\7\uffff\32\34\4\uffff\1\34\1\uffff\32\34", "\1\66", "", "", "", "",
			"", "", "", "", "", "\1\67", "\1\70", "\1\71", "", "\12\34\7\uffff\32\34\4\uffff\1\34\1\uffff\32\34", "\1\73", "\1\74", "\1\75", "",
			"\12\34\7\uffff\32\34\4\uffff\1\34\1\uffff\32\34", "\12\34\7\uffff\32\34\4\uffff\1\34\1\uffff\32\34", "\1\100", "", "",
			"\12\34\7\uffff\32\34\4\uffff\1\34\1\uffff\32\34", "" };

	static final short[] DFA8_eot= DFA.unpackEncodedString(DFA8_eotS);

	static final short[] DFA8_eof= DFA.unpackEncodedString(DFA8_eofS);

	static final char[] DFA8_min= DFA.unpackEncodedStringToUnsignedChars(DFA8_minS);

	static final char[] DFA8_max= DFA.unpackEncodedStringToUnsignedChars(DFA8_maxS);

	static final short[] DFA8_accept= DFA.unpackEncodedString(DFA8_acceptS);

	static final short[] DFA8_special= DFA.unpackEncodedString(DFA8_specialS);

	static final short[][] DFA8_transition;

	static {
		int numStates= DFA8_transitionS.length;
		DFA8_transition= new short[numStates][];
		for (int i= 0; i < numStates; i++) {
			DFA8_transition[i]= DFA.unpackEncodedString(DFA8_transitionS[i]);
		}
	}

	class DFA8 extends DFA {

		public DFA8(BaseRecognizer recognizer) {
			this.recognizer= recognizer;
			this.decisionNumber= 8;
			this.eot= DFA8_eot;
			this.eof= DFA8_eof;
			this.min= DFA8_min;
			this.max= DFA8_max;
			this.accept= DFA8_accept;
			this.special= DFA8_special;
			this.transition= DFA8_transition;
		}

		public String getDescription() {
			return "1:1: Tokens : ( T__41 | T__42 | T__43 | STRING | ASSIGN | PLUS | MINUS | MULT | DIV | MOD | OR | OR2 | AND | AND2 | NOT | EQUALS | EQUALS2 | NOT_EQUALS | LESS | LESS_EQUAL | GREATER | GREATER_EQUAL | DOT | SEMICOLON | COLON | SCOPE_REF | SIGN | ARRAY | SET | SINGLE_QUOTE | UMLAUTS | NULL | TRUE | FALSE | ID | ZERO_TO_NINE | WS | COMMENT );";
		}

		public int specialStateTransition(int s, IntStream _input) throws NoViableAltException {
			IntStream input= _input;
			int _s= s;
			switch (s) {
				case 0:
					int LA8_4= input.LA(1);

					s= -1;
					if ( ( (LA8_4 >= '\u0000' && LA8_4 <= '\t') || (LA8_4 >= '\u000B' && LA8_4 <= '\f') || (LA8_4 >= '\u000E' && LA8_4 <= '\uFFFF'))) {
						s= 32;
					}

					else
						s= 33;

					if (s >= 0)
						return s;
					break;
				case 1:
					int LA8_3= input.LA(1);

					s= -1;
					if ( ( (LA8_3 >= '\u0000' && LA8_3 <= '\t') || (LA8_3 >= '\u000B' && LA8_3 <= '\f') || (LA8_3 >= '\u000E' && LA8_3 <= '\uFFFF'))) {
						s= 32;
					}

					else
						s= 31;

					if (s >= 0)
						return s;
					break;
			}
			NoViableAltException nvae= new NoViableAltException(getDescription(), 8, _s, input);
			error(nvae);
			throw nvae;
		}
	}


}
