/*
 * This file has been developed at the University of Munich, Chair for Programming & Software Engineering.
 * 
 * This file is licensed under the Eclipse Public License (EPL) 1.0
 * 
 */

package eu.mdd4soa.trans.uml2smm.data;

import java.util.ArrayList;
import java.util.List;

import org.antlr.runtime.BitSet;
import org.antlr.runtime.EarlyExitException;
import org.antlr.runtime.MismatchedSetException;
import org.antlr.runtime.NoViableAltException;
import org.antlr.runtime.Parser;
import org.antlr.runtime.ParserRuleReturnScope;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.RecognizerSharedState;
import org.antlr.runtime.Token;
import org.antlr.runtime.TokenStream;
import org.eclipse.emf.common.util.EList;

import eu.mdd4soa.smm.behaviour.CompositeElement;
import eu.mdd4soa.smm.behaviour.ExceptionHandler;
import eu.mdd4soa.smm.behaviour.ServiceActivity;
import eu.mdd4soa.smm.data.Assignment;
import eu.mdd4soa.smm.data.Declaration;
import eu.mdd4soa.smm.data.Expression;
import eu.mdd4soa.smm.data.ISMDataFactory;
import eu.mdd4soa.smm.data.LeftHandSideExpression;
import eu.mdd4soa.smm.data.Literal;
import eu.mdd4soa.smm.data.Operation;
import eu.mdd4soa.smm.data.OperationType;
import eu.mdd4soa.smm.data.PropertyReference;
import eu.mdd4soa.smm.data.RightHandSideExpression;
import eu.mdd4soa.smm.data.Statement;
import eu.mdd4soa.smm.data.Variable;
import eu.mdd4soa.smm.data.VariableReference;
import eu.mdd4soa.smm.exception.TransformationException;
import eu.mdd4soa.smm.statik.MessageProperty;
import eu.mdd4soa.smm.statik.MessageType;
import eu.mdd4soa.smm.statik.Participant;
import eu.mdd4soa.smm.statik.SMMType;
import eu.mdd4soa.trans.uml2smm.SMMUtil;

/**
 * This grammar was written for antlr. The Lexer and Parser are generated from
 * this grammar with antlr.
 * 
 * antlr uses the BSD license.
 * 
 * TODO changed quite a lot in this code; it is no longer equivalent to the code
 * in Data.g.
 * 
 */
public class DataParser extends Parser {
	public static final String[] tokenNames= new String[] { "<invalid>", "<EOR>", "<DOWN>", "<UP>", "ASSIGN", "SEMICOLON", "SCOPE_REF", "DOT", "OR",
			"OR2", "AND", "AND2", "EQUALS2", "EQUALS", "NOT_EQUALS", "LESS", "LESS_EQUAL", "GREATER", "GREATER_EQUAL", "PLUS", "MINUS", "MULT",
			"DIV", "MOD", "NOT", "STRING", "NULL", "TRUE", "FALSE", "ESC", "HEX_DIGIT", "ID", "ARRAY", "SET", "ZERO_TO_NINE", "COLON", "SIGN",
			"SINGLE_QUOTE", "UMLAUTS", "WS", "COMMENT", "'('", "')'", "'\"'" };

	public static final int SIGN= 36;

	public static final int MOD= 23;

	public static final int ESC= 29;

	public static final int EQUALS= 13;

	public static final int NOT= 24;

	public static final int AND= 10;

	public static final int ID= 31;

	public static final int EOF= -1;

	public static final int NOT_EQUALS= 14;

	public static final int UMLAUTS= 38;

	public static final int SCOPE_REF= 6;

	public static final int SINGLE_QUOTE= 37;

	public static final int GREATER= 17;

	public static final int ZERO_TO_NINE= 34;

	public static final int LESS= 15;

	public static final int PLUS= 19;

	public static final int DOT= 7;

	public static final int COMMENT= 40;

	public static final int ARRAY= 32;

	public static final int T__42= 42;

	public static final int T__43= 43;

	public static final int T__41= 41;

	public static final int EQUALS2= 12;

	public static final int AND2= 11;

	public static final int NULL= 26;

	public static final int HEX_DIGIT= 30;

	public static final int SET= 33;

	public static final int SEMICOLON= 5;

	public static final int MINUS= 20;

	public static final int MULT= 21;

	public static final int TRUE= 27;

	public static final int COLON= 35;

	public static final int WS= 39;

	public static final int OR= 8;

	public static final int ASSIGN= 4;

	public static final int OR2= 9;

	public static final int LESS_EQUAL= 16;

	public static final int DIV= 22;

	public static final int FALSE= 28;

	public static final int GREATER_EQUAL= 18;

	public static final int STRING= 25;

	// delegates
	// delegators


	public DataParser(TokenStream input) {
		this(input, new RecognizerSharedState());
	}

	public DataParser(TokenStream input, RecognizerSharedState state) {
		super(input, state);

	}

	public String[] getTokenNames() {
		return DataParser.tokenNames;
	}

	public String getGrammarFileName() {
		return "/home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g";
	}

	// ************************************************************
	// ******************** Custom methods ************************
	// ************************************************************

	private ServiceActivity fCurrentServiceActivity;

	public void setServiceActivity(ServiceActivity currentLocation) {
		fCurrentServiceActivity= currentLocation;
	}

	/**
	 * Tries to retrieve a scope, that is already defined in the context.<br>
	 * <br>
	 * Usage in a data-handling node:<br>
	 * ::scopeName.varName<br>
	 * At the time you reference a <i>scopeName</i> in a data-handling node, you
	 * must have had a scope before, which has the name <i>scopeName</i>.
	 * 
	 * @param name the name of the scope to be found
	 * @return {@link ServiceActivity} with the name matching the
	 *         "name"-parameter.
	 * @throws TransformationException, if no scope is found with that name.
	 *         This means that a) there is no such scope at all or b) there is
	 *         one, but it was not yet processed at the time of processing the
	 *         data handling node.
	 */

	private ServiceActivity getScope(String name) {
		return SMMUtil.resolveServiceActivity(SMMUtil.getParticipant(fCurrentServiceActivity), name);
	}

	/**
	 * This returns the current scope and is used every time a plain variable is
	 * referenced (or declared).<br>
	 * Usage:<br>
	 * varName.someThing<br>
	 * This references a variable named <i>varName</i> in the current Scope.
	 * (which is omitted)<br>
	 * This resembles the usage of the "this" keyword in Java, that refers to
	 * the "scope" of the current Object.
	 * 
	 * @return {@link ServiceActivity} the current scope of the data handling
	 *         node.
	 * @throws TransformationException(RuntimeException) This can occur, when a
	 *         data handling node is placed somewhere outside of scopes (i.e.
	 *         there is no surrounding scope in the UML-model).
	 */
	private ServiceActivity getCurrentScope() {
		return fCurrentServiceActivity;
	}

	/**
	 * Returns the variable for the specified scope (a new one, if not existing
	 * yet). The scope should be the direct parent scope of an activity
	 * 
	 * @param name the name of the variable to search the scope for (or to
	 *        create)
	 * @param parent the scope to search for variables in.
	 * @param typeToUse if variable is declared.
	 * @return the {@link Variable} of the scope with the name in parameter
	 *         "<i>name</i>".
	 * @throws TransformationException
	 */
	private Variable resolveVariable(String name, ServiceActivity parent, SMMType typeToUse, boolean scanFirst) throws TransformationException {

		Variable v= findExistingVariable(name, parent, scanFirst);

		if (v != null)
			return v;

		/*
		 * Variable was not found. This means we have to create a new one. The
		 * type MUST be given in this case.
		 */
		if (typeToUse == null)
			throw new TransformationException("Found a variable (" + name + ") in service activity " + parent.getName()
					+ " which is not yet declared. The type was not given and it cannot be resolved.");

		v= ISMDataFactory.eINSTANCE.createVariable();
		v.setName(name);
		v.setServiceActivity(parent);
		v.setType(typeToUse);
		return v;
	}

	/**
	 * Searches scopes and handlers for a variable with a specific name.
	 * 
	 * @param name the name of the variable to look for
	 * @param current the current composite activity to search in
	 * @param recursive boolean flag indicating, if the search should continue
	 *        in parent of current scope, if no variable was found.
	 */
	private Variable findExistingVariable(String name, CompositeElement current, boolean recursive) {
		if (current instanceof ServiceActivity) {
			for (Variable varInScope : ((ServiceActivity) current).getVariables()) {
				if (varInScope.getName().equals(name)) {
					return varInScope;
				}
			}
		} else if (current instanceof ExceptionHandler) {
			VariableReference parameter= ((ExceptionHandler) current).getCaughtException();
			if (parameter != null) {
				Variable variable= parameter.getVariable();
				if (variable.getName().equals(name)) {
					return variable;
				}
			}
		}
		if (recursive) {
			CompositeElement parent= current.getParent();
			if (parent != null) {
				return findExistingVariable(name, parent, recursive);
			}
		}
		return null;
	}

	/**
	 * This is called, when a declaration needs to be parsed. There the type of
	 * the declared variable is only in string form. The {@link TypeResolver}
	 * class stores all Types specified in the class diagram and can perform the
	 * matching.
	 * 
	 * @param typeName the name of the Type to resolve
	 * @return the UML {@link SMMType} with the same name as the parameter
	 * @throws TransformationException
	 */
	private SMMType resolveType(String typeName) throws TransformationException {

		Participant participant= SMMUtil.getParticipant(fCurrentServiceActivity);
		if (participant == null)
			throw new TransformationException("While trying to resolve a type, could not find the current participant. Current service activity is "
					+ fCurrentServiceActivity);


		SMMType existingType= SMMUtil.resolveType(participant, typeName);

		if (existingType == null) {
			// We are allowed to add simple types on-the-fly.
			if (SMMUtil.isStandardType(typeName)) {
				existingType= SMMUtil.addStandardType(participant, typeName);
			}
		}
		if (existingType == null)
			throw new TransformationException("Could not resolve type: " + typeName + ". Might need to be added to a service interface.");

		return existingType;
	}

	/**
	 * Creates an ISM {@link Operation} with two operands and a type.
	 * 
	 * @param operand1 the first operand (an {@link Expression})
	 * @param type the {@link OperationType} for this binary operation
	 * @param operand2 the second operand (an {@link Expression})
	 * @return the newly created {@link Operation}
	 */
	private Operation createBinaryOperation(Expression operand1, OperationType type, Expression operand2) {
		Operation op= createUnaryOperation(operand1, type);
		op.getOperands().add(operand2);
		return op;
	}

	/**
	 * Creates an ISM {@link Operation} with one operand and a type.
	 * 
	 * @param operand1 the only operand (an {@link Expression})
	 * @param type the {@link OperationType} for this binary operation
	 * @return the newly created {@link Operation}
	 */
	private Operation createUnaryOperation(Expression operand1, OperationType type) {
		Operation op= ISMDataFactory.eINSTANCE.createOperation();
		op.setOperationType(type);
		op.getOperands().add(operand1);
		return op;
	}


	private PropertyReference resolveAttributeReference(LeftHandSideExpression currentParent, String name, ServiceActivity sa)
			throws TransformationException {

		if (currentParent.getType() == null)
			throw new TransformationException("Tried to get the field " + name + " from parent " + currentParent
					+ ", but it does not have an assigned type.");

		if (! (currentParent.getType() instanceof MessageType))
			throw new TransformationException("The owner " + currentParent + " of the field " + name
					+ " does not have a message type. Cannot access a field.");

		MessageProperty found= null;
		EList<MessageProperty> attributes= ((MessageType) currentParent.getType()).getProperties();
		for (MessageProperty attribute : attributes) {
			if (attribute.getIdentifier().equals(name)) {
				found= attribute;
				break;
			}
		}

		if (found == null)
			throw new TransformationException("The type " + currentParent.getType().getName() + " of the parent " + currentParent
					+ " does not have a field called " + name);

		PropertyReference ref= ISMDataFactory.eINSTANCE.createPropertyReference();
		ref.setProperty(found);
		ref.setParent(currentParent);
		ref.setType(found.getType());
		return ref;

	}

	// ************************************************************
	// **************** End of Custom methods *********************
	// ************************************************************



	// $ANTLR start "data"
	// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:231:1:
	// data[DataHandling dh] : (a= assignment | d= declaration )* ;
	public final List<Statement> data() throws RecognitionException, TransformationException {
		Assignment a= null;
		Declaration d= null;

		List<Statement> statements= new ArrayList<Statement>();

		try {
			// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:231:24:
			// ( (a= assignment | d= declaration )* )
			// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:231:26:
			// (a= assignment | d= declaration )*
			{
				// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:232:4:
				// (a= assignment | d= declaration )*
				loop1: do {
					int alt1= 3;
					int LA1_0= input.LA(1);

					if ( (LA1_0 == SCOPE_REF)) {
						alt1= 1;
					} else if ( (LA1_0 == ID)) {
						int LA1_3= input.LA(2);

						if ( ( (LA1_3 >= ID && LA1_3 <= SET))) {
							alt1= 2;
						} else if ( (LA1_3 == ASSIGN || LA1_3 == DOT)) {
							alt1= 1;
						}
					}

					switch (alt1) {
						case 1:
							// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:232:6:
							// a= assignment
						{
							pushFollow(FOLLOW_assignment_in_data51);
							a= assignment();

							state._fsp--;

							statements.add(a);

						}
							break;
						case 2:
							// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:233:6:
							// d= declaration
						{
							pushFollow(FOLLOW_declaration_in_data65);
							d= declaration();

							state._fsp--;

							statements.add(d);

						}
							break;

						default:
							break loop1;
					}
				} while (true);


			}

		} catch (RecognitionException re) {
			reportError(re);
			recover(input, re);
		} finally {
		}

		return statements;
	}

	// $ANTLR end "data"


	// $ANTLR start "assignment"
	// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:235:1:
	// assignment returns [Assignment value] : l= leftHandExp[this.currentScope]
	// ASSIGN e= rightHandExp[this.currentScope] SEMICOLON ;
	public final Assignment assignment() throws RecognitionException, TransformationException {
		Assignment value= null;

		LeftHandSideExpression l= null;

		RightHandSideExpression e= null;


		try {
			// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:235:39:
			// (l= leftHandExp[this.currentScope] ASSIGN e=
			// rightHandExp[this.currentScope] SEMICOLON )
			// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:235:41:
			// l= leftHandExp[this.currentScope] ASSIGN e=
			// rightHandExp[this.currentScope] SEMICOLON
			{
				value= ISMDataFactory.eINSTANCE.createAssignment();
				pushFollow(FOLLOW_leftHandExp_in_assignment90);
				l= leftHandExp(null);

				state._fsp--;

				value.setTarget(l);
				match(input, ASSIGN, FOLLOW_ASSIGN_in_assignment99);
				pushFollow(FOLLOW_rightHandExp_in_assignment109);
				e= rightHandExp();

				state._fsp--;

				value.setSource(e);
				match(input, SEMICOLON, FOLLOW_SEMICOLON_in_assignment114);

			}

		} catch (RecognitionException re) {
			reportError(re);
			recover(input, re);
		} finally {
		}
		return value;
	}

	// $ANTLR end "assignment"


	// $ANTLR start "declaration"
	// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:240:1:
	// declaration returns [Declaration value] : t= typeName e=
	// variable[getCurrentScope(),false] SEMICOLON ;
	public final Declaration declaration() throws RecognitionException, TransformationException {
		Declaration value= null;

		DataParser.typeName_return t= null;

		VariableReference e= null;


		try {
			// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:240:41:
			// (t= typeName e= variable[getCurrentScope(),false] SEMICOLON )
			// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:241:4:
			// t= typeName e= variable[getCurrentScope(),false] SEMICOLON
			{
				pushFollow(FOLLOW_typeName_in_declaration131);
				t= typeName();

				state._fsp--;

				pushFollow(FOLLOW_variable_in_declaration141);

				e= variableRef(getCurrentScope(), t.value, false);
				value= ISMDataFactory.eINSTANCE.createDeclaration();
				value.setDeclaredVar(e);

				state._fsp--;
				match(input, SEMICOLON, FOLLOW_SEMICOLON_in_declaration149);

			}

		} catch (RecognitionException re) {
			reportError(re);
			recover(input, re);
		} finally {
		}
		return value;
	}

	// $ANTLR end "declaration"


	// $ANTLR start "scopeName"
	// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:248:1:
	// scopeName returns [String value] : SCOPE_REF e= name ;
	public final String scopeName() throws RecognitionException {
		String value= null;

		DataParser.name_return e= null;


		try {
			// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:249:2:
			// ( SCOPE_REF e= name )
			// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:249:4:
			// SCOPE_REF e= name
			{
				match(input, SCOPE_REF, FOLLOW_SCOPE_REF_in_scopeName164);
				pushFollow(FOLLOW_name_in_scopeName170);
				e= name();

				state._fsp--;

				value= (e != null ? e.value : null);

			}

		} catch (RecognitionException re) {
			reportError(re);
			recover(input, re);
		} finally {
		}
		return value;
	}

	// $ANTLR end "scopeName"


	// $ANTLR start "variable"
	// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:250:1:
	// variable[ServiceActivity sc,boolean recursive] returns [Variable value] :
	// e= name ;
	public final VariableReference variableRef(ServiceActivity context, SMMType typeToUse, boolean recursive) throws RecognitionException,
			TransformationException {
		VariableReference value= null;

		DataParser.name_return e= null;


		try {
			// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:251:2:
			// (e= name )
			// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:251:4:
			// e= name
			{
				pushFollow(FOLLOW_name_in_variable189);
				e= name();

				state._fsp--;

				Variable var= resolveVariable( (e != null ? e.value : null), context, typeToUse, recursive);
				VariableReference ref= ISMDataFactory.eINSTANCE.createVariableReference();
				ref.setVariable(var);
				ref.setType(var.getType());
				value= ref;

			}

		} catch (RecognitionException re) {
			reportError(re);
			recover(input, re);
		} finally {
		}
		return value;
	}

	// $ANTLR end "variable"


	// $ANTLR start "field"
	// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:253:1:
	// field[LeftHandSideExpression parent] returns [Field value] : ( ( DOT f=
	// name )+ ) ;
	public final PropertyReference field(LeftHandSideExpression e) throws RecognitionException, TransformationException {
		PropertyReference value= null;

		DataParser.name_return f= null;


		try {
			// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:254:2:
			// ( ( ( DOT f= name )+ ) )
			// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:254:4:
			// ( ( DOT f= name )+ )
			{
				LeftHandSideExpression currentParent= e;
				// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:255:2:
				// ( ( DOT f= name )+ )
				// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:255:3:
				// ( DOT f= name )+
				{
					// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:255:3:
					// ( DOT f= name )+
					int cnt2= 0;
					loop2: do {
						int alt2= 2;
						int LA2_0= input.LA(1);

						if ( (LA2_0 == DOT)) {
							alt2= 1;
						}


						switch (alt2) {
							case 1:
								// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:256:3:
								// DOT f= name
							{
								match(input, DOT, FOLLOW_DOT_in_field215);
								pushFollow(FOLLOW_name_in_field219);
								f= name();

								state._fsp--;

								value= resolveAttributeReference(currentParent, (f != null ? f.value : null), fCurrentServiceActivity);

								currentParent= value;

							}
								break;

							default:
								if (cnt2 >= 1)
									break loop2;
								EarlyExitException eee= new EarlyExitException(2, input);
								throw eee;
						}
						cnt2++;
					} while (true);


				}


			}

		} catch (RecognitionException re) {
			reportError(re);
			recover(input, re);
		} finally {
		}
		return value;
	}

	// $ANTLR end "field"


	// $ANTLR start "parExpression"
	// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:264:1:
	// parExpression returns [RightHandSideExpression value] : '(' rhs=
	// rightHandExp[this.currentScope] ')' ;
	public final RightHandSideExpression parExpression() throws RecognitionException, TransformationException {
		RightHandSideExpression value= null;

		RightHandSideExpression rhs= null;


		try {
			// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:265:2:
			// ( '(' rhs= rightHandExp[this.currentScope] ')' )
			// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:265:4:
			// '(' rhs= rightHandExp[this.currentScope] ')'
			{
				match(input, 41, FOLLOW_41_in_parExpression243);
				pushFollow(FOLLOW_rightHandExp_in_parExpression247);
				rhs= rightHandExp();

				state._fsp--;

				match(input, 42, FOLLOW_42_in_parExpression250);
				value= rhs;

			}

		} catch (RecognitionException re) {
			reportError(re);
			recover(input, re);
		} finally {
		}
		return value;
	}

	// $ANTLR end "parExpression"


	// $ANTLR start "leftHandExp"
	// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:270:1:
	// leftHandExp[ServiceActivity sc] returns [LeftHandSideExpression value] :
	// (s= scopeName DOT e= variable[getScope(s),false] | e= variable[sc,true] )
	// (f= field[$value] )? ;
	public final LeftHandSideExpression leftHandExp(SMMType typeIfNotExists) throws RecognitionException, TransformationException {
		LeftHandSideExpression value= null;

		String s= null;

		VariableReference e= null;
		PropertyReference f= null;


		try {
			// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:271:2:
			// ( (s= scopeName DOT e= variable[getScope(s),false] | e=
			// variable[sc,true] ) (f= field[$value] )? )
			// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:271:4:
			// (s= scopeName DOT e= variable[getScope(s),false] | e=
			// variable[sc,true] ) (f= field[$value] )?
			{
				// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:272:2:
				// (s= scopeName DOT e= variable[getScope(s),false] | e=
				// variable[sc,true] )
				int alt3= 2;
				int LA3_0= input.LA(1);

				if ( (LA3_0 == SCOPE_REF)) {
					alt3= 1;
				} else if ( (LA3_0 == ID)) {
					alt3= 2;
				} else {
					NoViableAltException nvae= new NoViableAltException("", 3, 0, input);

					throw nvae;
				}
				switch (alt3) {
					case 1:
						// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:272:3:
						// s= scopeName DOT e= variable[getScope(s),false]
					{
						pushFollow(FOLLOW_scopeName_in_leftHandExp279);
						s= scopeName();

						state._fsp--;

						match(input, DOT, FOLLOW_DOT_in_leftHandExp281);
						pushFollow(FOLLOW_variable_in_leftHandExp287);
						e= variableRef(getScope(s), typeIfNotExists, false);

						state._fsp--;


					}
						break;
					case 2:
						// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:273:7:
						// e= variable[sc,true]
					{
						pushFollow(FOLLOW_variable_in_leftHandExp300);
						e= variableRef(fCurrentServiceActivity, typeIfNotExists, true);

						state._fsp--;


					}
						break;

				}

				value= e;
				// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:275:2:
				// (f= field[$value] )?
				int alt4= 2;
				int LA4_0= input.LA(1);

				if ( (LA4_0 == DOT)) {
					alt4= 1;
				}
				switch (alt4) {
					case 1:
						// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:275:3:
						// f= field[$value]
					{
						pushFollow(FOLLOW_field_in_leftHandExp311);
						f= field(e);

						state._fsp--;

						value= f;

					}
						break;

				}


			}

		} catch (RecognitionException re) {
			reportError(re);
			recover(input, re);
		} finally {
		}
		return value;
	}

	// $ANTLR end "leftHandExp"


	// $ANTLR start "rightHandExp"
	// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:277:1:
	// rightHandExp[ServiceActivity sc] returns [RightHandSideExpression value]
	// : (op= conditionalOrOperation ) ;
	public final RightHandSideExpression rightHandExp() throws RecognitionException, TransformationException {
		RightHandSideExpression value= null;

		RightHandSideExpression op= null;

		try {
			// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:278:2:
			// ( (op= conditionalOrOperation ) )
			// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:278:4:
			// (op= conditionalOrOperation )
			{
				// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:279:3:
				// (op= conditionalOrOperation )
				// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:279:4:
				// op= conditionalOrOperation
				{
					pushFollow(FOLLOW_conditionalOrOperation_in_rightHandExp341);
					op= conditionalOrOperation();

					state._fsp--;

					value= op;
				}
			}

		} catch (RecognitionException re) {
			reportError(re);
			recover(input, re);
		} finally {
		}
		return value;
	}

	// $ANTLR end "rightHandExp"


	// $ANTLR start "conditionalOrOperation"
	// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:281:1:
	// conditionalOrOperation returns [RightHandSideExpression value] : op2=
	// conditionalAndOperation ( ( OR | OR2 ) op2= conditionalAndOperation )* ;
	public final RightHandSideExpression conditionalOrOperation() throws RecognitionException, TransformationException {
		RightHandSideExpression value= null;

		RightHandSideExpression op2= null;


		try {
			// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:282:2:
			// (op2= conditionalAndOperation ( ( OR | OR2 ) op2=
			// conditionalAndOperation )* )
			// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:282:5:
			// op2= conditionalAndOperation ( ( OR | OR2 ) op2=
			// conditionalAndOperation )*
			{
				pushFollow(FOLLOW_conditionalAndOperation_in_conditionalOrOperation364);
				op2= conditionalAndOperation();

				state._fsp--;

				value= op2;
				RightHandSideExpression lastOp= value;
				// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:283:4:
				// ( ( OR | OR2 ) op2= conditionalAndOperation )*
				loop5: do {
					int alt5= 2;
					int LA5_0= input.LA(1);

					if ( ( (LA5_0 >= OR && LA5_0 <= OR2))) {
						alt5= 1;
					}


					switch (alt5) {
						case 1:
							// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:283:5:
							// ( OR | OR2 ) op2= conditionalAndOperation
						{
							if ( (input.LA(1) >= OR && input.LA(1) <= OR2)) {
								input.consume();
								state.errorRecovery= false;
							} else {
								MismatchedSetException mse= new MismatchedSetException(null, input);
								throw mse;
							}

							pushFollow(FOLLOW_conditionalAndOperation_in_conditionalOrOperation383);
							op2= conditionalAndOperation();

							state._fsp--;

							value= createBinaryOperation(lastOp, OperationType.OR, op2);
							lastOp= value;

						}
							break;

						default:
							break loop5;
					}
				} while (true);


			}

		} catch (RecognitionException re) {
			reportError(re);
			recover(input, re);
		} finally {
		}
		return value;
	}

	// $ANTLR end "conditionalOrOperation"


	// $ANTLR start "conditionalAndOperation"
	// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:285:1:
	// conditionalAndOperation returns [RightHandSideExpression value] : op2=
	// equalityOperation ( ( AND | AND2 ) op2= equalityOperation )* ;
	public final RightHandSideExpression conditionalAndOperation() throws RecognitionException, TransformationException {
		RightHandSideExpression value= null;

		RightHandSideExpression op2= null;


		try {
			// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:286:2:
			// (op2= equalityOperation ( ( AND | AND2 ) op2= equalityOperation
			// )* )
			// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:286:4:
			// op2= equalityOperation ( ( AND | AND2 ) op2= equalityOperation )*
			{
				pushFollow(FOLLOW_equalityOperation_in_conditionalAndOperation404);
				op2= equalityOperation();

				state._fsp--;

				value= op2;
				RightHandSideExpression lastOp= value;
				// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:287:2:
				// ( ( AND | AND2 ) op2= equalityOperation )*
				loop6: do {
					int alt6= 2;
					int LA6_0= input.LA(1);

					if ( ( (LA6_0 >= AND && LA6_0 <= AND2))) {
						alt6= 1;
					}


					switch (alt6) {
						case 1:
							// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:287:3:
							// ( AND | AND2 ) op2= equalityOperation
						{
							if ( (input.LA(1) >= AND && input.LA(1) <= AND2)) {
								input.consume();
								state.errorRecovery= false;
							} else {
								MismatchedSetException mse= new MismatchedSetException(null, input);
								throw mse;
							}

							pushFollow(FOLLOW_equalityOperation_in_conditionalAndOperation422);
							op2= equalityOperation();

							state._fsp--;

							value= createBinaryOperation(lastOp, OperationType.AND, op2);
							lastOp= value;

						}
							break;

						default:
							break loop6;
					}
				} while (true);


			}

		} catch (RecognitionException re) {
			reportError(re);
			recover(input, re);
		} finally {
		}
		return value;
	}

	// $ANTLR end "conditionalAndOperation"


	// $ANTLR start "equalityOperation"
	// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:289:1:
	// equalityOperation returns [RightHandSideExpression value] : op2=
	// relationalOperation ( ( ( EQUALS2 | EQUALS ) op2= relationalOperation |
	// NOT_EQUALS op2= relationalOperation ) )* ;
	public final RightHandSideExpression equalityOperation() throws RecognitionException, TransformationException {
		RightHandSideExpression value= null;

		RightHandSideExpression op2= null;


		try {
			// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:290:2:
			// (op2= relationalOperation ( ( ( EQUALS2 | EQUALS ) op2=
			// relationalOperation | NOT_EQUALS op2= relationalOperation ) )* )
			// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:290:4:
			// op2= relationalOperation ( ( ( EQUALS2 | EQUALS ) op2=
			// relationalOperation | NOT_EQUALS op2= relationalOperation ) )*
			{
				pushFollow(FOLLOW_relationalOperation_in_equalityOperation444);
				op2= relationalOperation();

				state._fsp--;

				value= op2;
				RightHandSideExpression lastOp= value;
				OperationType type= null;
				// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:291:2:
				// ( ( ( EQUALS2 | EQUALS ) op2= relationalOperation |
				// NOT_EQUALS op2= relationalOperation ) )*
				loop8: do {
					int alt8= 2;
					int LA8_0= input.LA(1);

					if ( ( (LA8_0 >= EQUALS2 && LA8_0 <= NOT_EQUALS))) {
						alt8= 1;
					}


					switch (alt8) {
						case 1:
							// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:291:3:
							// ( ( EQUALS2 | EQUALS ) op2= relationalOperation |
							// NOT_EQUALS op2= relationalOperation )
						{
							// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:291:3:
							// ( ( EQUALS2 | EQUALS ) op2= relationalOperation |
							// NOT_EQUALS op2= relationalOperation )
							int alt7= 2;
							int LA7_0= input.LA(1);

							if ( ( (LA7_0 >= EQUALS2 && LA7_0 <= EQUALS))) {
								alt7= 1;
							} else if ( (LA7_0 == NOT_EQUALS)) {
								alt7= 2;
							} else {
								NoViableAltException nvae= new NoViableAltException("", 7, 0, input);

								throw nvae;
							}
							switch (alt7) {
								case 1:
									// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:291:4:
									// ( EQUALS2 | EQUALS ) op2=
									// relationalOperation
								{
									if ( (input.LA(1) >= EQUALS2 && input.LA(1) <= EQUALS)) {
										input.consume();
										state.errorRecovery= false;
									} else {
										MismatchedSetException mse= new MismatchedSetException(null, input);
										throw mse;
									}

									pushFollow(FOLLOW_relationalOperation_in_equalityOperation463);
									op2= relationalOperation();

									state._fsp--;

									type= OperationType.EQUALS;

								}
									break;
								case 2:
									// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:292:4:
									// NOT_EQUALS op2= relationalOperation
								{
									match(input, NOT_EQUALS, FOLLOW_NOT_EQUALS_in_equalityOperation470);
									pushFollow(FOLLOW_relationalOperation_in_equalityOperation476);
									op2= relationalOperation();

									state._fsp--;

									type= OperationType.NOT_EQUALS;

								}
									break;

							}

							value= createBinaryOperation(lastOp, type, op2);
							lastOp= value;

						}
							break;

						default:
							break loop8;
					}
				} while (true);


			}

		} catch (RecognitionException re) {
			reportError(re);
			recover(input, re);
		} finally {
		}
		return value;
	}

	// $ANTLR end "equalityOperation"


	// $ANTLR start "relationalOperation"
	// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:295:1:
	// relationalOperation returns [RightHandSideExpression value] : op2=
	// additiveOperation ( ( LESS op2= additiveOperation | LESS_EQUAL op2=
	// additiveOperation | GREATER op2= additiveOperation | GREATER_EQUAL op2=
	// additiveOperation ) )* ;
	public final RightHandSideExpression relationalOperation() throws RecognitionException, TransformationException {
		RightHandSideExpression value= null;

		RightHandSideExpression op2= null;


		try {
			// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:296:2:
			// (op2= additiveOperation ( ( LESS op2= additiveOperation |
			// LESS_EQUAL op2= additiveOperation | GREATER op2=
			// additiveOperation | GREATER_EQUAL op2= additiveOperation ) )* )
			// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:296:4:
			// op2= additiveOperation ( ( LESS op2= additiveOperation |
			// LESS_EQUAL op2= additiveOperation | GREATER op2=
			// additiveOperation | GREATER_EQUAL op2= additiveOperation ) )*
			{
				pushFollow(FOLLOW_additiveOperation_in_relationalOperation501);
				op2= additiveOperation();

				state._fsp--;

				value= op2;
				RightHandSideExpression lastOp= value;
				OperationType type= null;
				// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:297:2:
				// ( ( LESS op2= additiveOperation | LESS_EQUAL op2=
				// additiveOperation | GREATER op2= additiveOperation |
				// GREATER_EQUAL op2= additiveOperation ) )*
				loop10: do {
					int alt10= 2;
					int LA10_0= input.LA(1);

					if ( ( (LA10_0 >= LESS && LA10_0 <= GREATER_EQUAL))) {
						alt10= 1;
					}


					switch (alt10) {
						case 1:
							// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:297:3:
							// ( LESS op2= additiveOperation | LESS_EQUAL op2=
							// additiveOperation | GREATER op2=
							// additiveOperation | GREATER_EQUAL op2=
							// additiveOperation )
						{
							// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:297:3:
							// ( LESS op2= additiveOperation | LESS_EQUAL op2=
							// additiveOperation | GREATER op2=
							// additiveOperation | GREATER_EQUAL op2=
							// additiveOperation )
							int alt9= 4;
							switch (input.LA(1)) {
								case LESS: {
									alt9= 1;
								}
									break;
								case LESS_EQUAL: {
									alt9= 2;
								}
									break;
								case GREATER: {
									alt9= 3;
								}
									break;
								case GREATER_EQUAL: {
									alt9= 4;
								}
									break;
								default:
									NoViableAltException nvae= new NoViableAltException("", 9, 0, input);

									throw nvae;
							}

							switch (alt9) {
								case 1:
									// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:297:4:
									// LESS op2= additiveOperation
								{
									match(input, LESS, FOLLOW_LESS_in_relationalOperation508);
									pushFollow(FOLLOW_additiveOperation_in_relationalOperation514);
									op2= additiveOperation();

									state._fsp--;

									type= OperationType.LESS;

								}
									break;
								case 2:
									// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:298:3:
									// LESS_EQUAL op2= additiveOperation
								{
									match(input, LESS_EQUAL, FOLLOW_LESS_EQUAL_in_relationalOperation520);
									pushFollow(FOLLOW_additiveOperation_in_relationalOperation526);
									op2= additiveOperation();

									state._fsp--;

									type= OperationType.LESS_EQUAL;

								}
									break;
								case 3:
									// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:299:3:
									// GREATER op2= additiveOperation
								{
									match(input, GREATER, FOLLOW_GREATER_in_relationalOperation532);
									pushFollow(FOLLOW_additiveOperation_in_relationalOperation538);
									op2= additiveOperation();

									state._fsp--;

									type= OperationType.GREATER;

								}
									break;
								case 4:
									// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:300:3:
									// GREATER_EQUAL op2= additiveOperation
								{
									match(input, GREATER_EQUAL, FOLLOW_GREATER_EQUAL_in_relationalOperation544);
									pushFollow(FOLLOW_additiveOperation_in_relationalOperation550);
									op2= additiveOperation();

									state._fsp--;

									type= OperationType.GREATER_EQUAL;

								}
									break;

							}

							value= createBinaryOperation(lastOp, type, op2);
							lastOp= value;

						}
							break;

						default:
							break loop10;
					}
				} while (true);


			}

		} catch (RecognitionException re) {
			reportError(re);
			recover(input, re);
		} finally {
		}
		return value;
	}

	// $ANTLR end "relationalOperation"


	// $ANTLR start "additiveOperation"
	// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:303:1:
	// additiveOperation returns [RightHandSideExpression value] : (op2=
	// multiplicativeOperation ( ( PLUS op2= multiplicativeOperation | MINUS
	// op2= multiplicativeOperation ) )* ) ;
	public final RightHandSideExpression additiveOperation() throws RecognitionException, TransformationException {
		RightHandSideExpression value= null;

		RightHandSideExpression op2= null;


		try {
			// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:304:2:
			// ( (op2= multiplicativeOperation ( ( PLUS op2=
			// multiplicativeOperation | MINUS op2= multiplicativeOperation ) )*
			// ) )
			// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:304:3:
			// (op2= multiplicativeOperation ( ( PLUS op2=
			// multiplicativeOperation | MINUS op2= multiplicativeOperation ) )*
			// )
			{
				OperationType type= null;
				// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:305:2:
				// (op2= multiplicativeOperation ( ( PLUS op2=
				// multiplicativeOperation | MINUS op2= multiplicativeOperation
				// ) )* )
				// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:305:3:
				// op2= multiplicativeOperation ( ( PLUS op2=
				// multiplicativeOperation | MINUS op2= multiplicativeOperation
				// ) )*
				{
					pushFollow(FOLLOW_multiplicativeOperation_in_additiveOperation580);
					op2= multiplicativeOperation();

					state._fsp--;

					value= op2;
					RightHandSideExpression lastOp= value;
					// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:306:2:
					// ( ( PLUS op2= multiplicativeOperation | MINUS op2=
					// multiplicativeOperation ) )*
					loop12: do {
						int alt12= 2;
						int LA12_0= input.LA(1);

						if ( ( (LA12_0 >= PLUS && LA12_0 <= MINUS))) {
							alt12= 1;
						}


						switch (alt12) {
							case 1:
								// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:306:3:
								// ( PLUS op2= multiplicativeOperation | MINUS
								// op2= multiplicativeOperation )
							{
								// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:306:3:
								// ( PLUS op2= multiplicativeOperation | MINUS
								// op2= multiplicativeOperation )
								int alt11= 2;
								int LA11_0= input.LA(1);

								if ( (LA11_0 == PLUS)) {
									alt11= 1;
								} else if ( (LA11_0 == MINUS)) {
									alt11= 2;
								} else {
									NoViableAltException nvae= new NoViableAltException("", 11, 0, input);

									throw nvae;
								}
								switch (alt11) {
									case 1:
										// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:306:4:
										// PLUS op2= multiplicativeOperation
									{
										match(input, PLUS, FOLLOW_PLUS_in_additiveOperation587);
										pushFollow(FOLLOW_multiplicativeOperation_in_additiveOperation593);
										op2= multiplicativeOperation();

										state._fsp--;

										type= OperationType.ADDITION;

									}
										break;
									case 2:
										// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:307:3:
										// MINUS op2= multiplicativeOperation
									{
										match(input, MINUS, FOLLOW_MINUS_in_additiveOperation599);
										pushFollow(FOLLOW_multiplicativeOperation_in_additiveOperation605);
										op2= multiplicativeOperation();

										state._fsp--;

										type= OperationType.SUBTRACTION;

									}
										break;

								}

								value= createBinaryOperation(lastOp, type, op2);
								lastOp= value;

							}
								break;

							default:
								break loop12;
						}
					} while (true);


				}


			}

		} catch (RecognitionException re) {
			reportError(re);
			recover(input, re);
		} finally {
		}
		return value;
	}

	// $ANTLR end "additiveOperation"


	// $ANTLR start "multiplicativeOperation"
	// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:310:1:
	// multiplicativeOperation returns [RightHandSideExpression value] : op2=
	// unaryOperation ( ( MULT op2= unaryOperation | DIV op2= unaryOperation |
	// MOD op2= unaryOperation ) )* ;
	public final RightHandSideExpression multiplicativeOperation() throws RecognitionException, TransformationException {
		RightHandSideExpression value= null;

		RightHandSideExpression op2= null;


		try {
			// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:311:2:
			// (op2= unaryOperation ( ( MULT op2= unaryOperation | DIV op2=
			// unaryOperation | MOD op2= unaryOperation ) )* )
			// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:311:4:
			// op2= unaryOperation ( ( MULT op2= unaryOperation | DIV op2=
			// unaryOperation | MOD op2= unaryOperation ) )*
			{
				pushFollow(FOLLOW_unaryOperation_in_multiplicativeOperation632);
				op2= unaryOperation();

				state._fsp--;

				value= op2;
				RightHandSideExpression lastOp= value;
				OperationType type= null;
				// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:312:5:
				// ( ( MULT op2= unaryOperation | DIV op2= unaryOperation | MOD
				// op2= unaryOperation ) )*
				loop14: do {
					int alt14= 2;
					int LA14_0= input.LA(1);

					if ( ( (LA14_0 >= MULT && LA14_0 <= MOD))) {
						alt14= 1;
					}


					switch (alt14) {
						case 1:
							// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:312:6:
							// ( MULT op2= unaryOperation | DIV op2=
							// unaryOperation | MOD op2= unaryOperation )
						{
							// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:312:6:
							// ( MULT op2= unaryOperation | DIV op2=
							// unaryOperation | MOD op2= unaryOperation )
							int alt13= 3;
							switch (input.LA(1)) {
								case MULT: {
									alt13= 1;
								}
									break;
								case DIV: {
									alt13= 2;
								}
									break;
								case MOD: {
									alt13= 3;
								}
									break;
								default:
									NoViableAltException nvae= new NoViableAltException("", 13, 0, input);

									throw nvae;
							}

							switch (alt13) {
								case 1:
									// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:312:7:
									// MULT op2= unaryOperation
								{
									match(input, MULT, FOLLOW_MULT_in_multiplicativeOperation642);
									pushFollow(FOLLOW_unaryOperation_in_multiplicativeOperation648);
									op2= unaryOperation();

									state._fsp--;

									type= OperationType.MULTIPLICATION;

								}
									break;
								case 2:
									// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:313:6:
									// DIV op2= unaryOperation
								{
									match(input, DIV, FOLLOW_DIV_in_multiplicativeOperation656);
									pushFollow(FOLLOW_unaryOperation_in_multiplicativeOperation662);
									op2= unaryOperation();

									state._fsp--;

									type= OperationType.DIVISION;

								}
									break;
								case 3:
									// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:314:6:
									// MOD op2= unaryOperation
								{
									match(input, MOD, FOLLOW_MOD_in_multiplicativeOperation670);
									pushFollow(FOLLOW_unaryOperation_in_multiplicativeOperation676);
									op2= unaryOperation();

									state._fsp--;

									type= OperationType.MODULO;

								}
									break;

							}

							value= createBinaryOperation(lastOp, type, op2);
							lastOp= value;

						}
							break;

						default:
							break loop14;
					}
				} while (true);


			}

		} catch (RecognitionException re) {
			reportError(re);
			recover(input, re);
		} finally {
		}
		return value;
	}

	// $ANTLR end "multiplicativeOperation"


	// $ANTLR start "unaryOperation"
	// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:317:1:
	// unaryOperation returns [RightHandSideExpression value] : ( MINUS lq=
	// literalOrQualifier | NOT lq= literalOrQualifier | lq= literalOrQualifier
	// ) ;
	public final RightHandSideExpression unaryOperation() throws RecognitionException, TransformationException {
		RightHandSideExpression value= null;

		RightHandSideExpression lq= null;


		try {
			// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:318:2:
			// ( ( MINUS lq= literalOrQualifier | NOT lq= literalOrQualifier |
			// lq= literalOrQualifier ) )
			// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:318:4:
			// ( MINUS lq= literalOrQualifier | NOT lq= literalOrQualifier | lq=
			// literalOrQualifier )
			{
				// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:318:4:
				// ( MINUS lq= literalOrQualifier | NOT lq= literalOrQualifier |
				// lq= literalOrQualifier )
				int alt15= 3;
				switch (input.LA(1)) {
					case MINUS: {
						alt15= 1;
					}
						break;
					case NOT: {
						alt15= 2;
					}
						break;
					case SCOPE_REF:
					case STRING:
					case NULL:
					case TRUE:
					case FALSE:
					case ID:
					case ZERO_TO_NINE:
					case 41: {
						alt15= 3;
					}
						break;
					default:
						NoViableAltException nvae= new NoViableAltException("", 15, 0, input);

						throw nvae;
				}

				switch (alt15) {
					case 1:
						// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:318:5:
						// MINUS lq= literalOrQualifier
					{
						match(input, MINUS, FOLLOW_MINUS_in_unaryOperation705);
						pushFollow(FOLLOW_literalOrQualifier_in_unaryOperation709);
						lq= literalOrQualifier();

						state._fsp--;

						value= createUnaryOperation(lq, OperationType.NEGATION);

					}
						break;
					case 2:
						// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:319:4:
						// NOT lq= literalOrQualifier
					{
						match(input, NOT, FOLLOW_NOT_in_unaryOperation716);
						pushFollow(FOLLOW_literalOrQualifier_in_unaryOperation720);
						lq= literalOrQualifier();

						state._fsp--;

						value= createUnaryOperation(lq, OperationType.NOT);

					}
						break;
					case 3:
						// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:320:4:
						// lq= literalOrQualifier
					{
						pushFollow(FOLLOW_literalOrQualifier_in_unaryOperation729);
						lq= literalOrQualifier();

						state._fsp--;

						value= lq;

					}
						break;

				}


			}

		} catch (RecognitionException re) {
			reportError(re);
			recover(input, re);
		} finally {
		}
		return value;
	}

	// $ANTLR end "unaryOperation"


	// $ANTLR start "literalOrQualifier"
	// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:322:1:
	// literalOrQualifier returns [RightHandSideExpression value] : (q= literal
	// | rhs= parExpression | lhs= leftHandExp[this.currentScope] ) ;
	public final RightHandSideExpression literalOrQualifier() throws RecognitionException, TransformationException {
		RightHandSideExpression value= null;

		Literal q= null;

		RightHandSideExpression rhs= null;

		LeftHandSideExpression lhs= null;


		try {
			// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:323:2:
			// ( (q= literal | rhs= parExpression | lhs=
			// leftHandExp[this.currentScope] ) )
			// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:323:4:
			// (q= literal | rhs= parExpression | lhs=
			// leftHandExp[this.currentScope] )
			{
				// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:323:4:
				// (q= literal | rhs= parExpression | lhs=
				// leftHandExp[this.currentScope] )
				int alt16= 3;
				switch (input.LA(1)) {
					case STRING:
					case NULL:
					case TRUE:
					case FALSE:
					case ZERO_TO_NINE: {
						alt16= 1;
					}
						break;
					case 41: {
						alt16= 2;
					}
						break;
					case SCOPE_REF:
					case ID: {
						alt16= 3;
					}
						break;
					default:
						NoViableAltException nvae= new NoViableAltException("", 16, 0, input);

						throw nvae;
				}

				switch (alt16) {
					case 1:
						// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:323:5:
						// q= literal
					{
						pushFollow(FOLLOW_literal_in_literalOrQualifier748);
						q= literal();

						state._fsp--;

						value= q;

					}
						break;
					case 2:
						// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:324:4:
						// rhs= parExpression
					{
						pushFollow(FOLLOW_parExpression_in_literalOrQualifier758);
						rhs= parExpression();

						state._fsp--;

						value= rhs;

					}
						break;
					case 3:
						// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:325:4:
						// lhs= leftHandExp[this.currentScope]
					{
						pushFollow(FOLLOW_leftHandExp_in_literalOrQualifier767);
						lhs= leftHandExp(null);

						state._fsp--;

						value= lhs;

					}
						break;

				}


			}

		} catch (RecognitionException re) {
			reportError(re);
			recover(input, re);
		} finally {
		}
		return value;
	}

	// $ANTLR end "literalOrQualifier"


	// $ANTLR start "literal"
	// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:329:1:
	// literal returns [Literal value] : (p= numberLiteral | s= stringLiteral |
	// b= definedLiteral ) ;
	public final Literal literal() throws RecognitionException {
		Literal value= null;

		DataParser.numberLiteral_return p= null;

		Literal s= null;

		Literal b= null;


		try {
			// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:330:2:
			// ( (p= numberLiteral | s= stringLiteral | b= definedLiteral ) )
			// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:330:4:
			// (p= numberLiteral | s= stringLiteral | b= definedLiteral )
			{
				// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:330:4:
				// (p= numberLiteral | s= stringLiteral | b= definedLiteral )
				int alt17= 3;
				switch (input.LA(1)) {
					case ZERO_TO_NINE: {
						alt17= 1;
					}
						break;
					case STRING: {
						alt17= 2;
					}
						break;
					case NULL:
					case TRUE:
					case FALSE: {
						alt17= 3;
					}
						break;
					default:
						NoViableAltException nvae= new NoViableAltException("", 17, 0, input);

						throw nvae;
				}

				switch (alt17) {
					case 1:
						// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:330:5:
						// p= numberLiteral
					{
						pushFollow(FOLLOW_numberLiteral_in_literal790);
						p= numberLiteral();

						state._fsp--;

						value= (p != null ? p.value : null);

					}
						break;
					case 2:
						// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:331:4:
						// s= stringLiteral
					{
						pushFollow(FOLLOW_stringLiteral_in_literal798);
						s= stringLiteral();

						state._fsp--;

						value= s;

					}
						break;
					case 3:
						// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:332:4:
						// b= definedLiteral
					{
						pushFollow(FOLLOW_definedLiteral_in_literal806);
						b= definedLiteral();

						state._fsp--;

						value= b;

					}
						break;

				}


			}

		} catch (RecognitionException re) {
			reportError(re);
			recover(input, re);
		} finally {
		}
		return value;
	}

	// $ANTLR end "literal"

	public static class numberLiteral_return extends ParserRuleReturnScope {
		public Literal value;
	};

	// $ANTLR start "numberLiteral"
	// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:336:1:
	// numberLiteral returns [Literal value] : ( number )+ ( DOT ( number )* )?
	// ;
	public final DataParser.numberLiteral_return numberLiteral() throws RecognitionException {
		DataParser.numberLiteral_return retval= new DataParser.numberLiteral_return();
		retval.start= input.LT(1);

		try {
			// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:337:2:
			// ( ( number )+ ( DOT ( number )* )? )
			// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:337:4:
			// ( number )+ ( DOT ( number )* )?
			{
				// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:337:4:
				// ( number )+
				int cnt18= 0;
				loop18: do {
					int alt18= 2;
					int LA18_0= input.LA(1);

					if ( (LA18_0 == ZERO_TO_NINE)) {
						alt18= 1;
					}


					switch (alt18) {
						case 1:
							// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:337:5:
							// number
						{
							pushFollow(FOLLOW_number_in_numberLiteral827);
							number();

							state._fsp--;


						}
							break;

						default:
							if (cnt18 >= 1)
								break loop18;
							EarlyExitException eee= new EarlyExitException(18, input);
							throw eee;
					}
					cnt18++;
				} while (true);

				retval.value= ISMDataFactory.eINSTANCE.createLiteral();
				retval.value.setType(SMMUtil.addStandardType(SMMUtil.getParticipant(fCurrentServiceActivity), SMMUtil.SupportedPrimitiveTypes.Int));
				retval.value.setValue(Integer.parseInt(input.toString(retval.start, input.LT(-1))));
				// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:340:2:
				// ( DOT ( number )* )?
				int alt20= 2;
				int LA20_0= input.LA(1);

				if ( (LA20_0 == DOT)) {
					alt20= 1;
				}
				switch (alt20) {
					case 1:
						// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:340:3:
						// DOT ( number )*
					{
						match(input, DOT, FOLLOW_DOT_in_numberLiteral835);
						// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:340:7:
						// ( number )*
						loop19: do {
							int alt19= 2;
							int LA19_0= input.LA(1);

							if ( (LA19_0 == ZERO_TO_NINE)) {
								alt19= 1;
							}


							switch (alt19) {
								case 1:
									// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:340:8:
									// number
								{
									pushFollow(FOLLOW_number_in_numberLiteral838);
									number();

									state._fsp--;


								}
									break;

								default:
									break loop19;
							}
						} while (true);

						retval.value.setValue(Double.parseDouble(input.toString(retval.start, input.LT(-1))));
						retval.value.setType(SMMUtil.addStandardType(SMMUtil.getParticipant(fCurrentServiceActivity),
								SMMUtil.SupportedPrimitiveTypes.Double));

					}
						break;

				}


			}

			retval.stop= input.LT(-1);

		} catch (RecognitionException re) {
			reportError(re);
			recover(input, re);
		} finally {
		}
		return retval;
	}

	// $ANTLR end "numberLiteral"


	// $ANTLR start "stringLiteral"
	// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:344:1:
	// stringLiteral returns [Literal value] : e= STRING ;
	public final Literal stringLiteral() throws RecognitionException {
		Literal value= null;

		Token e= null;

		try {
			// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:345:2:
			// (e= STRING )
			// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:345:4:
			// e= STRING
			{
				e= (Token) match(input, STRING, FOLLOW_STRING_in_stringLiteral865);
				value= ISMDataFactory.eINSTANCE.createLiteral();
				value.setType(SMMUtil.addStandardType(SMMUtil.getParticipant(fCurrentServiceActivity), SMMUtil.SupportedPrimitiveTypes.String));
				value.setValue( (e != null ? e.getText() : null));

			}

		} catch (RecognitionException re) {
			reportError(re);
			recover(input, re);
		} finally {
		}
		return value;
	}

	// $ANTLR end "stringLiteral"


	// $ANTLR start "definedLiteral"
	// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:349:1:
	// definedLiteral returns [Literal value] : ( NULL | TRUE | FALSE ) ;
	public final Literal definedLiteral() throws RecognitionException {
		Literal value= null;

		try {
			// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:350:2:
			// ( ( NULL | TRUE | FALSE ) )
			// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:350:3:
			// ( NULL | TRUE | FALSE )
			{
				value= ISMDataFactory.eINSTANCE.createLiteral();
				// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:351:2:
				// ( NULL | TRUE | FALSE )
				int alt21= 3;
				switch (input.LA(1)) {
					case NULL: {
						alt21= 1;
					}
						break;
					case TRUE: {
						alt21= 2;
					}
						break;
					case FALSE: {
						alt21= 3;
					}
						break;
					default:
						NoViableAltException nvae= new NoViableAltException("", 21, 0, input);

						throw nvae;
				}

				switch (alt21) {
					case 1:
						// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:351:4:
						// NULL
					{
						match(input, NULL, FOLLOW_NULL_in_definedLiteral887);
						value.setType(SMMUtil.addNullType(SMMUtil.getParticipant(fCurrentServiceActivity)));

					}
						break;
					case 2:
						// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:352:4:
						// TRUE
					{
						match(input, TRUE, FOLLOW_TRUE_in_definedLiteral894);
						value.setValue(true);
						value.setType(SMMUtil.addStandardType(SMMUtil.getParticipant(fCurrentServiceActivity),
								SMMUtil.SupportedPrimitiveTypes.Boolean));

					}
						break;
					case 3:
						// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:353:4:
						// FALSE
					{
						match(input, FALSE, FOLLOW_FALSE_in_definedLiteral901);
						value.setValue(false);
						value.setType(SMMUtil.addStandardType(SMMUtil.getParticipant(fCurrentServiceActivity),
								SMMUtil.SupportedPrimitiveTypes.Boolean));

					}
						break;

				}


			}

		} catch (RecognitionException re) {
			reportError(re);
			recover(input, re);
		} finally {
		}
		return value;
	}

	// $ANTLR end "definedLiteral"

	public static class string_return extends ParserRuleReturnScope {
		public String value;
	};

	// $ANTLR start "string"
	// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:388:1:
	// string returns [String value] : ( '\"' (~ '\"' )* '\"' | '\\'' ( . )*
	// '\\'' ) ;
	public final DataParser.string_return string() throws RecognitionException {
		DataParser.string_return retval= new DataParser.string_return();
		retval.start= input.LT(1);

		try {
			// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:389:2:
			// ( ( '\"' (~ '\"' )* '\"' | '\\'' ( . )* '\\'' ) )
			// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:389:3:
			// ( '\"' (~ '\"' )* '\"' | '\\'' ( . )* '\\'' )
			{
				// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:389:3:
				// ( '\"' (~ '\"' )* '\"' | '\\'' ( . )* '\\'' )
				int alt24= 2;
				int LA24_0= input.LA(1);

				if ( (LA24_0 == 43)) {
					alt24= 1;
				} else if ( (LA24_0 == SINGLE_QUOTE)) {
					alt24= 2;
				} else {
					NoViableAltException nvae= new NoViableAltException("", 24, 0, input);

					throw nvae;
				}
				switch (alt24) {
					case 1:
						// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:389:5:
						// '\"' (~ '\"' )* '\"'
					{
						match(input, 43, FOLLOW_43_in_string1417);
						// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:389:9:
						// (~ '\"' )*
						loop22: do {
							int alt22= 2;
							int LA22_0= input.LA(1);

							if ( ( (LA22_0 >= ASSIGN && LA22_0 <= 42))) {
								alt22= 1;
							}


							switch (alt22) {
								case 1:
									// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:389:10:
									// ~ '\"'
								{
									if ( (input.LA(1) >= ASSIGN && input.LA(1) <= 42)) {
										input.consume();
										state.errorRecovery= false;
									} else {
										MismatchedSetException mse= new MismatchedSetException(null, input);
										throw mse;
									}


								}
									break;

								default:
									break loop22;
							}
						} while (true);

						match(input, 43, FOLLOW_43_in_string1425);

					}
						break;
					case 2:
						// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:390:4:
						// '\\'' ( . )* '\\''
					{
						match(input, SINGLE_QUOTE, FOLLOW_SINGLE_QUOTE_in_string1430);
						// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:390:9:
						// ( . )*
						loop23: do {
							int alt23= 2;
							int LA23_0= input.LA(1);

							if ( (LA23_0 == SINGLE_QUOTE)) {
								alt23= 2;
							} else if ( ( (LA23_0 >= ASSIGN && LA23_0 <= SIGN) || (LA23_0 >= UMLAUTS && LA23_0 <= 43))) {
								alt23= 1;
							}


							switch (alt23) {
								case 1:
									// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:390:9:
									// .
								{
									matchAny(input);

								}
									break;

								default:
									break loop23;
							}
						} while (true);

						match(input, SINGLE_QUOTE, FOLLOW_SINGLE_QUOTE_in_string1435);

					}
						break;

				}

				retval.value= input.toString(retval.start, input.LT(-1));

			}

			retval.stop= input.LT(-1);

		} catch (RecognitionException re) {
			reportError(re);
			recover(input, re);
		} finally {
		}
		return retval;
	}

	// $ANTLR end "string"


	// $ANTLR start "operator"
	// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:410:1:
	// operator returns [OperationType value] : ( PLUS | MINUS | MULT | DIV );
	public final OperationType operator() throws RecognitionException {
		OperationType value= null;

		try {
			// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:412:40:
			// ( PLUS | MINUS | MULT | DIV )
			int alt25= 4;
			switch (input.LA(1)) {
				case PLUS: {
					alt25= 1;
				}
					break;
				case MINUS: {
					alt25= 2;
				}
					break;
				case MULT: {
					alt25= 3;
				}
					break;
				case DIV: {
					alt25= 4;
				}
					break;
				default:
					NoViableAltException nvae= new NoViableAltException("", 25, 0, input);

					throw nvae;
			}

			switch (alt25) {
				case 1:
					// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:412:42:
					// PLUS
				{
					match(input, PLUS, FOLLOW_PLUS_in_operator1485);
					value= OperationType.ADDITION;

				}
					break;
				case 2:
					// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:413:13:
					// MINUS
				{
					match(input, MINUS, FOLLOW_MINUS_in_operator1502);
					value= OperationType.SUBTRACTION;

				}
					break;
				case 3:
					// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:414:13:
					// MULT
				{
					match(input, MULT, FOLLOW_MULT_in_operator1518);
					value= OperationType.MULTIPLICATION;

				}
					break;
				case 4:
					// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:415:13:
					// DIV
				{
					match(input, DIV, FOLLOW_DIV_in_operator1534);
					value= OperationType.DIVISION;

				}
					break;

			}
		} catch (RecognitionException re) {
			reportError(re);
			recover(input, re);
		} finally {
		}
		return value;
	}

	// $ANTLR end "operator"

	public static class typeName_return extends ParserRuleReturnScope {
		public SMMType value;
	};

	// $ANTLR start "typeName"
	// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:418:1:
	// typeName returns [Type value] : ID ( ARRAY | SET )? ;
	public final DataParser.typeName_return typeName() throws RecognitionException, TransformationException {
		DataParser.typeName_return retval= new DataParser.typeName_return();
		retval.start= input.LT(1);

		try {
			// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:419:2:
			// ( ID ( ARRAY | SET )? )
			// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:419:4:
			// ID ( ARRAY | SET )?
			{
				match(input, ID, FOLLOW_ID_in_typeName1551);
				// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:419:7:
				// ( ARRAY | SET )?
				int alt26= 2;
				int LA26_0= input.LA(1);

				if ( ( (LA26_0 >= ARRAY && LA26_0 <= SET))) {
					alt26= 1;
				}
				switch (alt26) {
					case 1:
						// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:
					{
						if ( (input.LA(1) >= ARRAY && input.LA(1) <= SET)) {
							input.consume();
							state.errorRecovery= false;
						} else {
							MismatchedSetException mse= new MismatchedSetException(null, input);
							throw mse;
						}


					}
						break;

				}

				retval.value= resolveType(input.toString(retval.start, input.LT(-1)));

			}

			retval.stop= input.LT(-1);

		} catch (RecognitionException re) {
			reportError(re);
			recover(input, re);
		} finally {
		}
		return retval;
	}

	// $ANTLR end "typeName"

	public static class name_return extends ParserRuleReturnScope {
		public String value;
	};

	// $ANTLR start "name"
	// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:422:1:
	// name returns [String value] : ID ;
	public final DataParser.name_return name() throws RecognitionException {
		DataParser.name_return retval= new DataParser.name_return();
		retval.start= input.LT(1);

		try {
			// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:423:2:
			// ( ID )
			// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:423:5:
			// ID
			{
				match(input, ID, FOLLOW_ID_in_name1576);
				retval.value= input.toString(retval.start, input.LT(-1));

			}

			retval.stop= input.LT(-1);

		} catch (RecognitionException re) {
			reportError(re);
			recover(input, re);
		} finally {
		}
		return retval;
	}

	// $ANTLR end "name"


	// $ANTLR start "number"
	// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:433:1:
	// fragment number : ZERO_TO_NINE ;
	public final void number() throws RecognitionException {
		try {
			// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:434:9:
			// ( ZERO_TO_NINE )
			// /home/andi/Diplomarbeit/workspace_plugin/de.lmu.ifi.pst.mdd4soa.transform.impl.uml2ism/src/de/lmu/ifi/pst/mdd4soa/transform/impl/uml2ism/parser/Data.g:434:11:
			// ZERO_TO_NINE
			{
				match(input, ZERO_TO_NINE, FOLLOW_ZERO_TO_NINE_in_number1592);

			}

		} catch (RecognitionException re) {
			reportError(re);
			recover(input, re);
		} finally {
		}
		return;
	}

	// $ANTLR end "number"

	// Delegated rules



	public static final BitSet FOLLOW_assignment_in_data51= new BitSet(new long[] { 0x0000000080000042L });

	public static final BitSet FOLLOW_declaration_in_data65= new BitSet(new long[] { 0x0000000080000042L });

	public static final BitSet FOLLOW_leftHandExp_in_assignment90= new BitSet(new long[] { 0x0000000000000010L });

	public static final BitSet FOLLOW_ASSIGN_in_assignment99= new BitSet(new long[] { 0x000002049F100040L });

	public static final BitSet FOLLOW_rightHandExp_in_assignment109= new BitSet(new long[] { 0x0000000000000020L });

	public static final BitSet FOLLOW_SEMICOLON_in_assignment114= new BitSet(new long[] { 0x0000000000000002L });

	public static final BitSet FOLLOW_typeName_in_declaration131= new BitSet(new long[] { 0x0000000080000040L });

	public static final BitSet FOLLOW_variable_in_declaration141= new BitSet(new long[] { 0x0000000000000020L });

	public static final BitSet FOLLOW_SEMICOLON_in_declaration149= new BitSet(new long[] { 0x0000000000000002L });

	public static final BitSet FOLLOW_SCOPE_REF_in_scopeName164= new BitSet(new long[] { 0x0000000080000040L });

	public static final BitSet FOLLOW_name_in_scopeName170= new BitSet(new long[] { 0x0000000000000002L });

	public static final BitSet FOLLOW_name_in_variable189= new BitSet(new long[] { 0x0000000000000002L });

	public static final BitSet FOLLOW_DOT_in_field215= new BitSet(new long[] { 0x0000000080000040L });

	public static final BitSet FOLLOW_name_in_field219= new BitSet(new long[] { 0x0000000000000082L });

	public static final BitSet FOLLOW_41_in_parExpression243= new BitSet(new long[] { 0x000002049F100040L });

	public static final BitSet FOLLOW_rightHandExp_in_parExpression247= new BitSet(new long[] { 0x0000040000000000L });

	public static final BitSet FOLLOW_42_in_parExpression250= new BitSet(new long[] { 0x0000000000000002L });

	public static final BitSet FOLLOW_scopeName_in_leftHandExp279= new BitSet(new long[] { 0x0000000000000080L });

	public static final BitSet FOLLOW_DOT_in_leftHandExp281= new BitSet(new long[] { 0x0000000080000040L });

	public static final BitSet FOLLOW_variable_in_leftHandExp287= new BitSet(new long[] { 0x0000000000000082L });

	public static final BitSet FOLLOW_variable_in_leftHandExp300= new BitSet(new long[] { 0x0000000000000082L });

	public static final BitSet FOLLOW_field_in_leftHandExp311= new BitSet(new long[] { 0x0000000000000002L });

	public static final BitSet FOLLOW_conditionalOrOperation_in_rightHandExp341= new BitSet(new long[] { 0x0000000000000002L });

	public static final BitSet FOLLOW_conditionalAndOperation_in_conditionalOrOperation364= new BitSet(new long[] { 0x0000000000000302L });

	public static final BitSet FOLLOW_set_in_conditionalOrOperation373= new BitSet(new long[] { 0x000002049F100040L });

	public static final BitSet FOLLOW_conditionalAndOperation_in_conditionalOrOperation383= new BitSet(new long[] { 0x0000000000000302L });

	public static final BitSet FOLLOW_equalityOperation_in_conditionalAndOperation404= new BitSet(new long[] { 0x0000000000000C02L });

	public static final BitSet FOLLOW_set_in_conditionalAndOperation410= new BitSet(new long[] { 0x000002049F100040L });

	public static final BitSet FOLLOW_equalityOperation_in_conditionalAndOperation422= new BitSet(new long[] { 0x0000000000000C02L });

	public static final BitSet FOLLOW_relationalOperation_in_equalityOperation444= new BitSet(new long[] { 0x0000000000007002L });

	public static final BitSet FOLLOW_set_in_equalityOperation451= new BitSet(new long[] { 0x000002049F100040L });

	public static final BitSet FOLLOW_relationalOperation_in_equalityOperation463= new BitSet(new long[] { 0x0000000000007002L });

	public static final BitSet FOLLOW_NOT_EQUALS_in_equalityOperation470= new BitSet(new long[] { 0x000002049F100040L });

	public static final BitSet FOLLOW_relationalOperation_in_equalityOperation476= new BitSet(new long[] { 0x0000000000007002L });

	public static final BitSet FOLLOW_additiveOperation_in_relationalOperation501= new BitSet(new long[] { 0x0000000000078002L });

	public static final BitSet FOLLOW_LESS_in_relationalOperation508= new BitSet(new long[] { 0x000002049F100040L });

	public static final BitSet FOLLOW_additiveOperation_in_relationalOperation514= new BitSet(new long[] { 0x0000000000078002L });

	public static final BitSet FOLLOW_LESS_EQUAL_in_relationalOperation520= new BitSet(new long[] { 0x000002049F100040L });

	public static final BitSet FOLLOW_additiveOperation_in_relationalOperation526= new BitSet(new long[] { 0x0000000000078002L });

	public static final BitSet FOLLOW_GREATER_in_relationalOperation532= new BitSet(new long[] { 0x000002049F100040L });

	public static final BitSet FOLLOW_additiveOperation_in_relationalOperation538= new BitSet(new long[] { 0x0000000000078002L });

	public static final BitSet FOLLOW_GREATER_EQUAL_in_relationalOperation544= new BitSet(new long[] { 0x000002049F100040L });

	public static final BitSet FOLLOW_additiveOperation_in_relationalOperation550= new BitSet(new long[] { 0x0000000000078002L });

	public static final BitSet FOLLOW_multiplicativeOperation_in_additiveOperation580= new BitSet(new long[] { 0x0000000000180002L });

	public static final BitSet FOLLOW_PLUS_in_additiveOperation587= new BitSet(new long[] { 0x000002049F100040L });

	public static final BitSet FOLLOW_multiplicativeOperation_in_additiveOperation593= new BitSet(new long[] { 0x0000000000180002L });

	public static final BitSet FOLLOW_MINUS_in_additiveOperation599= new BitSet(new long[] { 0x000002049F100040L });

	public static final BitSet FOLLOW_multiplicativeOperation_in_additiveOperation605= new BitSet(new long[] { 0x0000000000180002L });

	public static final BitSet FOLLOW_unaryOperation_in_multiplicativeOperation632= new BitSet(new long[] { 0x0000000000E00002L });

	public static final BitSet FOLLOW_MULT_in_multiplicativeOperation642= new BitSet(new long[] { 0x000002049F100040L });

	public static final BitSet FOLLOW_unaryOperation_in_multiplicativeOperation648= new BitSet(new long[] { 0x0000000000E00002L });

	public static final BitSet FOLLOW_DIV_in_multiplicativeOperation656= new BitSet(new long[] { 0x000002049F100040L });

	public static final BitSet FOLLOW_unaryOperation_in_multiplicativeOperation662= new BitSet(new long[] { 0x0000000000E00002L });

	public static final BitSet FOLLOW_MOD_in_multiplicativeOperation670= new BitSet(new long[] { 0x000002049F100040L });

	public static final BitSet FOLLOW_unaryOperation_in_multiplicativeOperation676= new BitSet(new long[] { 0x0000000000E00002L });

	public static final BitSet FOLLOW_MINUS_in_unaryOperation705= new BitSet(new long[] { 0x000002049F100040L });

	public static final BitSet FOLLOW_literalOrQualifier_in_unaryOperation709= new BitSet(new long[] { 0x0000000000000002L });

	public static final BitSet FOLLOW_NOT_in_unaryOperation716= new BitSet(new long[] { 0x000002049F100040L });

	public static final BitSet FOLLOW_literalOrQualifier_in_unaryOperation720= new BitSet(new long[] { 0x0000000000000002L });

	public static final BitSet FOLLOW_literalOrQualifier_in_unaryOperation729= new BitSet(new long[] { 0x0000000000000002L });

	public static final BitSet FOLLOW_literal_in_literalOrQualifier748= new BitSet(new long[] { 0x0000000000000002L });

	public static final BitSet FOLLOW_parExpression_in_literalOrQualifier758= new BitSet(new long[] { 0x0000000000000002L });

	public static final BitSet FOLLOW_leftHandExp_in_literalOrQualifier767= new BitSet(new long[] { 0x0000000000000002L });

	public static final BitSet FOLLOW_numberLiteral_in_literal790= new BitSet(new long[] { 0x0000000000000002L });

	public static final BitSet FOLLOW_stringLiteral_in_literal798= new BitSet(new long[] { 0x0000000000000002L });

	public static final BitSet FOLLOW_definedLiteral_in_literal806= new BitSet(new long[] { 0x0000000000000002L });

	public static final BitSet FOLLOW_number_in_numberLiteral827= new BitSet(new long[] { 0x0000000400000082L });

	public static final BitSet FOLLOW_DOT_in_numberLiteral835= new BitSet(new long[] { 0x0000000400000002L });

	public static final BitSet FOLLOW_number_in_numberLiteral838= new BitSet(new long[] { 0x0000000400000002L });

	public static final BitSet FOLLOW_STRING_in_stringLiteral865= new BitSet(new long[] { 0x0000000000000002L });

	public static final BitSet FOLLOW_NULL_in_definedLiteral887= new BitSet(new long[] { 0x0000000000000002L });

	public static final BitSet FOLLOW_TRUE_in_definedLiteral894= new BitSet(new long[] { 0x0000000000000002L });

	public static final BitSet FOLLOW_FALSE_in_definedLiteral901= new BitSet(new long[] { 0x0000000000000002L });

	public static final BitSet FOLLOW_43_in_string1417= new BitSet(new long[] { 0x00000FFFFFFFFFF0L });

	public static final BitSet FOLLOW_set_in_string1420= new BitSet(new long[] { 0x00000FFFFFFFFFF0L });

	public static final BitSet FOLLOW_43_in_string1425= new BitSet(new long[] { 0x0000000000000002L });

	public static final BitSet FOLLOW_SINGLE_QUOTE_in_string1430= new BitSet(new long[] { 0x00000FFFFFFFFFF0L });

	public static final BitSet FOLLOW_SINGLE_QUOTE_in_string1435= new BitSet(new long[] { 0x0000000000000002L });

	public static final BitSet FOLLOW_PLUS_in_operator1485= new BitSet(new long[] { 0x0000000000000002L });

	public static final BitSet FOLLOW_MINUS_in_operator1502= new BitSet(new long[] { 0x0000000000000002L });

	public static final BitSet FOLLOW_MULT_in_operator1518= new BitSet(new long[] { 0x0000000000000002L });

	public static final BitSet FOLLOW_DIV_in_operator1534= new BitSet(new long[] { 0x0000000000000002L });

	public static final BitSet FOLLOW_ID_in_typeName1551= new BitSet(new long[] { 0x0000000300000002L });

	public static final BitSet FOLLOW_set_in_typeName1553= new BitSet(new long[] { 0x0000000000000002L });

	public static final BitSet FOLLOW_ID_in_name1576= new BitSet(new long[] { 0x0000000000000002L });

	public static final BitSet FOLLOW_ZERO_TO_NINE_in_number1592= new BitSet(new long[] { 0x0000000000000002L });



}
