/*
 * This file has been developed at the University of Munich, Chair for Programming & Software Engineering.
 * 
 * This file is licensed under the Eclipse Public License (EPL) 1.0
 * 
 */
package eu.mdd4soa.trans.uml2smm.ui.wizard;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.views.navigator.ResourceComparator;


/**
 * A dialog load dialog which displays the complete workspace in a tree view and
 * allows the user to select a directory.
 * 
 * @author Philip Mayer
 * 
 */
public class DirectoryLoadDialog extends ElementTreeSelectionDialog {

	public DirectoryLoadDialog(Shell parent, String title, String message, Object selection, ISelectionStatusValidator validator) {
		super(parent, new WorkbenchLabelProvider(), new WorkbenchContentProvider());

		setTitle(title);
		setMessage(message);
		setInput(ResourcesPlugin.getWorkspace().getRoot());
		setComparator(new ResourceComparator(ResourceComparator.NAME));
		setInitialSelection(selection);
		setAllowMultiple(false);
		setValidator(validator);
	}

	@Override
	public IContainer getFirstResult() {
		Object o= super.getFirstResult();

		if (o instanceof IContainer)
			return ((IContainer) o);

		return null;
	}

}
