/*
 * This file has been developed at the University of Munich, Chair for Programming & Software Engineering.
 * 
 * This file is licensed under the Eclipse Public License (EPL) 1.0
 * 
 */
package eu.mdd4soa.trans.uml2smm.ui.wizard;

import java.util.List;
import java.util.Map;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.uml2.uml.Activity;
import org.eclipse.uml2.uml.Class;

import eu.mdd4soa.trans.uml2smm.UML2SMM2Plugin;

/**
 * Wizard with one input page for displaying transformation option to the user.
 * 
 * @author Philip Mayer
 * 
 */
public class TransformerWizard extends Wizard implements IWizard {

	private TransformWizardPage fPage;

	private Map<org.eclipse.uml2.uml.Class, List<Activity>> fAvailableActivities;

	private IContainer fOutputDirectory;

	private Map<Class, List<Activity>> fSelectedActivities;

	private ISelectionStatusValidator fValidator;

	private String fTitle;

	private boolean fOpen;

	public void init(Map<org.eclipse.uml2.uml.Class, List<Activity>> availableActivities, IContainer outputDirectory) {
		setWindowTitle("Select Participants and Activities");
		fTitle= "Select Participants and Activities";
		setAvailableActivities(availableActivities);
		setOutputDirectory(outputDirectory);
		fValidator= createContainerAcceptor();
	}

	@Override
	public void addPages() {

		super.addPages();
		fPage= new TransformWizardPage("selectPage");
		fPage.setTitle(fTitle);
		fPage.setDescription("Select options for the transformation");
		addPage(fPage);

		fPage.setActivityList(fAvailableActivities);
		fPage.setOutputDirectory(fOutputDirectory);

		fPage.setSelectionStatusValidator(fValidator);
	}

	@Override
	public boolean performFinish() {
		fSelectedActivities= fPage.getSelectedActivities();
		fOutputDirectory= fPage.getOutputDirectory();
		fOpen= fPage.isOpen();
		return true;
	}

	@Override
	public boolean canFinish() {
		return fPage.getSelectedActivities().size() > 0;
	}


	public void setAvailableActivities(Map<org.eclipse.uml2.uml.Class, List<Activity>> availableActivities) {
		fAvailableActivities= availableActivities;
	}

	public void setOutputDirectory(IContainer outputDirectory) {
		fOutputDirectory= outputDirectory;
	}

	public IContainer getOutputDirectory() {
		return fOutputDirectory;
	}

	public Map<Class, List<Activity>> getSelectedActivities() {
		return fSelectedActivities;
	}

	public boolean getOpen() {
		return fOpen;
	}

	protected ISelectionStatusValidator createContainerAcceptor() {
		ISelectionStatusValidator validator= new ISelectionStatusValidator() {
			public IStatus validate(Object[] selection) {

				if (selection.length == 1 && selection[0] instanceof IContainer)
					return new Status(IStatus.OK, UML2SMM2Plugin.PLUGIN_ID, 0, "", null);

				return new Status(IStatus.ERROR, UML2SMM2Plugin.PLUGIN_ID, 0, "Select a directory", null);
			}
		};
		return validator;
	}

}
