/*
 * This file has been developed at the University of Munich, Chair for Programming & Software Engineering.
 * 
 * This file is licensed under the Eclipse Public License (EPL) 1.0
 * 
 */
package eu.uml4soa.utbm.sde;

import java.util.List;

import org.eclipse.core.resources.IFile;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;

import eu.sensoria_ist.casetool.core.ext.SensoriaTool;
import eu.sensoria_ist.casetool.core.ext.SensoriaToolFunction;
import eu.sensoria_ist.casetool.core.ext.SensoriaToolFunctionParameter;
import eu.sensoria_ist.casetool.core.ext.SensoriaToolFunctionReturns;
import eu.uml4soa.utbm.ui.eclipse.actions.SemanticsAction;

/**
 * This class contains the facade to the UTBM converter for the SDE.
 * 
 * @author Philip Mayer
 * 
 */
@SensoriaTool(name= "UML to-and-back MIOs", categories= "Transformation", description= "Converts UML4SOA models into a MIO representation.")
public class UTBMSDEIntegration {

	protected List<IFile> fOutput;

	@SensoriaToolFunction(description= "Converts participant behaviour and protocols from a UML model to MIOs")
	@SensoriaToolFunctionReturns(description= "A list of files with the converted MIOs")
	public List<IFile> convertToMIO(@SensoriaToolFunctionParameter(description= "File with the input UML model") final IFile model) {

		Display.getDefault().syncExec(new Runnable() {

			@Override
			public void run() {

				SemanticsAction ac= new SemanticsAction();
				ac.setActivePart(null, PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActivePart());
				IStructuredSelection sel= new StructuredSelection(model);
				ac.selectionChanged(null, sel);
				ac.run(null);
				fOutput= ac.getOutput();
			}

		});

		return fOutput;
	}


}
