/*
 * This file has been developed at the University of Munich, Chair for Programming & Software Engineering.
 * 
 * This file is licensed under the Eclipse Public License (EPL) 1.0
 * 
 */
package eu.uml4soa.utbm.u2m.test;

import org.junit.Test;

import eu.mdd4soa.smm.behaviour.Decision;
import eu.mdd4soa.smm.behaviour.ISMBehaviourFactory;
import eu.mdd4soa.smm.behaviour.Path;
import eu.mdd4soa.smm.behaviour.ServiceActivity;
import eu.uml4soa.utbm.u2m.model.CAutomaton;
import eu.uml4soa.utbm.u2m.semantics.OrchestrationSemanticsFunction;

/**
 * This class tests the exception handling in combination with structure, i.e.
 * exceptions in decisions, loops, etc.
 * 
 * @author Philip Mayer, mayer@pst.ifi.lmu.de
 * 
 */
public class TestExceptionStructure extends AbstractSemanticTests {

	/**
	 * Tests a throw in a decision. Should lead to two end states, one err, one
	 * non-err.
	 * 
	 * @throws Exception
	 */
	@Test
	public void testExceptionStructureDecisionThrow() throws Exception {

		ServiceActivity sa= createActivity("Test Decision");
		sa.getChildren().add(createDecision(createSend("sendLeft"), createThrow("myException")));

		CAutomaton c= OrchestrationSemanticsFunction.transform(sa);
		// store("resources/testExceptionStructureDecisionThrow", c);
		compareMios(c, "testExceptionStructureDecisionThrow");
	}

	/**
	 * The same should work with more actions involved.
	 * 
	 * @throws Exception
	 */
	@Test
	public void testExceptionStructureDecisionThrowMoreActions() throws Exception {

		ServiceActivity sa= createActivity("Test Decision");

		Decision d= ISMBehaviourFactory.eINSTANCE.createDecision();
		d.setName("Decision");
		Path p1= ISMBehaviourFactory.eINSTANCE.createPath();
		p1.getChildren().add(createSend("sendLeft1"));
		p1.getChildren().add(createReceive("receiveLeft1"));
		d.getChildren().add(p1);

		Path p2= ISMBehaviourFactory.eINSTANCE.createPath();
		p2.getChildren().add(createSend("sendRight1"));
		p2.getChildren().add(createThrow("myException"));
		p2.getChildren().add(createSend("sendRight2"));
		d.getChildren().add(p2);

		sa.getChildren().add(d);

		CAutomaton c= OrchestrationSemanticsFunction.transform(sa);
		// store("resources/testExceptionStructureDecisionThrowMoreActions", c);
		compareMios(c, "testExceptionStructureDecisionThrowMoreActions");
	}

	@Test
	public void testExceptionStructureLoopThrow() throws Exception {

		ServiceActivity sa= createActivity("Test Decision");
		sa.getChildren().add(createLoop(createSend("sendLeft"), createThrow("myException")));

		CAutomaton c= OrchestrationSemanticsFunction.transform(sa);
		// store("resources/testExceptionStructureLoopThrow", c);
		compareMios(c, "testExceptionStructureLoopThrow");
	}

}
