/*
 * This file has been developed at the University of Munich, Chair for Programming & Software Engineering.
 * 
 * This file is licensed under the Eclipse Public License (EPL) 1.0
 * 
 */
package eu.uml4soa.utbm.u2m;

import net.miowb.model.mio.InputAction;
import net.miowb.model.mio.InternalAction;
import net.miowb.model.mio.MayTransition;
import net.miowb.model.mio.MioFactory;
import net.miowb.model.mio.ModalIOAutomaton;
import net.miowb.model.mio.MustTransition;
import net.miowb.model.mio.OutputAction;
import net.miowb.model.mio.State;

import org.eclipse.emf.common.util.EList;


public class MioEMFFactory {

	public static final String LOOP_LABEL= "LOOP";

	private static final MioFactory FACTORY= MioFactory.eINSTANCE;

	public static State createState(ModalIOAutomaton t, String name) {
		State state= FACTORY.createState();
		state.setLabel(name);
		t.getStates().add(state);
		return state;
	}

	public static InternalAction getLoop(ModalIOAutomaton t) {
		EList<InternalAction> internals= t.getInternals();
		for (InternalAction internalAction : internals) {
			if (internalAction.getLabel().equals(LOOP_LABEL))
				return internalAction;
		}
		InternalAction action= MioEMFFactory.createInternal(LOOP_LABEL);
		t.getInternals().add(action);
		return action;
	}

	public static ModalIOAutomaton createAutomaton(String string) {
		ModalIOAutomaton mio= FACTORY.createModalIOAutomaton();
		mio.setName(string);
		return mio;
	}

	public static void createTauTransition(ModalIOAutomaton automaton, State from, State to) {

		MustTransition t= FACTORY.createMustTransition();
		InternalAction tau= createInternal("TAU");
		t.setAction(tau);
		t.setFrom(from);
		t.setTo(to);
		automaton.getInternals().add(tau);
		automaton.getMustTransitions().add(t);
	}

	public static void createLoopBackTransition(ModalIOAutomaton automaton, State from, State to) {

		MustTransition t= FACTORY.createMustTransition();
		t.setAction(getLoop(automaton));
		t.setFrom(from);
		t.setTo(to);
		automaton.getMustTransitions().add(t);
	}

	public static void createInternalMustTransition(ModalIOAutomaton automaton, String label, State from, State to) {

		InternalAction internalAction= FACTORY.createInternalAction();
		internalAction.setLabel(label);
		automaton.getInternals().add(internalAction);

		MustTransition t= FACTORY.createMustTransition();
		t.setAction(internalAction);
		t.setFrom(from);
		t.setTo(to);
		automaton.getMustTransitions().add(t);
	}

	public static MustTransition createMustTransition() {
		return FACTORY.createMustTransition();
	}

	public static OutputAction createOutput(String name) {
		OutputAction action= FACTORY.createOutputAction();
		action.setLabel(name);
		return action;
	}

	public static InputAction createInput(String name) {
		InputAction action= FACTORY.createInputAction();
		action.setLabel(name);
		return action;
	}

	public static InternalAction createInternal(String string) {
		InternalAction action= FACTORY.createInternalAction();
		action.setLabel(string);
		return action;
	}


	public static MayTransition createMayTransition() {
		return FACTORY.createMayTransition();
	}


	public static InputAction createInput(ModalIOAutomaton newTom, String string) {
		InputAction in= createInput(string);
		newTom.getInputs().add(in);
		return in;
	}


	public static OutputAction createOutput(ModalIOAutomaton newTom, String string) {
		OutputAction out= createOutput(string);
		newTom.getOutputs().add(out);
		return out;
	}


	public static InternalAction createInternal(ModalIOAutomaton newTom, String string) {
		InternalAction intt= createInternal(string);
		newTom.getInternals().add(intt);
		return intt;
	}

	public static MustTransition createEpsilonTransition(State start, State start2) {

		MustTransition mustTransition= MioFactory.eINSTANCE.createMustTransition();
		InternalAction inte= MioFactory.eINSTANCE.createInternalAction();
		inte.setLabel("Epsilon");
		mustTransition.setAction(inte);

		mustTransition.setFrom(start);
		mustTransition.setTo(start2);

		return mustTransition;
	}



}
