/*
 * This file has been developed at the University of Munich, Chair for Programming & Software Engineering.
 * 
 * This file is licensed under the Eclipse Public License (EPL) 1.0
 * 
 */
package eu.uml4soa.utbm.u2m.model;

import java.util.ArrayList;
import java.util.List;

public class CState {

	private String fName;

	private CAutomaton fAutomaton;

	public CState(CAutomaton cAutomaton, String name) {
		fAutomaton= cAutomaton;
		fName= name;
	}

	public void setAutomaton(CAutomaton cAutomaton) {
		fAutomaton= cAutomaton;
	}

	public String getName() {
		return fName;
	}

	public List<CTransition> getIncoming() {
		List<CTransition> incomings= new ArrayList<CTransition>();

		List<CTransition> transitions= fAutomaton.getTransitions();
		for (CTransition cTransition : transitions) {
			if (cTransition.getTo().equals(this))
				incomings.add(cTransition);
		}
		return incomings;
	}

	public List<CTransition> getOutgoing() {
		List<CTransition> outgoings= new ArrayList<CTransition>();

		List<CTransition> transitions= fAutomaton.getTransitions();
		for (CTransition cTransition : transitions) {
			if (cTransition.getFrom().equals(this))
				outgoings.add(cTransition);
		}
		return outgoings;
	}

	@Override
	public String toString() {
		return getName();
	}

	public boolean isErrorState() {
		List<CTransition> incoming= getIncoming();
		for (CTransition cTransition : incoming) {
			if (cTransition.isThrow())
				return true;
		}
		return false;
	}

	public void setName(String string) {
		fName= string;

	}

}
