/*
 * This file has been developed at the University of Munich, Chair for Programming & Software Engineering.
 * 
 * This file is licensed under the Eclipse Public License (EPL) 1.0
 * 
 */
package eu.uml4soa.utbm.ui.eclipse.actions;

import java.util.List;
import java.util.Map;

import org.eclipse.core.resources.IContainer;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.uml2.uml.Behavior;
import org.eclipse.uml2.uml.Class;

/**
 * Wizard with one input page for displaying transformation option to the user.
 * 
 * @author Philip Mayer
 * 
 */
public class SemanticsWizard extends Wizard implements IWizard {

	private SemanticsWizardPage fPage;

	private Map<org.eclipse.uml2.uml.Class, List<Behavior>> fAvailableBehaviours;

	private IContainer fOutputDirectory;

	private Map<Class, List<Behavior>> fSelectedBehaviours;

	private String fTitle;

	private boolean fOpen;

	public void init(Map<org.eclipse.uml2.uml.Class, List<Behavior>> availableActivities, IContainer outputDirectory, String title) {
		setWindowTitle(title);
		fTitle= title;
		setAvailableBehaviours(availableActivities);
		setOutputDirectory(outputDirectory);
	}

	@Override
	public void addPages() {

		super.addPages();
		fPage= new SemanticsWizardPage("selectPage");
		fPage.setTitle(fTitle);
		fPage.setDescription("Select behaviours to map to MIOs.");
		addPage(fPage);

		fPage.setActivityList(fAvailableBehaviours);
		fPage.setOutputDirectory(fOutputDirectory);
	}

	@Override
	public boolean performFinish() {
		fSelectedBehaviours= fPage.getSelectedBehaviours();
		fOutputDirectory= fPage.getOutputDirectory();
		fOpen= fPage.getOpen();
		return true;
	}

	@Override
	public boolean canFinish() {
		return fPage.getSelectedBehaviours().size() > 0;
	}


	public void setAvailableBehaviours(Map<org.eclipse.uml2.uml.Class, List<Behavior>> availableActivities) {
		fAvailableBehaviours= availableActivities;
	}

	public void setOutputDirectory(IContainer outputDirectory) {
		fOutputDirectory= outputDirectory;
	}

	public IContainer getOutputDirectory() {
		return fOutputDirectory;
	}

	public Map<Class, List<Behavior>> getSelectedBehaviours() {
		return fSelectedBehaviours;
	}

	public boolean getOpen() {
		return fOpen;
	}



}
