/*
 * This file has been developed at the University of Munich, Chair for Programming & Software Engineering.
 * 
 * This file is licensed under the Eclipse Public License (EPL) 1.0
 * 
 */
package eu.uml4soa.utbm.ui.eclipse.runner;

import java.util.LinkedHashMap;
import java.util.Map;

import net.miowb.model.mio.ModalIOAutomaton;

import org.eclipse.uml2.uml.Activity;
import org.eclipse.uml2.uml.Behavior;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.ProtocolStateMachine;


public class ParticipantSemantics {

	private Class fParticipant;

	private ModalIOAutomaton fImplementationSemantics;

	private Map<ProtocolStateMachine, ModalIOAutomaton> fProtocolSemantics;

	private Activity fActivity;

	public ParticipantSemantics(Class c) {
		fParticipant= c;
		fProtocolSemantics= new LinkedHashMap<ProtocolStateMachine, ModalIOAutomaton>();
	}

	public void setImplementation(Activity a, ModalIOAutomaton semantics) {
		fActivity= a;
		fImplementationSemantics= semantics;
	}

	public void addSemantics(ProtocolStateMachine behavior, ModalIOAutomaton semantics) {
		fProtocolSemantics.put(behavior, semantics);
	}

	public ModalIOAutomaton getImplementation() {
		return fImplementationSemantics;
	}

	public Map<Behavior, ModalIOAutomaton> getAvailableSemantics() {

		Map<Behavior, ModalIOAutomaton> allAv= new LinkedHashMap<Behavior, ModalIOAutomaton>();
		if (fActivity != null)
			allAv.put(fActivity, fImplementationSemantics);

		for (ProtocolStateMachine m : fProtocolSemantics.keySet())
			allAv.put(m, fProtocolSemantics.get(m));

		return allAv;
	}

	public ModalIOAutomaton getSemantics(String text) {

		Map<Behavior, ModalIOAutomaton> s= getAvailableSemantics();

		for (Behavior b : s.keySet()) {
			if (b.getName().equals(text))
				return s.get(b);
		}
		return null;
	}

	public Class getParticipant() {
		return fParticipant;
	}

}
