/*
 * This file has been developed at the University of Munich, Chair for Programming & Software Engineering.
 * 
 * This file is licensed under the Eclipse Public License (EPL) 1.0
 * 
 */
package eu.uml4soa.utbm.ui.md;

import java.awt.event.ActionEvent;

import javax.swing.JOptionPane;

import com.nomagic.magicdraw.actions.MDAction;
import com.nomagic.magicdraw.ui.dialogs.MDDialogParentProvider;

import eu.uml4soa.utbm.ui.md.api.UML4SOASemanticsMDPlugin;

public class UML4SOACleanAction extends MDAction {

	private static final long serialVersionUID= -308290885087927071L;

	public UML4SOACleanAction() {
		super("uml4soa_clean_problems_action", "Clean Problems", null, null);
	}

	@Override
	public void actionPerformed(ActionEvent e) {
		UML4SOASemanticsMDPlugin.getCurrentInstance().clearProblems();
		info("Problems have been cleared.");
	}

	private void info(String message) {
		JOptionPane.showMessageDialog(MDDialogParentProvider.getProvider().getDialogParent(), message, "UML4SOA", JOptionPane.INFORMATION_MESSAGE);

	}

}
