/*
 * This file has been developed at the University of Munich, Chair for Programming & Software Engineering.
 * 
 * This file is licensed under the Eclipse Public License (EPL) 1.0
 * 
 */
package eu.uml4soa.utbm.ui.md;

import java.awt.event.ActionEvent;

import javax.swing.JOptionPane;

import com.nomagic.magicdraw.actions.MDAction;
import com.nomagic.magicdraw.core.Application;
import com.nomagic.magicdraw.core.Project;
import com.nomagic.magicdraw.ui.dialogs.MDDialogParentProvider;
import com.nomagic.uml2.ext.magicdraw.auxiliaryconstructs.mdmodels.Model;

public class UML4SOAConvertToBPELAction extends MDAction {

	private static final long serialVersionUID= -308290885087927071L;

	public UML4SOAConvertToBPELAction() {
		super("uml4soa_convert_bpel_action", "Convert To Web Services...", null, null);
	}

	@Override
	public void actionPerformed(ActionEvent e) {


		Project project= Application.getInstance().getProject();

		if (project == null) {
			MDUtil.error("No open project.");
			return;
		}

		Model model= project.getModel();

		if (model == null) {
			MDUtil.error("No model in current project.");
			return;
		}



	}

	private void info(String message) {
		JOptionPane.showMessageDialog(MDDialogParentProvider.getProvider().getDialogParent(), message, "UML4SOA", JOptionPane.INFORMATION_MESSAGE);

	}

}
