/*
 * This file has been developed at the University of Munich, Chair for Programming & Software Engineering.
 * 
 * This file is licensed under the Eclipse Public License (EPL) 1.0
 * 
 */

package eu.uml4soa.utbm.ui.md;

import com.nomagic.actions.AMConfigurator;
import com.nomagic.actions.ActionsCategory;
import com.nomagic.actions.ActionsManager;
import com.nomagic.actions.NMAction;
import com.nomagic.magicdraw.actions.MDActionsCategory;


/**
 * Class for configuring main menu and adding new submenu.
 * 
 * @version $Date: 2007-10-05 09:51:43 +0300 (Fri, 05 Oct 2007) $ $Revision:
 *          52410 $
 * @author Donatas Simkunas
 */
public class UML4SOAMainMenuConfigurator implements AMConfigurator {

	// DONT ADD A NUMBER IN HERE!!!
	private static final String UML4SOA= "UMLSOA";

	/**
	 * Action will be added to manager.
	 */
	private NMAction fRefinementAction, fCompatibilityAction;

	private UML4SOACleanAction fCleanAction;

	private UML4SOAConvertToBPELAction fWSAction;

	private UML4SOAConvertToJavaAction fJavaAction;

	/**
	 * Creates configurator.
	 * 
	 * @param fRefinementAction action to be added to main menu.
	 */
	public UML4SOAMainMenuConfigurator() {
		fRefinementAction= new UML4SOARefinementAction();
		fCompatibilityAction= new UML4SOACompatibilityAction();
		fCleanAction= new UML4SOACleanAction();
		fWSAction= new UML4SOAConvertToBPELAction();
		fJavaAction= new UML4SOAConvertToJavaAction();
	}

	/**
	 * @see com.nomagic.actions.AMConfigurator#configure(ActionsManager) Methods
	 *      adds action to given manager Examples category.
	 */
	public void configure(ActionsManager mngr) {
		// searching for Examples action category
		ActionsCategory category= (ActionsCategory) mngr.getActionFor(UML4SOA);

		if (category == null) {
			// creating new category
			category= new MDActionsCategory(UML4SOA, "MDD4SOA");
			category.setNested(true);
			mngr.addCategory(category);
		}

		category.addAction(fRefinementAction);
		category.addAction(fCompatibilityAction);
		category.addAction(fCleanAction);

		category.addAction(fWSAction);
		category.addAction(fJavaAction);

	}

	public int getPriority() {
		return AMConfigurator.MEDIUM_PRIORITY;
	}

}
