/*
 * This file has been developed at the University of Munich, Chair for Programming & Software Engineering.
 * 
 * This file is licensed under the Eclipse Public License (EPL) 1.0
 * 
 */
package eu.uml4soa.utbm.ui.md.ui;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.Border;

import eu.uml4soa.utbm.ui.md.api.ServerClientConstants;

public class TheorySelectionDialog extends JDialog {

	private static final long serialVersionUID= 2751154616860759823L;

	protected boolean fIsOK;

	private JButton fOKButton;

	protected String fTheory;

	public static void main(String[] args) {
		JFrame frame= new JFrame();
		TheorySelectionDialog d= new TheorySelectionDialog(frame, "Verification", "Please select a verification method.");
		d.open();
	}

	public TheorySelectionDialog(Frame parent, String title, String message) {
		super(parent);

		setTitle(title);

		JPanel mainPanel= new JPanel();
		mainPanel.setLayout(new BorderLayout());
		add(mainPanel);

		Border padding= BorderFactory.createEmptyBorder(10, 10, 10, 10);
		mainPanel.setBorder(padding);

		JPanel top= new JPanel();
		JLabel l= new JLabel(message);
		top.add(l);
		mainPanel.add(top, BorderLayout.NORTH);

		JPanel upperPanel= new JPanel();
		upperPanel.setLayout(new GridLayout(3, 1));
		mainPanel.add(upperPanel);

		final JRadioButton box1= new JRadioButton("Loose verification. Check only for severe errors.");
		final JRadioButton box2= new JRadioButton("Normal verification. Standard check - use this if in doubt.");
		box2.setSelected(true);
		final JRadioButton box3= new JRadioButton("Hard verification. Check for exact implementation or compatibility.");

		ButtonGroup group= new ButtonGroup();
		group.add(box1);
		group.add(box2);
		group.add(box3);

		upperPanel.add(box1);
		upperPanel.add(box2);
		upperPanel.add(box3);


		JPanel bottom= new JPanel();
		bottom.setLayout(new FlowLayout(FlowLayout.TRAILING));
		mainPanel.add(bottom, BorderLayout.SOUTH);

		fOKButton= new JButton("Verify");
		fOKButton.addActionListener(new ActionListener() {

			@Override
			public void actionPerformed(ActionEvent e) {
				fIsOK= true;
				if (box1.isSelected())
					fTheory= ServerClientConstants.THEORY_SO;
				if (box2.isSelected())
					fTheory= ServerClientConstants.THEORY_WEAK;
				if (box3.isSelected())
					fTheory= ServerClientConstants.THEORY_STRONG;

				setVisible(false);
			}
		});
		JButton cancel= new JButton("Cancel");
		cancel.addActionListener(new ActionListener() {

			@Override
			public void actionPerformed(ActionEvent e) {
				fIsOK= false;
				setVisible(false);
			}
		});

		fOKButton.setEnabled(true);

		bottom.add(fOKButton);
		bottom.add(cancel);
	}

	protected void updateButtons() {
		fOKButton.setEnabled(true);
	}

	public boolean getResult() {
		return fIsOK;
	}

	public boolean open() {
		setModal(true);
		pack();
		centerOnScreen();
		setVisible(true);
		return fIsOK;
	}

	private void centerOnScreen() {
		Toolkit tk= Toolkit.getDefaultToolkit();
		Dimension screenSize= tk.getScreenSize();
		int screenHeight= screenSize.height;
		int screenWidth= screenSize.width;
		setLocation( (screenWidth - getWidth()) / 2, (screenHeight - getHeight()) / 3);
	}

	public String getSelectedCompatibility() {
		return fTheory;
	}

}
