/*
 * This file has been developed at the University of Munich, Chair for Programming & Software Engineering.
 * 
 * This file is licensed under the Eclipse Public License (EPL) 1.0
 * 
 */
package eu.uml4soa.utbm.ui.md.ui;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListSelectionModel;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class UMLElementSelectionDialog extends JDialog {

	private static final long serialVersionUID= 2751154616860759823L;

	protected boolean fIsOK;

	private Map<JList, SelectableElement> fSelections;

	private JList fLeftList;

	private JList fRightList;

	private JButton fOKButton;

	public UMLElementSelectionDialog(Frame parent, String title, String message, List<SelectableElement> set1, List<SelectableElement> set2) {
		super(parent);

		setTitle(title);

		JPanel mainPanel= new JPanel();
		mainPanel.setLayout(new BorderLayout());
		add(mainPanel);

		Border padding= BorderFactory.createEmptyBorder(10, 10, 10, 10);
		mainPanel.setBorder(padding);

		JPanel top= new JPanel();
		JLabel l= new JLabel(message);
		top.add(l);
		mainPanel.add(top, BorderLayout.NORTH);

		fSelections= new LinkedHashMap<JList, SelectableElement>();

		JPanel upperPanel= new JPanel();
		upperPanel.setLayout(new GridLayout(1, 2));
		mainPanel.add(upperPanel);

		fLeftList= createList(set1.toArray());
		fRightList= createList(set2.toArray());

		upperPanel.add(createScroller(fLeftList));
		upperPanel.add(createScroller(fRightList));

		JPanel bottom= new JPanel();
		bottom.setLayout(new FlowLayout(FlowLayout.TRAILING));
		mainPanel.add(bottom, BorderLayout.SOUTH);

		fOKButton= new JButton("Verify");
		fOKButton.addActionListener(new ActionListener() {

			@Override
			public void actionPerformed(ActionEvent e) {
				fIsOK= true;
				setVisible(false);
			}
		});
		JButton cancel= new JButton("Cancel");
		cancel.addActionListener(new ActionListener() {

			@Override
			public void actionPerformed(ActionEvent e) {
				fIsOK= false;
				setVisible(false);
			}
		});

		fOKButton.setEnabled(false);

		bottom.add(fOKButton);
		bottom.add(cancel);
	}

	private JScrollPane createScroller(JList list) {
		JScrollPane listScroller= new JScrollPane(list);
		listScroller.setPreferredSize(new Dimension(250, 200));
		return listScroller;
	}

	private JList createList(Object[] data) {
		final JList list= new JList(data);
		list.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
		list.setLayoutOrientation(JList.VERTICAL);
		list.setVisibleRowCount(-1);
		list.addListSelectionListener(new ListSelectionListener() {

			@Override
			public void valueChanged(ListSelectionEvent e) {
				fSelections.put(list, (SelectableElement) list.getSelectedValue());
				updateButtons();
			}
		});
		return list;
	}

	protected void updateButtons() {
		boolean okay= fSelections.get(fLeftList) != null && fSelections.get(fRightList) != null
				&& fSelections.get(fLeftList) != fSelections.get(fRightList);

		fOKButton.setEnabled(okay);
	}

	public boolean getResult() {
		return fIsOK;
	}

	public boolean open() {
		setModal(true);
		pack();
		centerOnScreen();
		setVisible(true);
		return fIsOK;
	}

	public SelectableElement getLeft() {
		return fSelections.get(fLeftList);
	}

	public SelectableElement getRight() {
		return fSelections.get(fRightList);
	}

	private void centerOnScreen() {
		Toolkit tk= Toolkit.getDefaultToolkit();
		Dimension screenSize= tk.getScreenSize();
		int screenHeight= screenSize.height;
		int screenWidth= screenSize.width;
		setLocation( (screenWidth - getWidth()) / 2, (screenHeight - getHeight()) / 3);
	}

}
