/*
 * This file has been developed at the University of Munich, Chair for Programming & Software Engineering.
 * 
 * This file is licensed under the Eclipse Public License (EPL) 1.0
 * 
 */
package eu.uml4soa.utbm.vnserver;

import org.eclipse.core.runtime.Status;
import org.eclipse.ui.IStartup;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

/**
 * The activator class controls the plug-in life cycle
 */
public class VerificationServerPlugin extends AbstractUIPlugin implements IStartup {

	// The plug-in ID
	public static final String PLUGIN_ID= "eu.uml4soa.semantics.verification";

	// The shared instance
	private static VerificationServerPlugin plugin;

	private UML4SOAVerificationServer fServer;

	/**
	 * The constructor
	 */
	public VerificationServerPlugin() {
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * org.eclipse.ui.plugin.AbstractUIPlugin#start(org.osgi.framework.BundleContext
	 * )
	 */
	public void start(BundleContext context) throws Exception {
		super.start(context);
		plugin= this;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * org.eclipse.ui.plugin.AbstractUIPlugin#stop(org.osgi.framework.BundleContext
	 * )
	 */
	public void stop(BundleContext context) throws Exception {
		plugin= null;
		super.stop(context);
	}

	/**
	 * Returns the shared instance
	 * 
	 * @return the shared instance
	 */
	public static VerificationServerPlugin getDefault() {
		return plugin;
	}

	public static void logError(Throwable e) {
		getDefault().getLog().log(new Status(Status.ERROR, PLUGIN_ID, e.getMessage(), e));
	}

	public static void logError(String message, Throwable e) {
		getDefault().getLog().log(new Status(Status.ERROR, PLUGIN_ID, message, e));
	}

	public static void logWarning(String message) {
		getDefault().getLog().log(new Status(Status.WARNING, PLUGIN_ID, message));
	}

	@Override
	public void earlyStartup() {
		fServer= new UML4SOAVerificationServer();
		fServer.listen();
	}


}
